/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.init;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcparamapply.TaxcParamApplyDataServiceHelper;

public class BaseInitOrgParamListPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (operationResult.isSuccess()) {
            String operateKey;
            FormOperate source = (FormOperate)args.getSource();
            switch (operateKey = source.getOperateKey()) {
                case "markfinish": {
                    this.doMarkFinish();
                    break;
                }
                case "cancelfinish": {
                    this.doCancelFinish();
                    break;
                }
                case "syncapplyform": {
                    this.doSyncApplyForm();
                }
            }
            this.getView().updateView();
        }
    }

    private void doSyncApplyForm() {
        Object org = this.getView().getFormShowParameter().getCustomParam("org");
        TaxResult result = TaxcParamApplyDataServiceHelper.getTaxcParamApplyByOrgIds(Collections.singletonList(Long.parseLong(String.valueOf(org))));
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return;
        }
        List data = (List)result.getData();
        List applyFormNumbers = data.stream().map(d -> d.getString("billno")).collect(Collectors.toList());
        String applyForm = String.join((CharSequence)";", applyFormNumbers);
        try (TXHandle h = TX.required();){
            try {
                this.updateBaseInitOrgParam(applyForm);
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    private void updateBaseInitOrgParam(String applyForm) {
        DynamicObject obj = this.getSelected();
        obj.set("applyform", (Object)applyForm);
        if (StringUtils.isNotBlank((CharSequence)applyForm)) {
            obj.set("status", (Object)"1");
            this.updateBaseInitConfig("1");
        }
        SaveServiceHelper.update((DynamicObject)obj);
    }

    private DynamicObject getSelected() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        ListSelectedRow row = rows.get(0);
        String billFormId = ((ListView)this.getView()).getBillFormId();
        return BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)billFormId);
    }

    private void doCancelFinish() {
        try (TXHandle h = TX.required();){
            try {
                if (this.updateBaseInitOrgParamStatus("0")) {
                    this.updateBaseInitConfig("0");
                }
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    private void doMarkFinish() {
        DynamicObject selected = this.getSelected();
        if (StringUtils.isBlank((CharSequence)selected.getString("applyform"))) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("applyform", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6682\u672a\u5173\u8054\u53c2\u6570\u5ba1\u6279\u7533\u8bf7\u5355\uff0c\u786e\u5b9a\u65e0\u9700\u4fee\u6539\u521d\u59cb\u5316\u7a0e\u52a1\u53c2\u6570\u5417\uff1f", (String)"BaseInitOrgParamListPlugin_0", (String)"taxc-tam", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
        } else {
            try (TXHandle h = TX.required();){
                try {
                    if (this.updateBaseInitOrgParamStatus("1")) {
                        this.updateBaseInitConfig("1");
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                }
            }
            this.showLicenseForm();
        }
    }

    private void showLicenseForm() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("license", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u524d\u5f80\u67e5\u770b", (String)"BaseInitOrgParamListPlugin_1", (String)"taxc-tam", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u6211\u77e5\u9053\u4e86", (String)"BaseInitOrgParamListPlugin_2", (String)"taxc-tam", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u6709\u7684\u521d\u59cb\u5316\u914d\u7f6e\u5185\u5bb9\u5168\u90e8\u5b8c\u6210\uff01\u5982\u9700\u6fc0\u6d3b\u7ec4\u7ec7\u7684\u7a0e\u52a1\u4e13\u4e1a\u5206\u7ec4\u8bb8\u53ef\uff0c\u4efb\u52a1\u5ba1\u6838\u5b8c\u6210\u540e\uff0c\u53ef\u524d\u5f80{\u7a0e\u52a1\u4e91-\u57fa\u7840\u8bbe\u7f6e-\u7a0e\u52a1\u8bb8\u53ef\u7ba1\u7406}\u6388\u6743\u3002", (String)"BaseInitOrgParamListPlugin_3", (String)"taxc-tam", (Object[])new Object[0]), "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("applyform".equals(event.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
                try (TXHandle h = TX.required();){
                    try {
                        if (this.updateBaseInitOrgParamStatus("1")) {
                            this.updateBaseInitConfig("1");
                        }
                    }
                    catch (Exception e) {
                        h.markRollback();
                    }
                }
                this.getView().updateView();
                this.showLicenseForm();
            }
        } else if ("license".equals(event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            this.drillLicenseFormPage();
        }
    }

    private void drillLicenseFormPage() {
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_templatetreelist");
        param.setBillFormId("tctb_license_from");
        param.getOpenStyle().setShowType(ShowType.NonModal);
        this.getView().showForm((FormShowParameter)param);
    }

    private boolean updateBaseInitOrgParamStatus(String finishStatus) {
        ListSelectedRowCollection rows = this.getSelectedRows();
        ListSelectedRow row = rows.get(0);
        String billFormId = ((ListView)this.getView()).getBillFormId();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)billFormId);
        if (finishStatus.equals(obj.getString("status"))) {
            return false;
        }
        obj.set("status", (Object)finishStatus);
        SaveServiceHelper.update((DynamicObject)obj);
        return true;
    }

    private void updateBaseInitConfig(String finishStatus) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = customParams.get("org");
        QFilter qFilter = new QFilter("org", "=", org);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"tam_base_init_config", (String)"id,isorgparamcomplete,pagestatus,modifytime,modifier", (QFilter[])new QFilter[]{qFilter});
        obj.set("isorgparamcomplete", (Object)finishStatus);
        obj.set("pagestatus", (Object)("1".equals(finishStatus) ? "5" : "4"));
        obj.set("modifytime", (Object)new Date());
        obj.set("modifier", (Object)RequestContext.getOrCreate().getCurrUserId());
        SaveServiceHelper.update((DynamicObject)obj);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getFieldName();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (fieldName.equals("basedataname")) {
            this.drillOrgParamListPage(customParams);
        }
        if (fieldName.equals("applyform")) {
            this.drillOrgParamApplyFormPage(customParams);
        }
    }

    private void drillOrgParamListPage(Map<String, Object> customParams) {
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_templatetreelist");
        param.setBillFormId("tctb_taxparam");
        String orgId = String.valueOf(customParams.get("org"));
        QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        param.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
        customParams.put("tamBaseInitOrg", customParams.get("org"));
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    private void drillOrgParamApplyFormPage(Map<String, Object> customParams) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId("tctb_param_apply");
        parameter.setStatus(OperationStatus.VIEW);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        parameter.setOpenStyle(openStyle);
        String orgId = String.valueOf(customParams.get("org"));
        QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        parameter.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
        customParams.put("tamBaseInitOrg", customParams.get("org"));
        parameter.setCustomParams(customParams);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

