/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.init;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;

public class BaseInitTaxMainListPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (operationResult.isSuccess()) {
            String operateKey;
            FormOperate source = (FormOperate)args.getSource();
            switch (operateKey = source.getOperateKey()) {
                case "markfinish": {
                    this.doMarkFinish();
                    break;
                }
                case "cancelfinish": {
                    this.doCancelFinish();
                }
            }
            this.getView().updateView();
        }
    }

    private void doCancelFinish() {
        try (TXHandle h = TX.required();){
            try {
                if (this.updateBaseInitTaxMainStatus("0")) {
                    this.updateBaseInitConfig("0");
                }
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    private void doMarkFinish() {
        try (TXHandle h = TX.required();){
            try {
                if (this.updateBaseInitTaxMainStatus("1")) {
                    this.updateBaseInitConfig("1");
                }
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    private boolean updateBaseInitTaxMainStatus(String finishStatus) {
        ListSelectedRowCollection rows = this.getSelectedRows();
        ListSelectedRow row = rows.get(0);
        String billFormId = ((ListView)this.getView()).getBillFormId();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)billFormId);
        if (finishStatus.equals(obj.getString("status"))) {
            return false;
        }
        obj.set("status", (Object)finishStatus);
        SaveServiceHelper.update((DynamicObject)obj);
        return true;
    }

    private void updateBaseInitConfig(String finishStatus) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = customParams.get("org");
        QFilter qFilter = new QFilter("org", "=", org);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"tam_base_init_config", (String)"id,isorgcomplete,istaxmaincomplete,pagestatus,modifytime,modifier", (QFilter[])new QFilter[]{qFilter});
        obj.set("istaxmaincomplete", (Object)finishStatus);
        obj.set("pagestatus", (Object)("1".equals(finishStatus) ? "2" : "1"));
        obj.set("modifytime", (Object)new Date());
        obj.set("modifier", (Object)RequestContext.getOrCreate().getCurrUserId());
        SaveServiceHelper.update((DynamicObject)obj);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = customParams.get("org");
        if (this.isOrgTaxMainExists(org)) {
            this.drillEditPage(customParams, org);
        } else {
            this.drillListPage(customParams, org);
        }
    }

    private void drillListPage(Map<String, Object> customParams, Object org) {
        String orgId = String.valueOf(org);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tctb_tax_info_home");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setShowTitle(true);
        showParameter.setCustomParam("listOrgId", (Object)String.valueOf(orgId));
        showParameter.setCustomParam("menuFlag", (Object)"true");
        this.getView().showForm(showParameter);
    }

    private boolean isOrgTaxMainExists(Object org) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsWithNoStatus(Collections.singletonList(Long.parseLong(String.valueOf(org))), null);
        return result.isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)result.getData()));
    }

    private void drillEditPage(Map<String, Object> customParams, Object org) {
        String orgId = String.valueOf(org);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tctb_tax_info_home");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setShowTitle(true);
        showParameter.setCustomParam("listOrgId", (Object)String.valueOf(orgId));
        this.getView().showForm(showParameter);
    }
}

