/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.init.event;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.bos.util.JSONUtils;
import kd.taxc.bdtaxr.common.helper.tctb.packaudit.PackAuditTaskServiceHelper;
import kd.taxc.bdtaxr.formplugin.init.OrgInitConfigItemEnum;

public class OrgInitConfigEventServicePlugin
implements IEventServicePlugin {
    private static Log LOGGER = LogFactory.getLog(OrgInitConfigEventServicePlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        LOGGER.info("TaxcOrgEventServiceDemoPlugin,event id:{},number:{}", (Object)evt.getEventNumber(), (Object)evt.getEventId());
        try {
            List idStrList;
            List paramList = (List)SerializationUtils.fromJsonString((String)evt.getSource(), List.class);
            if (!CollectionUtils.isEmpty((Collection)paramList) && !CollectionUtils.isEmpty((Collection)(idStrList = (List)((LinkedHashMap)paramList.get(0)).get("ids")))) {
                List<Long> ids = idStrList.stream().map(Long::parseLong).collect(Collectors.toList());
                this.doBusiness(ids);
            }
        }
        catch (Exception ex) {
            LOGGER.error("OrgInitConfigEventServicePlugin error." + ex.getMessage(), (Throwable)ex);
        }
        return evt.getEventId();
    }

    private void doBusiness(List<Long> ids) {
        ids.removeAll(this.queryExistsOrg(ids));
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.insertBaseConfig(ids);
        PackAuditTaskServiceHelper.syncBaseInitConfig(ids, (String)"save");
        DynamicObject[] savedObjs = this.queryConfigListByOrgs(ids);
        if (savedObjs.length > 0) {
            for (DynamicObject savedObj : savedObjs) {
                savedObj.set("billno", (Object)savedObj.getString("org.number"));
            }
            SaveServiceHelper.update((DynamicObject[])savedObjs);
        }
        for (DynamicObject savedObj : savedObjs) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("orgNumber", savedObj.getString("org.number"));
            params.put("orgName", savedObj.getString("org.name"));
            try {
                EventServiceHelper.triggerEventSubscribe((String)"tam.base_init.save", (String)JSONUtils.toString(params));
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
            }
        }
    }

    private List<Long> queryExistsOrg(List<Long> ids) {
        DynamicObject[] objs = this.queryConfigListByOrgs(ids);
        return Arrays.stream(objs).map(o -> o.getLong("org_id")).collect(Collectors.toList());
    }

    private DynamicObject[] queryConfigListByOrgs(List<Long> ids) {
        QFilter orgFilter = new QFilter("org", "in", ids);
        return BusinessDataServiceHelper.load((String)"tam_base_init_config", (String)"billno,org", (QFilter[])new QFilter[]{orgFilter});
    }

    private void insertBaseConfig(List<Long> orgs) {
        try (TXHandle h = TX.required();){
            try {
                this.doInsertBaseConfig(orgs);
                this.doInsertSubBaseConfigBill(orgs);
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                h.markRollback();
            }
        }
    }

    private void doInsertBaseConfig(List<Long> orgs) {
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(orgs.size());
        for (Long org : orgs) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"tam_base_init_config");
            obj.set("billstatus", (Object)"A");
            obj.set("org", (Object)org);
            obj.set("isorgcomplete", (Object)"0");
            obj.set("istaxmaincomplete", (Object)"0");
            obj.set("isorgmappingcomplete", (Object)"0");
            obj.set("isorggroupcomplete", (Object)"0");
            obj.set("isorgparamcomplete", (Object)"0");
            obj.set("pagestatus", (Object)"1");
            objs.add(obj);
        }
        SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[0]));
    }

    private void doInsertSubBaseConfigBill(List<Long> orgs) {
        this.insertBaseInitOrg(orgs);
        this.insertBaseInitTaxMain(orgs);
        this.insertBaseInitOrgMapping(orgs);
        this.insertBaseInitOrgGroup(orgs);
        this.insertBaseInitOrgParam(orgs);
    }

    private void insertBaseInitOrgParam(List<Long> orgs) {
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(orgs.size());
        for (Long org : orgs) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)OrgInitConfigItemEnum.ORG_PARAM.getMeta());
            obj.set("org", (Object)org);
            obj.set("basedataname", (Object)"param");
            obj.set("status", (Object)"0");
            objs.add(obj);
        }
        SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[0]));
    }

    private void insertBaseInitOrgGroup(List<Long> orgs) {
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(orgs.size());
        for (Long org : orgs) {
            DynamicObject tcvatGroup = BusinessDataServiceHelper.newDynamicObject((String)OrgInitConfigItemEnum.ORG_GROUP.getMeta());
            DynamicObject tccitGroup = BusinessDataServiceHelper.newDynamicObject((String)OrgInitConfigItemEnum.ORG_GROUP.getMeta());
            DynamicObject tcretGroup = BusinessDataServiceHelper.newDynamicObject((String)OrgInitConfigItemEnum.ORG_GROUP.getMeta());
            tcvatGroup.set("org", (Object)org);
            tcvatGroup.set("basedataname", (Object)"zzs");
            tcvatGroup.set("status", (Object)"0");
            tccitGroup.set("org", (Object)org);
            tccitGroup.set("basedataname", (Object)"qysds");
            tccitGroup.set("status", (Object)"0");
            tcretGroup.set("org", (Object)org);
            tcretGroup.set("basedataname", (Object)"sljsjj");
            tcretGroup.set("status", (Object)"0");
            objs.add(tcvatGroup);
            objs.add(tccitGroup);
            objs.add(tcretGroup);
        }
        SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[0]));
    }

    private void insertBaseInitOrgMapping(List<Long> orgs) {
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(orgs.size());
        for (Long org : orgs) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)OrgInitConfigItemEnum.ORG_MAPPING.getMeta());
            obj.set("org", (Object)org);
            obj.set("basedataname", (Object)"mapping");
            obj.set("status", (Object)"0");
            objs.add(obj);
        }
        SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[0]));
    }

    private void insertBaseInitTaxMain(List<Long> orgs) {
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(orgs.size());
        for (Long org : orgs) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)OrgInitConfigItemEnum.TAX_MAIN.getMeta());
            obj.set("org", (Object)org);
            obj.set("basedataname", (Object)"taxmain");
            obj.set("status", (Object)"0");
            objs.add(obj);
        }
        SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[0]));
    }

    private void insertBaseInitOrg(List<Long> orgs) {
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(orgs.size());
        for (Long org : orgs) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)OrgInitConfigItemEnum.ORG.getMeta());
            obj.set("org", (Object)org);
            obj.set("basedataname", (Object)"org");
            obj.set("status", (Object)"0");
            objs.add(obj);
        }
        SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[0]));
    }
}

