/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.progress;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.IFormView;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.StepsOption;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.bdtaxr.formplugin.taxdeclare.helper.MultiDeclarePageOpenHelper;
import kd.taxc.tam.common.enums.SsbColEnum;
import kd.taxc.tam.common.enums.SsbTotalGroupEnum;
import kd.taxc.tam.common.enums.WizardapEnum;

public class SsbProcessQueryRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String DEFAULT_ORGS = "defaultorgs";

    public void registerListener(EventObject e) {
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        MulBasedataEdit org = (MulBasedataEdit)this.getView().getControl("orgs");
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object taxtype = customParams.get("taxtype");
        Object orgids = customParams.get("orgids");
        Object declareDate = customParams.get("declareDate");
        Object status = customParams.get("statusList");
        if (Objects.nonNull(taxtype) && Objects.nonNull(orgids) && Objects.nonNull(declareDate)) {
            List orgList = (List)orgids;
            Object[] objects = orgList.toArray();
            List taxtypeList = (List)taxtype;
            Object[] taxtypes = taxtypeList.toArray();
            this.getModel().setValue("taxtype", (Object)taxtypes);
            this.getModel().setValue("orgs", (Object)objects);
            this.getModel().setValue("datefield", declareDate);
            String orgStr = Arrays.stream(objects).map(v -> String.valueOf(v)).collect(Collectors.joining(","));
            this.getPageCache().put(DEFAULT_ORGS, orgStr);
            ReportQueryParam queryParam = this.getQueryParam();
            Map customParam = queryParam.getCustomParam();
            customParam.put("statusList", status);
            queryParam.setCustomParam(customParam);
            ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
            reportFilter.search();
        } else {
            this.initOrg();
            this.initTaxtype();
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
    }

    private void initTaxtype() {
        Object[] taxtypes = new Object[]{1L};
        this.getModel().setValue("taxtype", (Object)taxtypes);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String sbbnocol = hyperLinkClickEvent.getRowData().getString("sbbnocol");
        String sbbtypecol = hyperLinkClickEvent.getRowData().getString("sbbtypecol");
        MultiDeclarePageOpenHelper.openDeclareSbb((IFormView)this.getView(), (String)sbbtypecol, null, (String)sbbnocol, null);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Date datefield = (Date)this.getModel().getValue("datefield");
        if (EmptyCheckUtils.isEmpty((Object)datefield)) {
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("group".equals(name)) {
            this.getView().refresh();
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        this.initOrg();
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        this.clearUserSetting();
        this.createDynamicCol();
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
        this.createTrueQFilterList(queryParam);
        super.beforeQuery(queryParam);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.setBoard();
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
        IDataModel iDataModel = this.getView().getModel();
        ReportFilter reportFilter = (ReportFilter)this.getView().getControl("reportfilterap");
        String showFields = reportFilter.getShowFilterFields();
        if (StringUtils.isNotBlank((CharSequence)showFields)) {
            List showFieldList = (List)JsonUtil.fromJson((String)showFields, List.class);
            String msg = this.formatShowFilter(showFieldList, iDataModel);
            evt.setFormatedFilterString(msg);
        }
    }

    private void initOrg() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgids = customParams.get("orgids");
        if (Objects.nonNull(orgids)) {
            List orgList = (List)orgids;
            Object[] objects = orgList.toArray();
            this.getModel().setValue("orgs", (Object)objects);
        } else {
            HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
            String orgStr = col.stream().map(v -> v.getString("id")).collect(Collectors.joining(","));
            this.getPageCache().put(DEFAULT_ORGS, orgStr);
            ArrayList<Long> initOrg = new ArrayList<Long>();
            Object object = this.getModel().getValue("orgs");
            if (object == null || object instanceof DynamicObjectCollection) {
                Long orgId = RequestContext.get().getOrgId();
                if (!CollectionUtils.isEmpty((Collection)col)) {
                    Optional<Long> matchOrg = col.stream().filter(e -> e.getLong("id") == orgId.longValue()).map(e -> e.getLong("id")).findFirst();
                    if (matchOrg.isPresent()) {
                        initOrg.add(orgId);
                    } else {
                        initOrg.add(((DynamicObject)col.get(0)).getLong("id"));
                    }
                    this.getModel().setValue("orgs", (Object)initOrg.toArray());
                }
            }
        }
    }

    private void setBoard() {
        WizardapEnum[] wizardapEnumVals;
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        ReportListModel reportModel = (ReportListModel)reportList.getReportModel();
        int rowCount = reportModel.getRowCount();
        DynamicObjectCollection rowData = reportModel.getRowData(0, rowCount);
        List dynamicObjectList = rowData.stream().filter(r -> !"0".equalsIgnoreCase(r.getString("id"))).collect(Collectors.toList());
        Wizard wizard = (Wizard)this.getControl("wizardap");
        List stepsOptions = wizard.getStepsOptions();
        stepsOptions.clear();
        for (WizardapEnum wizardapEnumVal : wizardapEnumVals = WizardapEnum.values()) {
            StepsOption stepsOption = new StepsOption();
            stepsOption.setTitle(new LocaleString(wizardapEnumVal.getName()));
            stepsOption.setStatus("wait");
            if (EmptyCheckUtils.isEmpty(dynamicObjectList)) {
                stepsOption.setDescription(new LocaleString("0.00%"));
            } else {
                BigDecimal bigDecimal = BigDecimalUtil.divideObject((Object)dynamicObjectList.stream().filter(v -> wizardapEnumVal.getFieldKeys().contains(v.getString(wizardapEnumVal.getDeclareStatus())) && wizardapEnumVal.getFieldKeys().contains(v.getString(wizardapEnumVal.getPayStatus()))).count(), (Object)dynamicObjectList.size(), (int)4);
                stepsOption.setDescription(new LocaleString(BigDecimalUtil.multiplyObject((Object)bigDecimal, (Object)100, (int)2) + "%"));
            }
            this.doSetProcess(wizardapEnumVal, stepsOption);
            stepsOptions.add(stepsOption);
        }
        wizard.setWizardStepsOptions(stepsOptions);
    }

    private void doSetProcess(WizardapEnum wizardapEnumVal, StepsOption stepsOption) {
        LocaleString process = stepsOption.getDescription();
        if (wizardapEnumVal == WizardapEnum.WBZ) {
            this.getModel().setValue("wbz_process", (Object)process.getLocaleValue());
        } else if (wizardapEnumVal == WizardapEnum.SBZ) {
            this.getModel().setValue("sbz_process", (Object)process.getLocaleValue());
        } else if (wizardapEnumVal == WizardapEnum.WSB) {
            this.getModel().setValue("sbsb_process", (Object)process.getLocaleValue());
        } else if (wizardapEnumVal == WizardapEnum.SBCG) {
            this.getModel().setValue("sbcg_process", (Object)process.getLocaleValue());
        } else if (wizardapEnumVal == WizardapEnum.WJK) {
            this.getModel().setValue("jksb_process", (Object)process.getLocaleValue());
        } else if (wizardapEnumVal == WizardapEnum.JKCG) {
            this.getModel().setValue("jkcg_process", (Object)process.getLocaleValue());
        }
    }

    public void orgAddBeforeF7SelectListener(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
        formShowParameter.getCustomParams().put("orgFuncId", "40");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"SsbProcessQueryRptPlugin_0", (String)"taxc-tam", (Object[])new Object[0]));
        List<Long> orgIds = this.getOrgListHasPermission();
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByIsTaxpayer();
        List taxpayerOrgIds = ((List)result.getData()).stream().map(o -> o.getLong("taxorg.id")).collect(Collectors.toList());
        orgIds = orgIds.stream().filter(taxpayerOrgIds::contains).collect(Collectors.toList());
        QFilter orgIdsFilter = new QFilter("id", "in", orgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
    }

    private void clearUserSetting() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParams().get("formId");
        String configKey = formId + "_reportlistap_gridConfig";
        UserConfigServiceHelper.clearSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)configKey);
    }

    private void createDynamicCol() {
        Object val = this.getView().getModel().getValue("group");
        if (ObjectUtils.isEmpty((Object)val)) {
            return;
        }
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List reportColumnList = listTable.getColumns();
        SsbColEnum firstColEnum = SsbTotalGroupEnum.getEnumByCode(String.valueOf(val)).getFirstColEnum();
        ReportColumn firstReportColumn = null;
        int index = 0;
        for (int i = 0; i < reportColumnList.size(); ++i) {
            ReportColumn temp = (ReportColumn)reportColumnList.get(i);
            if (i == 0 && temp.getFieldKey().equalsIgnoreCase(firstColEnum.getRowMetaMsgInfo().getFieldId())) break;
            if (!temp.getFieldKey().equalsIgnoreCase(firstColEnum.getRowMetaMsgInfo().getFieldId())) continue;
            firstReportColumn = temp;
            index = i;
            break;
        }
        if (null != firstReportColumn && 0 != index) {
            reportColumnList.remove(index);
            reportColumnList.add(0, firstReportColumn);
        }
    }

    private String formatShowFilter(List<String> fields, IDataModel model) {
        StringBuilder msg = new StringBuilder();
        BindingContext bindingContext = new BindingContext((Object)model.getDataEntity());
        for (String field : fields) {
            FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(field);
            if (fieldEdit == null) {
                return null;
            }
            Object value = fieldEdit.getBindingValue(bindingContext);
            Object valDesc = this.getValueDesc(value, fieldEdit.getProperty());
            if (valDesc == null || !StringUtils.isNotEmpty((CharSequence)valDesc.toString())) continue;
            if (msg.length() > 0) {
                msg.append(";  ");
            }
            msg.append(fieldEdit.getProperty().getDisplayName()).append(':').append(' ').append(valDesc);
        }
        return msg.toString();
    }

    private Object getValueDesc(Object value, IDataEntityProperty prop) {
        Object valDesc = "";
        if (value == null) {
            return valDesc;
        }
        if (!(prop instanceof BasedataProp) && !(prop instanceof MulBasedataProp)) {
            valDesc = prop instanceof ComboProp ? ((ComboProp)prop).getItemByName(value.toString()) : (prop instanceof DateProp || prop instanceof DateTimeProp ? DateUtils.format((Date)DateUtils.stringToDate((String)((String)value)), (String)"yyyy-MM") : (prop instanceof BooleanProp ? (Boolean.parseBoolean(value.toString()) ? ResManager.loadKDString((String)"\u662f", (String)"SsbProcessQueryRptPlugin_1", (String)"taxc-tam", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"SsbProcessQueryRptPlugin_2", (String)"taxc-tam", (Object[])new Object[0])) : value));
        } else if (value instanceof ArrayList) {
            ArrayList<String> valueDescList = new ArrayList<String>();
            for (Object valueArray : (List)value) {
                Object[] valArray = (Object[])valueArray;
                String newValueDesc = null;
                if (valArray.length >= 2) {
                    String string = newValueDesc = valArray[1] == null ? "" : valArray[1].toString();
                }
                if (!kd.bos.util.StringUtils.isNotEmpty(newValueDesc)) continue;
                valueDescList.add(newValueDesc);
            }
            valDesc = String.join((CharSequence)";", valueDescList);
        } else {
            Object[] valArray = (Object[])value;
            if (valArray.length >= 2) {
                valDesc = valArray[1] == null ? "" : valArray[1].toString();
            }
        }
        return valDesc;
    }

    private void createTrueQFilterList(ReportQueryParam queryParam) {
        List itemInfos = queryParam.getFilter().getFilterItems();
        itemInfos.removeIf(item -> item.getPropName().equals("group") || item.getPropName().equals("orgs"));
        FilterItemInfo dimensionInfo = new FilterItemInfo();
        dimensionInfo.setPropName("group");
        dimensionInfo.setValue(this.getModel().getValue("group"));
        queryParam.getFilter().getFilterItems().add(dimensionInfo);
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getView().getModel().getValue("orgs");
        if (EmptyCheckUtils.isEmpty((Object)this.getPageCache().get(DEFAULT_ORGS))) {
            throw new KDBizException("user no right");
        }
        List orgids = EmptyCheckUtils.isEmpty((Object)dynamicObjects) ? Arrays.stream(this.getPageCache().get(DEFAULT_ORGS).split(",")).map(v -> Long.parseLong(v)).collect(Collectors.toList()) : dynamicObjects.stream().map(v -> ((DynamicObject)v.get(1)).getLong("id")).collect(Collectors.toList());
        FilterItemInfo org = new FilterItemInfo();
        org.setPropName("orgs");
        org.setValue(orgids);
        queryParam.getFilter().getFilterItems().add(org);
    }

    private List<Long> getOrgListHasPermission() {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        if (!CollectionUtils.isEmpty((Collection)col)) {
            for (DynamicObject obj : col) {
                orgIds.add(obj.getLong("id"));
            }
        }
        return orgIds;
    }
}

