/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.progress;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tam.business.progress.DeclareProgressService;
import kd.taxc.tam.common.entity.RowMetaMsgInfo;
import kd.taxc.tam.common.enums.SsbColEnum;
import kd.taxc.tam.common.enums.SsbTotalGroupEnum;
import kd.taxc.tam.common.enums.WizardapEnum;
import org.apache.commons.collections.CollectionUtils;

public class SsbProcessQueryRptQueryPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        return this.getFilter(reportQueryParam);
    }

    private DataSet getFilter(ReportQueryParam reportQueryParam) {
        List declareDataList;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List filterItemInfos = filterInfo.getFilterItems();
        Object status = reportQueryParam.getCustomParam().get("statusList");
        if (CollectionUtils.isEmpty((Collection)filterItemInfos)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"SsbProcessQueryRptQueryPlugin_0", (String)"taxc-tam", (Object[])new Object[0]));
        }
        FilterItemInfo orgItemInfo = null;
        FilterItemInfo groupItemInfo = null;
        FilterItemInfo dateItemInfo = null;
        for (FilterItemInfo itemInfo : filterItemInfos) {
            if (itemInfo.getPropName().equalsIgnoreCase("orgs")) {
                orgItemInfo = itemInfo;
                continue;
            }
            if (itemInfo.getPropName().equalsIgnoreCase("group")) {
                groupItemInfo = itemInfo;
                continue;
            }
            if (!itemInfo.getPropName().equalsIgnoreCase("datefield")) continue;
            dateItemInfo = itemInfo;
        }
        if (null == orgItemInfo || null == groupItemInfo || null == dateItemInfo) {
            return null;
        }
        List<Long> typeIds = Objects.nonNull(filterInfo.getValue("taxtype")) ? ((DynamicObjectCollection)filterInfo.getValue("taxtype")).stream().map(e -> e.getLong("id")).collect(Collectors.toList()) : DeclareProgressService.getTaxtypeId();
        List templateTypeIds = null;
        if (Objects.nonNull(filterInfo.getValue("templatetype"))) {
            templateTypeIds = ((DynamicObjectCollection)filterInfo.getValue("templatetype")).stream().map(e -> e.getString("number")).collect(Collectors.toList());
        }
        List orgids = (List)orgItemInfo.getValue();
        Date declareDate = dateItemInfo.getDate();
        List rawDataList = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TaxableListService", (String)"queryFromDb", (Object[])new Object[]{orgids, typeIds, declareDate, templateTypeIds});
        if (Objects.nonNull(status)) {
            WizardapEnum datastatus = WizardapEnum.valueOf(String.valueOf(status));
            declareDataList = rawDataList.stream().filter(e -> datastatus.getFieldKeys().contains(String.valueOf(e.get("declarestatus"))) && datastatus.getFieldKeys().contains(String.valueOf(e.get("paystatus")))).collect(Collectors.toList());
        } else {
            declareDataList = rawDataList;
        }
        String groupCode = String.valueOf(groupItemInfo.getValue());
        SsbTotalGroupEnum groupEnum = SsbTotalGroupEnum.getEnumByCode(groupCode);
        SsbColEnum firstColEnum = groupEnum.getFirstColEnum();
        RowMetaMsgInfo firstColMetaInfo = firstColEnum.getRowMetaMsgInfo();
        String fieldId = firstColMetaInfo.getFieldId();
        List<RowMetaMsgInfo> cols = SsbColEnum.createDynamicCol(fieldId);
        RowMetaMsgInfo groupCol = cols.get(0);
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        Map<String, List<Map>> taxtypeGroupData = declareDataList.stream().collect(Collectors.groupingBy(k -> String.valueOf(k.get(groupCol.getQueryFiled()))));
        for (Map.Entry<String, List<Map>> entry : taxtypeGroupData.entrySet()) {
            Object[] resRowData;
            for (Map map : entry.getValue()) {
                resRowData = this.createRow(map, cols);
                coll.add(resRowData);
            }
            resRowData = this.createTotalRow(entry.getValue().get(0), cols, entry.getValue().size());
            coll.add(resRowData);
        }
        RowMeta rowMeta = SsbProcessQueryRptQueryPlugin.createRowMeta(cols);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "ssbprocessqueryrpt")).createDataSet(new Input[]{inputs});
    }

    private Object[] createTotalRow(Map<String, Object> tempMap, List<RowMetaMsgInfo> cols, int totalSize) {
        Object[] row = new Object[cols.size()];
        RowMetaMsgInfo firstCol = cols.get(0);
        row[0] = tempMap.get(firstCol.getQueryFiled());
        for (int i = 1; i < cols.size(); ++i) {
            row[i] = cols.get(i).getFieldId().equalsIgnoreCase(SsbColEnum.SQSSQ.getRowMetaMsgInfo().getFieldId()) ? ResManager.loadKDString((String)"\u5408\u8ba1:", (String)"SsbProcessQueryRptQueryPlugin_1", (String)"taxc-tam", (Object[])new Object[0]) + "   " + totalSize : (cols.get(i).getFieldId().equalsIgnoreCase(SsbColEnum.ID.getRowMetaMsgInfo().getFieldId()) ? Integer.valueOf(0) : "");
        }
        return row;
    }

    private Object[] createRow(Map<String, Object> tempMap, List<RowMetaMsgInfo> cols) {
        Object[] row = new Object[cols.size()];
        int index = 0;
        for (RowMetaMsgInfo ssbColEnum : cols) {
            if (ssbColEnum.getFieldId().equalsIgnoreCase(SsbColEnum.SQSSQ.getRowMetaMsgInfo().getFieldId())) {
                String dbField = ssbColEnum.getQueryFiled();
                String[] dbFields = dbField.split(",");
                row[index++] = DateUtils.format((Date)((Date)tempMap.get(dbFields[0])), (String)DateUtils.YYYYMMDD_CHINESE) + '-' + DateUtils.format((Date)((Date)tempMap.get(dbFields[1])), (String)DateUtils.YYYYMMDD_CHINESE);
                continue;
            }
            row[index++] = tempMap.get(ssbColEnum.getQueryFiled());
        }
        return row;
    }

    public static RowMeta createRowMeta(List<RowMetaMsgInfo> rowMetaMsgInfos) {
        String[] fields = new String[rowMetaMsgInfos.size()];
        DataType[] dataTypes = new DataType[rowMetaMsgInfos.size()];
        int i = 0;
        for (RowMetaMsgInfo rowMetaMsgInfo : rowMetaMsgInfos) {
            fields[i] = rowMetaMsgInfo.getDisplayField();
            dataTypes[i] = rowMetaMsgInfo.getDataType();
            ++i;
        }
        return RowMetaFactory.createRowMeta((String[])fields, (DataType[])dataTypes);
    }
}

