/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.progress;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.tam.business.progress.DeclareProgressService;
import kd.taxc.tam.common.enums.WizardapEnum;
import org.apache.commons.collections.CollectionUtils;

public class TaxDeclareProgressCardPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(TaxDeclareProgressCardPlugin.class);

    public void afterCreateNewData(EventObject e) {
        this.createBar();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BarChart barChart = (BarChart)this.getView().getControl("barchartap");
        barChart.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String statusName = ((ChartClickEvent)evt).getSeriesName();
        if (StringUtil.isNotBlank((CharSequence)statusName)) {
            WizardapEnum status = WizardapEnum.getStatus(statusName);
            Date declareDate = (Date)this.getView().getParentView().getModel().getValue("declaredate");
            if (Objects.isNull(this.getView().getParentView()) || Objects.isNull((Date)this.getView().getParentView().getModel().getValue("declaredate"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7533\u62a5\u6708\u4efd", (String)"TaxDeclareProgressCardPlugin_0", (String)"taxc-tam", (Object[])new Object[0]));
                return;
            }
            String taxName = ((ChartClickEvent)evt).getName();
            List<Long> orgids = this.getOrgids();
            ReportShowParameter rsp = new ReportShowParameter();
            rsp.setFormId("tam_sbb_process_query");
            rsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            rsp.setCustomParam("taxtype", Collections.singletonList(DeclareProgressService.getIdByName(taxName)));
            rsp.setCustomParam("orgids", orgids);
            rsp.setCustomParam("declareDate", (Object)declareDate);
            rsp.setCustomParam("statusList", (Object)status);
            this.getView().showForm((FormShowParameter)rsp);
        }
    }

    private void createBar() {
        Date declareDate;
        if (Objects.isNull(this.getView().getParentView())) {
            logger.error("\u7236\u7ea7\u754c\u9762getView().getParentView()\u4e3a\u7a7a");
        }
        if (Objects.isNull(declareDate = (Date)this.getView().getParentView().getModel().getValue("declaredate"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7533\u62a5\u6708\u4efd", (String)"TaxDeclareProgressCardPlugin_0", (String)"taxc-tam", (Object[])new Object[0]));
            return;
        }
        List<Long> orgids = this.getOrgids();
        List declareDataList = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TaxableListService", (String)"queryFromDb", (Object[])new Object[]{orgids, DeclareProgressService.getTaxtypeId(), declareDate});
        HashMap<String, Integer> taxtypeClassifyMap = new HashMap<String, Integer>();
        Map<Long, List<Map>> taxtypeGroupData = declareDataList.stream().collect(Collectors.groupingBy(e -> (Long)e.get("taxcatetory")));
        for (Map.Entry<Long, List<Map>> entry : taxtypeGroupData.entrySet()) {
            Long taxtype = entry.getKey();
            List<Map<String, Object>> value = entry.getValue();
            this.classifyTaxtypeData(String.valueOf(taxtype), value, taxtypeClassifyMap);
        }
        BarChart customchart = this.getMainChart();
        customchart.clearData();
        List<Long> yKeys = taxtypeGroupData.keySet().stream().sorted(Long::compareTo).collect(Collectors.toList());
        List<String> yNames = DeclareProgressService.getYname(taxtypeGroupData.keySet());
        this.createCategoryAxis("", yNames, false);
        this.createValueAxis("", true);
        this.setBarSeries(yKeys, taxtypeClassifyMap, WizardapEnum.WBZ.getName(), "#A80B00");
        this.setBarSeries(yKeys, taxtypeClassifyMap, WizardapEnum.SBZ.getName(), "#16B0F1");
        this.setBarSeries(yKeys, taxtypeClassifyMap, WizardapEnum.WSB.getName(), "#FB2323");
        this.setBarSeries(yKeys, taxtypeClassifyMap, WizardapEnum.SBCG.getName(), "#77C404");
        this.setBarSeries(yKeys, taxtypeClassifyMap, WizardapEnum.WJK.getName(), "#FFB44A");
        this.setBarSeries(yKeys, taxtypeClassifyMap, WizardapEnum.JKCG.getName(), "#1BA854");
        customchart.setMargin(Position.right, "30px");
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setLegendVertical(false);
        customchart.setLegendPropValue("padding", (Object)new Integer[]{0, 30, 0, 23});
        customchart.setMargin(Position.top, "30px");
        customchart.refresh();
    }

    private List<Long> getOrgids() {
        MulBasedataDynamicObjectCollection org = (MulBasedataDynamicObjectCollection)this.getView().getParentView().getModel().getValue("org");
        if (CollectionUtils.isNotEmpty((Collection)org)) {
            return org.stream().map(m -> m.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        }
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView().getParentView());
        DynamicObjectCollection orgs = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        return orgs.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
    }

    private void classifyTaxtypeData(String taxtype, List<Map<String, Object>> taxtypeDataList, Map<String, Integer> taxtypeClassifyMap) {
        for (Map<String, Object> data : taxtypeDataList) {
            String declarestatus = (String)data.get("declarestatus");
            String paystatus = (String)data.get("paystatus");
            String key = this.getMapKey(taxtype, declarestatus, paystatus);
            Integer count = taxtypeClassifyMap.getOrDefault(key, 0) + 1;
            taxtypeClassifyMap.put(key, count);
        }
    }

    private String getMapKey(String taxtype, String declarestatus, String paystatus) {
        WizardapEnum[] wizardapEnumVals;
        for (WizardapEnum wizardapEnumVal : wizardapEnumVals = WizardapEnum.values()) {
            String name = wizardapEnumVal.getName();
            List<String> fieldKeys = wizardapEnumVal.getFieldKeys();
            if (!fieldKeys.contains(declarestatus) || !fieldKeys.contains(paystatus)) continue;
            return taxtype + name;
        }
        logger.error("\u6ca1\u6709\u6539\u72b6\u6001declarestatus:{},paystatus:{}", (Object)declarestatus, (Object)paystatus);
        return "";
    }

    private void setBarSeries(List<Long> keys, Map<String, Integer> countMap, String statusName, String color) {
        ArrayList<Integer> values = new ArrayList<Integer>(keys.size());
        for (Long key : keys) {
            values.add(countMap.getOrDefault(key + statusName, 0));
        }
        this.createBarSeries(statusName, values.toArray(new Integer[0]), color);
    }

    private Axis createCategoryAxis(String name, List<String> demensions, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.category) : this.getMainChart().createYAxis(name, AxisType.category);
        axis.setCategorys(demensions);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private BarChart getMainChart() {
        BarChart barChart = (BarChart)this.getView().getControl("barchartap");
        return barChart;
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private void createBarSeries(String name, Number[] values, String color) {
        BarSeries barSeries = this.getMainChart().createBarSeries(name);
        barSeries.setStack("stack");
        barSeries.setColor(color);
        barSeries.setAnimationDuration(2000);
        Label label = new Label();
        label.setPosition(Position.insideRight);
        label.setShow(false);
        barSeries.setLabel(label);
        for (int i = 0; i < values.length; ++i) {
            Number n = values[i];
            if (n.intValue() != 0) continue;
            values[i] = null;
        }
        barSeries.setData(values);
    }

    private Axis createValueAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.value) : this.getMainChart().createYAxis(name, AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#999999");
        this.getMainChart().setShowTooltip(true);
        return axis;
    }
}

