/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.task;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.EntityOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleFetchConstant;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclareCustomParamsHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.ProvisionHyperlinkParamsEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.helper.bos.view.ViewDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.CalcTaskClick;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.exception.ThrowableHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tam.business.job.JobDispatchFormHelper;
import kd.taxc.tam.business.task.TaskCenterFormRecalTask;
import kd.taxc.tam.business.task.TaskCenterService;
import kd.taxc.tam.common.util.DeclareCommonUtil;
import kd.taxc.tam.formplugin.draft.TamDraftListPlugin;
import org.apache.commons.lang3.StringUtils;

public class TaskCenterFormPlugin
extends AbstractFormPlugin
implements TabSelectListener,
BeforeF7SelectListener,
HyperLinkClickListener {
    private static Log log = LogFactory.getLog(TaskCenterFormPlugin.class);
    private static final String PAY = "pay";
    private static final Map<String, String> TAP_MAP = new HashMap<String, String>(){
        {
            this.put("tabap1", "tabap2");
            this.put("tabap3", "tabap4");
            this.put("tabap5", "tabap6");
        }
    };
    private static final Map<String, String> TAP_PAGE_MAP = new HashMap<String, String>(){
        {
            this.put("nssb1", "nssb2");
            this.put("wsstabpageap", "wsstabpageap1");
            this.put("ssdgtabpageap", "ssdgtabpageap1");
            this.put("wsbtabpageap", "wsbtabpageap1");
            this.put("wjktabpageap", "wjktabpageap1");
            this.put("ywctabpageap", "ywctabpageap1");
            this.put("sjjt1", "sjjt2");
            this.put("wsstabpageap2", "wsstabpageap11");
            this.put("wsbtabpageap2", "wsbtabpageap11");
            this.put("wjktabpageap2", "wjktabpageap11");
            this.put("ywctabpageap2", "ywctabpageap11");
        }
    };
    private static final Map<String, String> NSSB_TAP_PAGE_LIST_MAP = new HashMap<String, String>(){
        {
            this.put("wsstabpageap1", "billlistap");
            this.put("ssdgtabpageap1", "billlistap8");
            this.put("wsbtabpageap1", "billlistap1");
            this.put("wjktabpageap1", "billlistap2");
            this.put("ywctabpageap1", "billlistap3");
        }
    };
    private static final Map<String, String> TAP_PAGE_LIST_MAP = new HashMap<String, String>(){
        {
            this.put("wsstabpageap1", "billlistap");
            this.put("ssdgtabpageap1", "billlistap8");
            this.put("wsbtabpageap1", "billlistap1");
            this.put("wjktabpageap1", "billlistap2");
            this.put("ywctabpageap1", "billlistap3");
            this.put("wsstabpageap11", "billlistap4");
            this.put("wsbtabpageap11", "billlistap5");
            this.put("wjktabpageap11", "billlistap6");
            this.put("ywctabpageap11", "billlistap7");
        }
    };
    private static final String SJJS = "sjjs";
    private static final String AYSNREFRESHBTN = "aysnrefreshbtn";
    private static final String WSSSJTB = "wsssjtb";
    private static final String WJTSJTB = "wjtsjtb";
    private static final String INVALID = "invalid";
    private static final String RECTIFY = "rectify";
    private static final String RECALDECLARE = "recaldeclare";
    private static final String DIRECTDECLARE = "btn_directdeclare";
    private static final String DIRECTPAY = "btn_directpay";
    private static final Map<String, String[]> NSSB_TAP_PAGE_BTN_MAP = new HashMap<String, String[]>(){
        {
            this.put("wsstabpageap1", new String[]{TaskCenterFormPlugin.SJJS, TaskCenterFormPlugin.WSSSJTB, "declaredate"});
            this.put("ssdgtabpageap1", new String[]{"submit", "unsubmit", "audit", "unaudit", "viewflowchart", TaskCenterFormPlugin.RECALDECLARE, "declaredate"});
            this.put("wsbtabpageap1", new String[]{"submit", "unsubmit", "audit", "unaudit", "viewflowchart", TaskCenterFormPlugin.DIRECTDECLARE, "apply", "declaredate"});
            this.put("wjktabpageap1", new String[]{"viewflowchart", "cancelapply", TaskCenterFormPlugin.PAY, TaskCenterFormPlugin.DIRECTPAY, "declaredate", TaskCenterFormPlugin.INVALID, TaskCenterFormPlugin.RECTIFY});
            this.put("ywctabpageap1", new String[]{"viewflowchart", "cancelpay", "declaredate", TaskCenterFormPlugin.INVALID, TaskCenterFormPlugin.RECTIFY});
            this.put("wsstabpageap11", new String[]{"sjjt", TaskCenterFormPlugin.WJTSJTB, "accrualdate"});
            this.put("wsbtabpageap11", new String[]{"submit1", "unsubmit", "audit1", "unaudit", "viewflowchart1", "baritemap", "accrualdate"});
            this.put("wjktabpageap11", new String[]{"submit1", "unsubmit", "audit1", "unaudit", "viewflowchart1", "generatevoucher", "accrualdate"});
            this.put("ywctabpageap11", new String[]{"deletevoucher", "accrualdate"});
        }
    };
    private static final Set<String> NSSB_ALL_ITEM_KEY = Sets.newHashSet((Object[])new String[]{"sjjs", "wsssjtb", "submit", "unsubmit", "audit", "unaudit", "viewflowchart", "recaldeclare", "btn_directdeclare", "btn_directpay", "apply", "cancelapply", "pay", "cancelpay", "invalid", "rectify"});
    private static final Set<String> NSSB_OPER_KEY = Sets.newHashSet((Object[])new String[]{"sjjs", "submit", "unsubmit", "audit", "unaudit", "apply", "cancelapply", "pay", "cancelpay", "invalid", "rectify"});
    private static final Set<String> SJJT_ALL_ITEM_KEY = Sets.newHashSet((Object[])new String[]{"sjjt", "wjtsjtb", "submit", "unsubmit", "audit", "unaudit", "newjtd", "generatevoucher", "viewflowchart", "deletevoucher"});
    private static final Set<String> SJJT_OPER_KEY = Sets.newHashSet((Object[])new String[]{"submit", "unsubmit", "audit", "unaudit", "newjtd", "generatevoucher", "deletevoucher"});
    private static final Set<String> TABAP_LIST = Sets.newHashSet((Object[])new String[]{"tabap1", "tabap2", "tabap3", "tabap4", "tabap5", "tabap6"});
    private static final Set<String> BILLLISTAP_LIST = Sets.newHashSet((Object[])new String[]{"billlistap", "billlistap1", "billlistap2", "billlistap3", "billlistap4", "billlistap5", "billlistap6", "billlistap7", "billlistap8"});
    private static final String BDTAXR_TAXABLE_LISTING = "bdtaxr_taxable_listing";
    private static final String DECLARE_MAIN_TSD = "tpo_declare_main_tsd";

    public void initialize() {
        super.initialize();
        this.registe();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    private void registe() {
        TABAP_LIST.forEach(e -> ((Tab)this.getControl((String)e)).addTabSelectListener((TabSelectListener)this));
        BILLLISTAP_LIST.forEach(e -> {
            BillList billlistap = (BillList)this.getView().getControl(e);
            billlistap.addPackageDataListener(this::packageData);
            if ("billlistap8".equals(e)) {
                billlistap.addCreateListDataProviderListener(this::beforeCreateListDataProvider);
            }
            billlistap.addHyperClickListener((HyperLinkClickListener)this);
            billlistap.addSetFilterListener(this::setFilter);
        });
        MulBasedataEdit control = (MulBasedataEdit)this.getControl("org");
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"toolbarap1"});
        this.addClickListeners(new String[]{"refreshbtn", AYSNREFRESHBTN});
    }

    public void setFilter(SetFilterEvent e) {
        BillList billList = (BillList)e.getSource();
        Date declareDate = this.getDeclareDate();
        Date startDate = this.getJtDate();
        Date endDate = DateUtils.getLastDateOfMonth((Date)startDate);
        String listKey = billList.getKey();
        if (TAP_PAGE_LIST_MAP.values().contains(listKey)) {
            List<Long> orgList = this.getOrgList();
            List qFilters = e.getQFilters();
            if (NSSB_TAP_PAGE_LIST_MAP.values().contains(listKey)) {
                if (declareDate != null) {
                    if ("billlistap".equals(listKey)) {
                        QFilter qFilter = new QFilter("org", "in", orgList).and("month", "=", (Object)declareDate).and("declarestatus", "=", (Object)"nodata").and("taxationsys", "=", (Object)RuleFetchConstant.DEFALUT_TAXSYSTEM).and("taxareagroup", "=", (Object)RuleFetchConstant.DEFALUT_TAXAREAGROUP).and("sbbcategory", "!=", (Object)"xfsjfj");
                        qFilters.add(qFilter);
                    } else if ("billlistap8".equals(listKey)) {
                        this.doAddSsdgFilter(declareDate, orgList, qFilters);
                    } else {
                        QFilter sbQFilter;
                        QFilter qFilter = new QFilter("org", "in", orgList).and("month", "=", (Object)declareDate).and(QFilter.isNotNull((String)"sbbno")).and("taxationsys", "=", (Object)RuleFetchConstant.DEFALUT_TAXSYSTEM).and("taxareagroup", "=", (Object)RuleFetchConstant.DEFALUT_TAXAREAGROUP).and("sbbcategory", "!=", (Object)"xfsjfj");
                        DynamicObjectCollection taxableListing = QueryServiceHelper.query((String)BDTAXR_TAXABLE_LISTING, (String)"org,skssqq,skssqz,id,templatetype,sbbno", (QFilter[])qFilter.toArray());
                        Set sbbnos = taxableListing.stream().filter(a -> StringUtil.isNotBlank((CharSequence)a.getString("sbbno"))).map(a -> a.getString("sbbno")).collect(Collectors.toSet());
                        if ("billlistap1".equals(listKey)) {
                            sbQFilter = new QFilter("org", "in", orgList).and("billno", "in", sbbnos).and("declarestatus", "!=", (Object)"declared");
                            qFilters.add(sbQFilter);
                        }
                        if ("billlistap2".equals(listKey)) {
                            sbQFilter = new QFilter("org", "in", orgList).and("declarestatus", "=", (Object)"declared").and("billno", "in", sbbnos).and("paystatus", "not in", (Object)new String[]{"paid", "nopay", "partpaid"});
                            qFilters.add(sbQFilter);
                        }
                        if ("billlistap3".equals(listKey)) {
                            sbQFilter = new QFilter("org", "in", orgList).and("billno", "in", sbbnos).and("paystatus", "in", (Object)new String[]{"paid", "nopay", "partpaid"});
                            qFilters.add(sbQFilter);
                        }
                    }
                } else {
                    qFilters.add(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
                }
                return;
            }
            if (startDate != null) {
                TaskCenterService.setSjjtListFilter(listKey, orgList, startDate, endDate, qFilters);
            } else {
                qFilters.add(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
            }
        }
    }

    private void doAddSsdgFilter(Date declareDate, List<Long> orgList, List<QFilter> qFilters) {
        QFilter qFilter = new QFilter("org", "in", orgList).and("month", "=", (Object)declareDate).and("draftstatus", "not in", Arrays.asList("noneed", "nodata")).and("taxationsys", "=", (Object)RuleFetchConstant.DEFALUT_TAXSYSTEM).and("taxareagroup", "=", (Object)RuleFetchConstant.DEFALUT_TAXAREAGROUP);
        DynamicObjectCollection taxableListing = QueryServiceHelper.query((String)BDTAXR_TAXABLE_LISTING, (String)"org,skssqq,skssqz,id,templatetype,draftno", (QFilter[])qFilter.toArray());
        Set draftnos = taxableListing.stream().filter(a -> StringUtil.isNotBlank((CharSequence)a.getString("draftno"))).map(a -> a.getString("draftno")).collect(Collectors.toSet());
        QFilter draftnoQFilter = new QFilter("billno", "in", draftnos);
        qFilters.add(draftnoQFilter);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("declaredate", (Object)new Date());
        this.getPageCache().put("lastDate", DateUtils.format((Date)this.getDeclareDate()));
        String nssbCurTab = this.getNssbCurListTab("");
        this.changeNssbBtnShow(nssbCurTab);
        this.updateNssbShow();
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        Tab source = (Tab)tabSelectEvent.getSource();
        String tabKey = source.getKey();
        String tabPageKey = tabSelectEvent.getTabKey();
        String targetKey = TAP_MAP.get(tabKey);
        String targetPageKey = TAP_PAGE_MAP.get(tabPageKey);
        if (StringUtil.isNotEmpty((CharSequence)targetKey) && StringUtil.isNotEmpty((CharSequence)targetPageKey)) {
            ((Tab)this.getControl(targetKey)).activeTab(targetPageKey);
        }
        if ("nssb2".equals(tabPageKey) || "tabap4".equals(tabKey)) {
            if ("tabap2".equals(tabKey)) {
                tabKey = "tabap4";
            }
            if (this.getModel().getValue("declaredate") == null) {
                this.getModel().setValue("declaredate", (Object)new Date());
            }
            tabPageKey = this.getNssbCurListTab(tabKey);
            this.changeNssbBtnShow(tabPageKey);
            this.refreshList(tabPageKey);
            return;
        }
        if ("sjjt2".equals(tabPageKey) || "tabap6".equals(tabKey)) {
            if ("tabap2".equals(tabKey)) {
                if (this.getModel().getValue("accrualdate") == null) {
                    this.getModel().setValue("accrualdate", (Object)new Date());
                }
                tabKey = "tabap6";
            }
            tabPageKey = this.getSjjtCurListTab(tabKey);
            this.changeNssbBtnShow(tabPageKey);
            List<Long> orgList = this.getOrgList();
            Date startDate = this.getJtDate();
            Date endDate = DateUtils.getLastDateOfMonth((Date)startDate);
            this.calcSjjtStat(orgList, startDate, endDate);
            this.refreshList(tabPageKey);
        }
    }

    public String getNssbCurListTab(String tabKey) {
        if (StringUtil.isBlank((CharSequence)tabKey)) {
            tabKey = "tabap4";
        }
        Tab source = (Tab)this.getView().getControl(tabKey);
        return source.getCurrentTab();
    }

    public String getSjjtCurListTab(String tabKey) {
        if (StringUtil.isBlank((CharSequence)tabKey)) {
            tabKey = "tabap6";
        }
        Tab source = (Tab)this.getView().getControl(tabKey);
        return source.getCurrentTab();
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String columnDescKey = columnDesc.getKey();
        if (columnDescKey.startsWith("type")) {
            String suffix = columnDescKey.replace("type", "");
            String type = data.getString("type" + suffix);
            e.setFormatValue((Object)TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""));
        } else if (columnDescKey.contains("skssqq")) {
            String suffix = columnDescKey.replace("skssqq", "");
            String date = DateUtils.getStartToEndDate((Date)data.getDate("skssqq" + suffix), (Date)data.getDate("skssqz" + suffix), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        } else if (columnDescKey.contains("riskcontent")) {
            String suffix = columnDescKey.replace("riskcontent", "");
            if ("normal".equals(e.getFormatValue())) {
                e.getNoLinkKey().add("riskcontent" + suffix);
            }
        } else if (columnDescKey.startsWith("startdate")) {
            String suffix = columnDescKey.replace("startdate", "");
            String date = DateUtils.getStartToEndDate((Date)data.getDate("startdate" + suffix), (Date)data.getDate("enddate" + suffix), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        }
    }

    private void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        new TamDraftListPlugin().beforeCreateListDataProvider(args);
    }

    private void changeNssbBtnShow(String tabPageKey) {
        String[] keys = (String[])NSSB_TAP_PAGE_BTN_MAP.values().stream().flatMap(a -> Arrays.stream(a)).toArray(String[]::new);
        this.getView().setVisible(Boolean.FALSE, keys);
        if (NSSB_TAP_PAGE_BTN_MAP.containsKey(tabPageKey)) {
            this.getView().setVisible(Boolean.TRUE, NSSB_TAP_PAGE_BTN_MAP.get(tabPageKey));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"currencyfield"});
    }

    private void refreshList(String tabPageKey) {
        String listKey = TAP_PAGE_LIST_MAP.get(tabPageKey);
        if (StringUtil.isNotEmpty((CharSequence)listKey)) {
            BillList billlistap = (BillList)this.getView().getControl(listKey);
            billlistap.clearSelection();
            billlistap.refresh();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        String tabap1 = ((Tab)this.getControl("tabap1")).getCurrentTab();
        if ("nssb1".equals(tabap1)) {
            if ("org".equals(key)) {
                this.updateNssbShow();
            } else if ("declaredate".equals(key)) {
                String lastDate = this.getPageCache().get("lastDate");
                Date declareDate = this.getDeclareDate();
                if (!Objects.equals(DateUtils.format((Date)declareDate), lastDate)) {
                    this.getPageCache().put("lastDate", declareDate != null ? DateUtils.format((Date)declareDate) : "null");
                    this.updateNssbShow();
                }
            }
        }
        if ("sjjt1".equals(tabap1)) {
            List<Long> orgList = this.getOrgList();
            Date startDate = this.getJtDate();
            Date endDate = DateUtils.getLastDateOfMonth((Date)startDate);
            this.calcSjjtStat(orgList, startDate, endDate);
            this.refreshList(((Tab)this.getControl("tabap6")).getCurrentTab());
        }
    }

    private void updateNssbShow() {
        for (String tabPageKey : TAP_PAGE_LIST_MAP.keySet()) {
            this.refreshList(tabPageKey);
        }
        this.calcNssbStat();
        List<Long> orgList = this.getOrgList();
        Date startDate = this.getJtDate();
        Date endDate = DateUtils.getLastDateOfMonth((Date)startDate);
        this.calcSjjtStat(orgList, startDate, endDate);
    }

    private void calcNssbStat() {
        Date declareDate = this.getDeclareDate();
        List<Long> orgList = this.getOrgList();
        long nsztsl = orgList.size();
        long sbbsl = 0L;
        long wss = 0L;
        long yss = 0L;
        long wjk = 0L;
        long ywc = 0L;
        BigDecimal yjnsj = BigDecimal.ZERO;
        BigDecimal sswcl = BigDecimal.ZERO;
        BigDecimal jkwcl = BigDecimal.ZERO;
        if (declareDate != null) {
            DynamicObjectCollection taxableList = this.getTaxableListByCondition(orgList, declareDate);
            QFilter qFilter1 = new QFilter("org", "in", orgList).and("month", "=", (Object)declareDate).and(QFilter.isNotNull((String)"sbbno")).and("taxationsys", "=", (Object)RuleFetchConstant.DEFALUT_TAXSYSTEM).and("taxareagroup", "=", (Object)RuleFetchConstant.DEFALUT_TAXAREAGROUP).and("sbbcategory", "!=", (Object)"xfsjfj");
            DynamicObjectCollection taxableListing = QueryServiceHelper.query((String)BDTAXR_TAXABLE_LISTING, (String)"sbbno", (QFilter[])qFilter1.toArray());
            Set sbbnos = taxableListing.stream().filter(a -> StringUtil.isNotBlank((CharSequence)a.getString("sbbno"))).map(a -> a.getString("sbbno")).collect(Collectors.toSet());
            QFilter sbQFilter = new QFilter("org", "in", orgList).and("billno", "in", sbbnos);
            DynamicObjectCollection sbbs = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"billno,org,skssqq,skssqz,declarestatus,type,paystatus,bqybtse", (QFilter[])sbQFilter.toArray());
            sbbsl = taxableList.size();
            wss = taxableList.stream().filter(a -> Objects.equals(a.getString("declarestatus"), "nodata")).count();
            yss = sbbsl - wss;
            wjk = 0L;
            ywc = 0L;
            yjnsj = new BigDecimal(0).setScale(10);
            for (DynamicObject sbb : sbbs) {
                BigDecimal bqybtse = sbb.getBigDecimal("bqybtse");
                if (bqybtse.compareTo(BigDecimal.ZERO) > 0) {
                    yjnsj = yjnsj.add(bqybtse);
                }
                String declarestatus = sbb.getString("declarestatus");
                String paystatus = sbb.getString("paystatus");
                HashSet payStatSet = Sets.newHashSet((Object[])new String[]{"paid", "nopay", "partpaid"});
                if (payStatSet.contains(paystatus)) {
                    ++ywc;
                    continue;
                }
                if (!"declared".equalsIgnoreCase(declarestatus)) continue;
                ++wjk;
            }
            sswcl = sbbsl == 0L ? BigDecimal.ZERO : new BigDecimal(yss).divide(new BigDecimal(sbbsl), 2, 4).multiply(new BigDecimal(100));
            jkwcl = sbbsl == 0L ? BigDecimal.ZERO : new BigDecimal(ywc).divide(new BigDecimal(sbbsl), 2, 4).multiply(new BigDecimal(100));
        }
        this.getModel().setValue("nsztsl", (Object)nsztsl);
        this.getModel().setValue("sbbsl", (Object)sbbsl);
        this.getModel().setValue("wss", (Object)wss);
        this.getModel().setValue("yss", (Object)yss);
        this.getModel().setValue("yjk", (Object)ywc);
        this.getModel().setValue("wjk", (Object)wjk);
        this.getModel().setValue("yjznj", (Object)yjnsj.setScale(2, 4));
        ProgressBar progressbarap1 = (ProgressBar)this.getView().getControl("progressbarap1");
        progressbarap1.setPercent(sswcl.intValue());
        ProgressBar progressbarap = (ProgressBar)this.getView().getControl("progressbarap");
        progressbarap.setPercent(jkwcl.intValue());
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (AYSNREFRESHBTN.equals(e.getName())) {
            this.calcNssbStat();
            List<Long> orgList = this.getOrgList();
            Date startDate = this.getJtDate();
            Date endDate = DateUtils.getLastDateOfMonth((Date)startDate);
            this.calcSjjtStat(orgList, startDate, endDate);
        }
    }

    private DynamicObjectCollection getTaxableListByCondition(List<Long> orgList, Date declareDate) {
        QFilter qFilter = new QFilter("org", "in", orgList).and("month", "=", (Object)declareDate).and("taxationsys", "=", (Object)RuleFetchConstant.DEFALUT_TAXSYSTEM).and("taxareagroup", "=", (Object)RuleFetchConstant.DEFALUT_TAXAREAGROUP).and("sbbcategory", "!=", (Object)"xfsjfj");
        return QueryServiceHelper.query((String)BDTAXR_TAXABLE_LISTING, (String)"id,org,skssqq,skssqz,paystatus,declarestatus,taxcatetory,taxauthority,sbbcategory,dgcategory,draftstatus,sbbno,month,modifytime,templatetype,templateid,deadline", (QFilter[])qFilter.toArray());
    }

    private void calcSjjtStat(List<Long> orgList, Date startDate, Date endDate) {
        Map<String, Object> values = TaskCenterService.calcSjjtStat(orgList, startDate, endDate);
        this.getModel().setValue("nsztsl2", values.get("nsztsl2"));
        this.getModel().setValue("jtdgsl", values.get("jtdgsl"));
        ProgressBar jtwcl1 = (ProgressBar)this.getView().getControl("jtwcl");
        jtwcl1.setPercent(Integer.parseInt(String.valueOf(values.get("jtwcl"))));
        this.getModel().setValue("yjt", values.get("yjt"));
        this.getModel().setValue("wjt", values.get("wjt"));
        ProgressBar rzwcl1 = (ProgressBar)this.getView().getControl("rzwcl");
        rzwcl1.setPercent(Integer.parseInt(String.valueOf(values.get("rzwcl"))));
        this.getModel().setValue("yrz", values.get("yrz"));
        this.getModel().setValue("wrz", values.get("wrz"));
        this.getModel().setValue("yjtsj", values.get("yjtsj"));
    }

    private Date getDeclareDate() {
        Date declaredate = (Date)this.getModel().getValue("declaredate");
        if (declaredate != null) {
            return DateUtils.getFirstDateOfMonth((Date)declaredate);
        }
        return null;
    }

    private Date getJtDate() {
        Date accrualdate = (Date)this.getModel().getValue("accrualdate");
        if (accrualdate != null) {
            return DateUtils.getFirstDateOfMonth((Date)accrualdate);
        }
        return null;
    }

    private List<Long> getOrgList() {
        MulBasedataDynamicObjectCollection org = (MulBasedataDynamicObjectCollection)this.getModel().getValue("org");
        if (EmptyCheckUtils.isNotEmpty((Object)org)) {
            return org.stream().map(a -> a.getLong("fbasedataid_id")).collect(Collectors.toList());
        }
        String entityId = this.getView().getEntityId();
        HasPermOrgResult permOrgResult = PermissionUtils.getAllPermOrgs((String)TaxAppEnum.TAM.getAppid(), (String)entityId, (String)"47150e89000000ac");
        if (!permOrgResult.hasAllOrgPerm()) {
            if (EmptyCheckUtils.isNotEmpty((Object)permOrgResult.getHasPermOrgs())) {
                List permorgList = permOrgResult.getHasPermOrgs();
                List orgList = (List)TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIdAndIsTaxpayer((List)permorgList).getData();
                return orgList;
            }
        } else {
            TaxResult allOrg = ViewDataServiceHelper.getAllOrg();
            List orgList = (List)TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIdAndIsTaxpayer((List)((List)allOrg.getData())).getData();
            return orgList;
        }
        return new ArrayList<Long>(0);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("payDateConfirm")) {
            Date payDate = (Date)closedCallBackEvent.getReturnData();
            if (payDate == null) {
                return;
            }
            BillList billList = (BillList)this.getView().getControl("billlistap2");
            ListSelectedRowCollection list = billList.getSelectedRows();
            DeclareCommonUtil.pay(billList, list.getPrimaryKeyValues(), payDate, this.getPageCache(), this.getView());
            billList.clearSelection();
            billList.refresh();
            this.getView().addClientCallBack(AYSNREFRESHBTN);
        } else if (actionId.equals(WSSSJTB) || actionId.equals(WJTSJTB) || actionId.equals(SJJS)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.clearSelection();
            billList.refresh();
        }
        if (actionId.equals("taskcloseback")) {
            this.handlerRecalTaskCloseBack(closedCallBackEvent);
        }
    }

    private void handlerRecalTaskCloseBack(ClosedCallBackEvent closedCallBackEvent) {
        String data;
        Map customs;
        String message;
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && StringUtil.isNotEmpty((CharSequence)(message = (String)(customs = (Map)SerializationUtils.fromJsonString((String)(data = taskInfo.getData()), Map.class)).get("message")))) {
            this.getView().showMessage(message);
        }
        this.getView().updateView("billlistap8");
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ((INVALID.equals(event.getCallBackId()) || RECTIFY.equals(event.getCallBackId())) && event.getResult() == MessageBoxResult.Yes) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            String keyStr = INVALID.equals(event.getCallBackId()) ? ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"TamDeclareListPlugin_21", (String)"taxc-tam", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u66f4\u6b63", (String)"TamDeclareListPlugin_22", (String)"taxc-tam", (Object[])new Object[0]);
            customParams.put("customCaption", String.format(ResManager.loadKDString((String)"%s\u7533\u62a5", (String)"TamDeclareListPlugin_23", (String)"taxc-tam", (Object[])new Object[0]), keyStr));
            customParams.put("inputType", event.getCallBackId());
            String nssbCurListTab = this.getNssbCurListTab("");
            String listKey = TAP_PAGE_LIST_MAP.getOrDefault(nssbCurListTab, "");
            BillList billlist = (BillList)this.getControl(listKey);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            Object[] pkIds = list.getPrimaryKeyValues();
            customParams.put("pkid", pkIds[0]);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"bdtaxr_declare_msg_input", (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        OpenStyle openStyle;
        ListSelectedRowCollection selectedRows;
        BillList billlistap;
        Date declareDate;
        String listKey;
        String nssbCurListTab;
        super.beforeDoOperation(evt);
        EntityOperate toolbar = (EntityOperate)evt.getSource();
        String itemKey = toolbar.getOperateKey();
        Tab source = (Tab)this.getView().getControl("tabap2");
        String currentTab = source.getCurrentTab();
        if (currentTab.contains("nssb2") && NSSB_ALL_ITEM_KEY.contains(itemKey)) {
            nssbCurListTab = this.getNssbCurListTab("");
            listKey = TAP_PAGE_LIST_MAP.getOrDefault(nssbCurListTab, "");
            if (StringUtil.isBlank((CharSequence)listKey)) {
                return;
            }
            if (DIRECTDECLARE.equals(itemKey) || DIRECTPAY.equals(itemKey)) {
                return;
            }
            declareDate = this.getDeclareDate();
            if (WSSSJTB.equals(itemKey) && declareDate != null) {
                List<Long> orgList = this.getOrgList();
                JobDispatchFormHelper.sendSjtbTaskMsg(orgList, declareDate, this.getView(), WSSSJTB, "kd.taxc.tam.formplugin.task.TaskCenterFormPlugin");
                return;
            }
            billlistap = (BillList)this.getView().getControl(listKey);
            selectedRows = billlistap.getSelectedRows();
            if (selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TaskCenterFormPlugin_05", (String)"taxc-tam", (Object[])new Object[0]));
                return;
            }
            if (SJJS.equals(itemKey) && declareDate != null) {
                DynamicObjectCollection taxableList = QueryServiceHelper.query((String)BDTAXR_TAXABLE_LISTING, (String)"id,org,skssqq,skssqz,paystatus,declarestatus,taxcatetory,taxauthority,sbbcategory,dgcategory,draftstatus,sbbno,month,modifytime,templatetype,templateid,deadline", (QFilter[])new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues()).toArray());
                List<TaxableListDto> taxableListDtos = taxableList.stream().map(a -> TaxableListDto.getInstanceFromOrm((DynamicObject)a)).collect(Collectors.toList());
                JobDispatchFormHelper.sendSjjsTaskMsg(taxableListDtos, declareDate, this.getView(), SJJS, "kd.taxc.tam.formplugin.task.TaskCenterFormPlugin");
            } else if ("viewflowchart".equals(itemKey)) {
                Set collect = selectedRows.stream().map(a -> a.getPrimaryKeyValue()).collect(Collectors.toSet());
                if (collect.size() > 1) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff0c\u60a8\u9009\u62e9\u4e86[%s]\u884c\u6570\u636e\u3002", (String)"TaskCenterFormPlugin_06", (String)"taxc-tam", (Object[])new Object[0]), collect.size()));
                    return;
                }
                openStyle = new OpenStyle();
                openStyle.setShowType(ShowType.MainNewTabPage);
                try {
                    WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)selectedRows.get(0).getPrimaryKeyValue(), (OpenStyle)openStyle);
                }
                catch (Exception e) {
                    log.error(ThrowableHelper.toString((Exception)e));
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe", (String)"TaskCenterFormPlugin_07", (String)"taxc-tam", (Object[])new Object[0]));
                }
            } else if (RECALDECLARE.equals(itemKey)) {
                this.doRecalDeclareBtn(itemKey, selectedRows);
            } else if (NSSB_OPER_KEY.contains(itemKey) && ("ssdgtabpageap1".equals(nssbCurListTab) ? this.doDraftBtn(itemKey, selectedRows) : this.doNssbBtn(evt, itemKey, selectedRows))) {
                return;
            }
            billlistap.clearSelection();
            billlistap.refresh();
        }
        if (currentTab.contains("sjjt2") && SJJT_ALL_ITEM_KEY.contains(itemKey)) {
            nssbCurListTab = this.getSjjtCurListTab("");
            listKey = TAP_PAGE_LIST_MAP.getOrDefault(nssbCurListTab, "");
            if (StringUtil.isBlank((CharSequence)listKey)) {
                return;
            }
            declareDate = this.getJtDate();
            if (WJTSJTB.equals(itemKey) && declareDate != null) {
                List<Long> orgList = this.getOrgList();
                JobDispatchFormHelper.sendJTSjtbTaskMsg(orgList, declareDate, this.getView(), WJTSJTB, "kd.taxc.tam.formplugin.task.TaskCenterFormPlugin");
                return;
            }
            billlistap = (BillList)this.getView().getControl(listKey);
            selectedRows = billlistap.getSelectedRows();
            if (selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TaskCenterFormPlugin_05", (String)"taxc-tam", (Object[])new Object[0]));
                return;
            }
            Date jtDate = this.getJtDate();
            if ("sjjt".equals(itemKey)) {
                TaskCenterService.doSjjt(selectedRows.getPrimaryKeyValues(), jtDate, this.getView());
                this.refreshList(itemKey, billlistap);
                return;
            }
            if (SJJT_OPER_KEY.contains(itemKey)) {
                String operationKey = itemKey;
                if (itemKey.endsWith("1")) {
                    operationKey = itemKey.substring(0, itemKey.length() - 1);
                }
                if ("wsbtabpageap11".equals(nssbCurListTab)) {
                    OperationResult result;
                    DynamicObject[] sbbs = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tam_declare_main_tsd"));
                    OperateOption op = OperateOption.create();
                    String message = "";
                    if ("newjtd".equals(operationKey)) {
                        op.setVariableValue("source", "tam_task_center_stat");
                    }
                    if (!(result = OperationServiceHelper.executeOperate((String)operationKey, (String)"tam_declare_main_tsd", (DynamicObject[])sbbs, (OperateOption)op)).isSuccess()) {
                        this.getView().showOperationResult(result);
                    } else {
                        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)message)) {
                            this.getView().showTipNotification(message);
                        }
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TaskCenterFormPlugin_01", (String)"taxc-tam", (Object[])new Object[0]));
                    }
                    this.refreshList(itemKey, billlistap);
                    return;
                }
                if ("wjktabpageap11".equals(nssbCurListTab) || "ywctabpageap11".equals(nssbCurListTab)) {
                    OperationResult result;
                    DynamicObject[] sbbs = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"itp_proviston_taxes"));
                    OperationResult operationResult = result = "generatevoucher".equals(operationKey) || "deletevoucher".equals(operationKey) ? OperationServiceHelper.executeOperate((String)operationKey, (String)"itp_proviston_taxes", (Object[])selectedRows.getPrimaryKeyValues(), (OperateOption)OperateOption.create()) : OperationServiceHelper.executeOperate((String)operationKey, (String)"itp_proviston_taxes", (DynamicObject[])sbbs, (OperateOption)OperateOption.create());
                    if (!result.isSuccess()) {
                        this.getView().showErrorNotification(((IOperateInfo)result.getAllErrorOrValidateInfo().get(0)).getMessage());
                    } else {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TaskCenterFormPlugin_01", (String)"taxc-tam", (Object[])new Object[0]));
                    }
                    this.refreshList(itemKey, billlistap);
                    return;
                }
            }
            if ("viewflowchart".equals(itemKey)) {
                if (selectedRows.size() > 1) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff0c\u60a8\u9009\u62e9\u4e86[%s]\u884c\u6570\u636e\u3002", (String)"TaskCenterFormPlugin_06", (String)"taxc-tam", (Object[])new Object[0]), selectedRows.size()));
                    return;
                }
                openStyle = new OpenStyle();
                openStyle.setShowType(ShowType.MainNewTabPage);
                try {
                    WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)selectedRows.get(0).getPrimaryKeyValue(), (OpenStyle)openStyle);
                }
                catch (Exception e) {
                    log.error(ThrowableHelper.toString((Exception)e));
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe", (String)"TaskCenterFormPlugin_07", (String)"taxc-tam", (Object[])new Object[0]));
                }
            }
            billlistap.clearSelection();
            billlistap.refresh();
        }
    }

    private void doRecalDeclareBtn(String itemKey, ListSelectedRowCollection selectedRows) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("draftIds", selectedRows.getPrimaryKeyValues());
        this.dispatch(params);
    }

    private void dispatch(Map<String, Object> customParams) {
        String appId = this.getView().getFormShowParameter().getAppId();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setTaskClassname(TaskCenterFormRecalTask.class.getName());
        jobInfo.setParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setClickClassName(CalcTaskClick.class.getName());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private boolean doDraftBtn(String itemKey, ListSelectedRowCollection selectedRows) {
        DynamicObject[] drafts = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tam_draft_bill"));
        OperationResult result = OperationServiceHelper.executeOperate((String)itemKey, (String)"tam_draft_bill", (DynamicObject[])drafts, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            DeclareCommonUtil.dealFail(result, this.getView(), (IFormPlugin)this);
            return true;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TaskCenterFormPlugin_01", (String)"taxc-tam", (Object[])new Object[0]));
        this.getView().addClientCallBack(AYSNREFRESHBTN);
        return false;
    }

    private boolean doNssbBtn(BeforeDoOperationEventArgs evt, String itemKey, ListSelectedRowCollection selectedRows) {
        DynamicObject[] sbbs;
        OperationResult result;
        OperateOption operateOption = OperateOption.create();
        if (INVALID.equals(itemKey) || RECTIFY.equals(itemKey)) {
            if (!this.beforeDoInvalid(evt, selectedRows, itemKey)) {
                return true;
            }
            EntityOperate toolbar = (EntityOperate)evt.getSource();
            operateOption = toolbar.getOption();
        }
        if (!(result = OperationServiceHelper.executeOperate((String)itemKey, (String)"tam_declare_bill", (DynamicObject[])(sbbs = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tam_declare_bill"))), (OperateOption)operateOption)).isSuccess()) {
            DeclareCommonUtil.dealFail(result, this.getView(), (IFormPlugin)this);
            return true;
        }
        if (PAY.equals(itemKey)) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bdtaxr_paydate_confirm");
            param.getOpenStyle().setShowType(ShowType.NonModal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payDateConfirm");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
            return true;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TaskCenterFormPlugin_01", (String)"taxc-tam", (Object[])new Object[0]));
        this.getView().addClientCallBack(AYSNREFRESHBTN);
        return false;
    }

    private boolean beforeDoInvalid(BeforeDoOperationEventArgs args, ListSelectedRowCollection list, String operateKey) {
        String keyStr;
        Object source = args.getSource();
        String opreateType = "";
        try {
            FormOperate operate = (FormOperate)source;
            opreateType = operate.getOption().getVariableValue("type");
        }
        catch (Exception operate) {
            // empty catch block
        }
        if ("msgInput".equals(opreateType)) {
            return true;
        }
        Set collect = list.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        String string = keyStr = INVALID.equals(operateKey) ? ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"TamDeclareListPlugin_21", (String)"taxc-tam", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u66f4\u6b63", (String)"TamDeclareListPlugin_22", (String)"taxc-tam", (Object[])new Object[0]);
        if (collect.size() != 1) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e%s\u7533\u62a5\u3002", (String)"TamDeclareListPlugin_24", (String)"taxc-tam", (Object[])new Object[0]), keyStr));
            args.setCancel(true);
            return false;
        }
        DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)list.get(0).getPrimaryKeyValue(), (String)"tcvat_nsrxx");
        String type = declare.getString("type");
        List<String> other_type = Arrays.asList("qtsf_tysbb", "qtsf_fsstysbb", "whsyjsf", "ccxws");
        if (!type.startsWith("zzs") && !type.startsWith("qysds") && !other_type.contains(type) || Arrays.asList("zzsyjskb", "qysdsjb").contains(type)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7533\u62a5\u8868\u7c7b\u578b\u6682\u4e0d\u652f\u6301\u201c\u66f4\u6b63\u7533\u62a5\u201d\u53ca\u201c\u4f5c\u5e9f\u7533\u62a5\u201d\u3002", (String)"TamDeclareListPlugin_25", (String)"taxc-tam", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        String msg = DeclareUtils.checkGzZfInfo((String)operateKey, (Object)list.get(0).getPrimaryKeyValue());
        if (msg != null) {
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return false;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u4e0d\u53ef\u64a4\u9500\uff0c\u5982\u786e\u8ba4\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5f55\u5165\u539f\u56e0\u8bf4\u660e", (String)"TamDeclareListPlugin_26", (String)"taxc-tam", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
        args.setCancel(true);
        return false;
    }

    private void refreshList(String operationKey, BillList billlistap) {
        HashSet NO_CLEAR_SELECTION_OPER_KEY = Sets.newHashSet((Object[])new String[]{"submit", "unsubmit", "audit", "unaudit", "viewflowchart"});
        if (!NO_CLEAR_SELECTION_OPER_KEY.contains(operationKey)) {
            billlistap.clearSelection();
        }
        billlistap.refresh();
        this.getView().addClientCallBack(AYSNREFRESHBTN);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("refreshbtn".equals(control.getKey())) {
            this.updateNssbShow();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String entityId = this.getView().getEntityId();
        HasPermOrgResult permOrgResult = PermissionUtils.getAllPermOrgs((String)TaxAppEnum.TAM.getAppid(), (String)entityId, (String)"47150e89000000ac");
        if (EmptyCheckUtils.isNotEmpty((Object)permOrgResult) && !permOrgResult.hasAllOrgPerm()) {
            if (EmptyCheckUtils.isNotEmpty((Object)permOrgResult.getHasPermOrgs())) {
                List permorgList = permOrgResult.getHasPermOrgs();
                List orgList = (List)TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIdAndIsTaxpayer((List)permorgList).getData();
                ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
            }
        } else if (permOrgResult.hasAllOrgPerm()) {
            TaxResult allOrg = ViewDataServiceHelper.getAllOrg();
            List orgList = (List)TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIdAndIsTaxpayer((List)((List)allOrg.getData())).getData();
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fieldName = args.getFieldName();
        if (StringUtil.isEmpty((CharSequence)fieldName)) {
            return;
        }
        BillList list = (BillList)args.getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
        if ("tam_declare_main_tsd".equals(list.getEntityId())) {
            this.draftHyperLinkClick(primaryKeyValue);
            return;
        }
        if ("itp_proviston_taxes".equals(list.getEntityId())) {
            if (fieldName.startsWith("billno")) {
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setPkId(primaryKeyValue);
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                billShowParameter.setFormId("itp_proviston_taxes");
                this.getView().showForm((FormShowParameter)billShowParameter);
            }
            if (fieldName.startsWith("entitynumber")) {
                this.provisionDraftHyperLinkClick(primaryKeyValue);
            }
            return;
        }
        if ("tam_draft_bill".equals(list.getEntityId())) {
            this.draftBillHyperLinkClick(primaryKeyValue, fieldName);
            return;
        }
        if (fieldName.contains("riskcontent")) {
            DeclareUtils.showRiskDialog((String)primaryKeyValue.toString(), (IFormView)this.getView());
        } else {
            String listKey = list.getKey();
            String suffix = listKey.replace("billlistap", "");
            if (suffix.length() > 0) {
                this.showDeclarePage(primaryKeyValue);
            }
        }
    }

    private void showDeclarePage(Object primaryKeyValue) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"tcvat_nsrxx");
        Map customParams = DeclareCustomParamsHelper.buildCustomParams((DynamicObject)object);
        String declarestatus = object.getString("declarestatus");
        String type = object.getString("type");
        DeclareUtils.showDeclarePage((String)kd.bos.dataentity.utils.StringUtils.trimToEmpty((String)type), (Map)customParams, (String)declarestatus, (DynamicObject)object, (IFormView)this.getView());
    }

    private void draftBillHyperLinkClick(Object primaryKeyValue, Object fieldName) {
        if ("sbbno".equals(fieldName)) {
            DynamicObject draft = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"tam_draft_bill");
            QFilter sbbnoFilter = new QFilter("billno", "=", (Object)draft.getString("sbbno"));
            DynamicObject declareMain = BusinessDataServiceHelper.loadSingle((String)"tcvat_nsrxx", (QFilter[])new QFilter[]{sbbnoFilter});
            this.showDeclarePage(declareMain.getPkValue());
        } else if ("billno".equals(fieldName)) {
            this.openDraftPage(primaryKeyValue);
        }
    }

    private void openDraftPage(Object primaryKeyValue) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"tctb_draft_main");
        String templatetype = object.getString("templatetype");
        HashMap<String, String> customParams = new HashMap<String, String>(4);
        customParams.put("orgid", object.getDynamicObject("org").getString("id"));
        customParams.put("orgname", object.getDynamicObject("org").getString("name"));
        Date skssqq = object.getDate("startdate");
        Date skssqz = object.getDate("enddate");
        customParams.put("templatetype", templatetype);
        String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
        customParams.put("draftpurpose", object.getString("draftpurpose"));
        TemplateEnum draftEnum = TemplateEnum.getEnumByDraftType((String)templatetype);
        FormShowParameter param = new FormShowParameter();
        param.setFormId(draftEnum.getDraftPage());
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    public void draftHyperLinkClick(Object primaryKeyValue) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"tam_declare_main_tsd");
        String templateType = object.getString("templatetype");
        if (StringUtil.isBlank((CharSequence)templateType)) {
            this.getView().showErrorNotification("Template Is Blank!");
            log.error("Blank Template Id: {}", primaryKeyValue);
            return;
        }
        DynamicObject objectNew = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)DECLARE_MAIN_TSD);
        ProvisionHyperlinkParamsEnum provisionHyperlinkParamsEnum = ProvisionHyperlinkParamsEnum.getEnumByTemplateType((String)templateType);
        if (ProvisionHyperlinkParamsEnum.DEFAULT.equals((Object)provisionHyperlinkParamsEnum)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6a21\u677f\u7f16\u7801\u3010%1$s\u3011\u4e0d\u652f\u6301\u8df3\u8f6c\uff01", (String)"TaskCenterFormPlugin_03", (String)"taxc-tam", (Object[])new Object[0]), templateType));
            return;
        }
        FormShowParameter formShowParameter = provisionHyperlinkParamsEnum.createFormShowParameter(objectNew);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(formShowParameter);
    }

    public void provisionDraftHyperLinkClick(Object primaryKeyValue) {
        DynamicObject object;
        MultiTableEnum[] multiTableEnums;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"itp_proviston_taxes");
        String entitynumber = dynamicObject.getString("entitynumber");
        log.info("\u3010\u5df2\u5b8c\u6210\u3011\u9875\u7b7e\u8df3\u8f6c\u6765\u6e90\u5e95\u7a3fentitynumber: {}", (Object)entitynumber);
        QFilter qFilter = new QFilter("billno", "=", (Object)entitynumber);
        DynamicObject object1 = BusinessDataServiceHelper.loadSingle((String)"tam_declare_main_tsd", (String)"templatetype", (QFilter[])new QFilter[]{qFilter});
        String templatetype = object1.getString("templatetype");
        String table = DECLARE_MAIN_TSD;
        String number = dynamicObject.getString("entitytype.number");
        for (MultiTableEnum tableEnum : multiTableEnums = MultiTableEnum.values()) {
            if (!tableEnum.getDeclareMainTable().equalsIgnoreCase(number)) continue;
            table = number;
            break;
        }
        if ((object = BusinessDataServiceHelper.loadSingle((String)table, (String)MetadataUtil.getAllFieldToQuery((String)table), (QFilter[])new QFilter[]{qFilter})) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u8ba1\u63d0\u5e95\u7a3f\u4efb\u52a1\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"TaskCenterFormPlugin_09", (String)"taxc-tam", (Object[])new Object[0]));
            return;
        }
        ProvisionHyperlinkParamsEnum hyperlinkParamsEnum = ProvisionHyperlinkParamsEnum.getEnumByTemplateType((String)templatetype);
        if (ProvisionHyperlinkParamsEnum.DEFAULT.equals((Object)hyperlinkParamsEnum)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6a21\u677f\u7f16\u7801\u3010%1$s\u3011\u4e0d\u652f\u6301\u8df3\u8f6c\uff01", (String)"TaskCenterFormPlugin_03", (String)"taxc-tam", (Object[])new Object[0]), templatetype));
            return;
        }
        FormShowParameter param = hyperlinkParamsEnum.createFormShowParameter(object);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }
}

