/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.opplugin.accrual;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class AccrualQueryListOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(Arrays.asList("org", "taxsystem", "taxtype", "taxareagroup", "accountsettype", "skssqq", "skssqz"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Map<String, List<DynamicObject>> groupedEntities = Arrays.stream(dataEntities).collect(Collectors.groupingBy(d -> {
            AccrualListEnum accrualListEnum = AccrualListEnum.valueOfBaseTaxIdAndAccountsettype((Long)d.getLong("taxtype.id"), (String)d.getString("accountsettype"));
            if (accrualListEnum != null) {
                return accrualListEnum.getEntryentity();
            }
            return "";
        }));
        for (Map.Entry<String, List<DynamicObject>> entry : groupedEntities.entrySet()) {
            String entityNumber = entry.getKey();
            if (!EmptyCheckUtils.isNotEmpty((Object)entityNumber)) continue;
            Object[] ids = entry.getValue().stream().map(d -> d.getLong("id")).toArray();
            OperationServiceHelper.executeOperate((String)e.getOperationKey(), (String)entityNumber, (Object[])ids, (OperateOption)OperateOption.create());
        }
    }
}

