/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.opplugin.declarelist;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tam.common.enums.TemplateTypeMetadataEnum;

public class DeclareQueryListOp
extends AbstractOperationServicePlugIn {
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String operateKey = args.getOperationKey();
        StringBuilder message = new StringBuilder();
        DynamicObject[] dataEntities = args.getDataEntities();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx");
        DynamicObject[] loadResult = BusinessDataServiceHelper.load((Object[])Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)mainEntityType);
        this.handlerResultData(loadResult, operateKey, "qysdsjb", message);
        this.handlerResultData(loadResult, operateKey, "qysdsnb", message);
        this.handlerResultData(loadResult, operateKey, "ccxws", message);
        this.handlerResultData(loadResult, operateKey, "zzs", message);
        this.handlerResultData(loadResult, operateKey, "zzsyjskb", message);
        this.handlerResultData(loadResult, operateKey, "qtsf", message);
        this.handlerResultData(loadResult, operateKey, "whsyjsf", message);
        this.handlerResultData(loadResult, operateKey, "FR", message);
        this.handlerResultData(loadResult, operateKey, "szys", message);
        if (StringUtil.isNotBlank((CharSequence)message.toString())) {
            this.operationResult.setMessage(message.toString());
            this.operationResult.setSuccess(false);
            this.operationResult.setShowMessage(false);
            this.getOption().setVariableValue("custom_opplugin_fail", "1");
            return;
        }
        this.operationResult.setSuccess(true);
    }

    private void handlerResultData(DynamicObject[] loadResult, String operateKey, String type, StringBuilder message) {
        List dataList = Arrays.stream(loadResult).filter(d -> this.filterByType(type, (DynamicObject)d)).collect(Collectors.toList());
        if (dataList.size() <= 0) {
            return;
        }
        if ("FR".equals(type) && (operateKey.equals("pay") || operateKey.equals("cancelpay"))) {
            String msg = ResManager.loadKDString((String)"\u8d22\u52a1\u62a5\u8868\u4e0d\u6d89\u53ca\u7f34\u6b3e", (String)"DeclareQueryListOp_0", (String)"taxc-tam", (Object[])new Object[0]);
            this.appendMsg(msg, message);
            return;
        }
        List<Long> ids = dataList.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        OperationResult resultesult = OperationServiceHelper.executeOperate((String)operateKey, (String)TemplateTypeMetadataEnum.getMetadataByType(type), (Object[])ids.toArray(new Long[0]), (OperateOption)OperateOption.create());
        String msg = resultesult.getMessage();
        List allErrorOrValidateInfo = resultesult.getAllErrorOrValidateInfo();
        if (allErrorOrValidateInfo.size() > 0) {
            allErrorOrValidateInfo.forEach(errorInfo -> this.appendMsg(errorInfo.getMessage(), message));
        } else {
            this.appendMsg(msg, message);
        }
    }

    private boolean filterByType(String type, DynamicObject d) {
        String nsrType = d.getString("type");
        if ("zzsyjskb".equals(nsrType)) {
            return nsrType.equals(type);
        }
        if (type.startsWith("qysds")) {
            TemplateTypeMetadataEnum enumByType = TemplateTypeMetadataEnum.getEnumByType(type);
            if (enumByType != null) {
                return enumByType.getNsrTypes().contains(nsrType);
            }
            return false;
        }
        return nsrType.contains(type);
    }

    private void appendMsg(String msg, StringBuilder message) {
        if (StringUtil.isNotBlank((CharSequence)msg)) {
            if (StringUtil.isNotBlank((CharSequence)message)) {
                message.append(SEPARATOR).append(msg);
            } else {
                message.append(msg);
            }
        }
    }
}

