/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.opplugin.init;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.packaudit.PackAuditTaskServiceHelper;
import kd.taxc.bdtaxr.formplugin.init.OrgInitConfigItemEnum;

public class BaseInitListDeleteOp
extends AbstractOperationServicePlugIn {
    private static Log LOGGER = LogFactory.getLog(BaseInitListDeleteOp.class);
    private List<Long> deleteOrgs;

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        this.deleteOrgs = Arrays.stream(dataEntities).map(d -> d.getLong("org_id")).collect(Collectors.toList());
        PackAuditTaskServiceHelper.syncBaseInitConfig(this.deleteOrgs, (String)"delete");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        this.deleteSubConfigBills();
    }

    private void deleteSubConfigBills() {
        QFilter orgFilter = new QFilter("org", "in", this.deleteOrgs);
        for (OrgInitConfigItemEnum itemEnum : OrgInitConfigItemEnum.values()) {
            DeleteServiceHelper.delete((String)itemEnum.getMeta(), (QFilter[])new QFilter[]{orgFilter});
        }
    }
}

