/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class EntryDataSynchronizeTcwatToTam
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)this.update(), (String)"EntryDataSynchronizeTcretToTam_0", (String)"EntryDataSynchronizeTcwatToTam_0", (Object[])new Object[0]));
        return result;
    }

    public String update() {
        try {
            String exists = "select fid from t_tam_declare_entry where fid = %s ;";
            String insertSql = "insert into t_tam_declare_entry (fentryid,fid,ftaxtype,fbqybtse) values (?,?,?,?)";
            String tcwatQuerySql = "select fsbbid,fbqybtse from t_tcwat_declare_a_tax where fsbbid in (%s) and fewblxh = 'sum'";
            String tctbQuerySql = "select fid from t_tctb_declare_main where fnsrtype = 'szys_a' or fnsrtype = 'szys_b'";
            List tctbEntrys = DBUtils.query((String)"taxc", (String)tctbQuerySql);
            String fsbbidStr = tctbEntrys.stream().map(e -> String.valueOf(e.get("FID"))).collect(Collectors.joining("','"));
            List tcwatEntrys = DBUtils.query((String)"taxc", (String)String.format(tcwatQuerySql, "'" + fsbbidStr + "'"));
            if (!CollectionUtils.isEmpty((Collection)tcwatEntrys)) {
                List existsData = DBUtils.query((String)String.format(exists, ((Map)tcwatEntrys.get(0)).get("FSBBID")));
                if (existsData.size() > 0) {
                    return ResManager.loadKDString((String)"\u8d22\u884c\u7a0e\u5206\u5f55\u7a0e\u79cd\u6570\u636e\u5df2\u88ab\u540c\u6b65\u8fc7", (String)"EntryDataSynchronizeTcwatToTam_1", (String)"taxc-tam", (Object[])new Object[0]);
                }
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
                for (Map row : tcwatEntrys) {
                    long fid = DBUtils.getLongId((String)"t_tam_declare_entry");
                    long fsbbid = Long.parseLong((String)row.get("FSBBID"));
                    String ftaxtype = "";
                    Object fybse = row.get("FBQYBTSE");
                    paramList.add(new Object[]{fid, fsbbid, ftaxtype, fybse});
                }
                if (EmptyCheckUtils.isNotEmpty(paramList)) {
                    DBUtils.executeBatch((String)"taxc", (String)insertSql, paramList);
                }
            }
            return ResManager.loadKDString((String)"\u8d22\u884c\u7a0e\u5206\u5f55\u7a0e\u79cd\u6570\u636e\u540c\u6b65\u6210\u529f", (String)"EntryDataSynchronizeTcwatToTam_2", (String)"taxc-tam", (Object[])new Object[0]);
        }
        catch (Exception e2) {
            String code = ((KDException)e2).getErrorCode().getCode();
            if ("bos.sQLDuplicateKey".equals(code)) {
                return ResManager.loadKDString((String)"\u8d22\u884c\u7a0e\u5206\u5f55\u7a0e\u79cd\u6570\u636e\u5df2\u88ab\u540c\u6b65\u8fc7", (String)"EntryDataSynchronizeTcwatToTam_1", (String)"taxc-tam", (Object[])new Object[0]);
            }
            return e2.getLocalizedMessage();
        }
    }
}

