/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class YjTamEntryUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(YjTamEntryUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log;
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String info = log = "tctb_declare_entry to tam_declare_entry success";
        try {
            boolean exit;
            boolean bl = exit = DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_declare_entry") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_declare_main") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tam_declare_entry");
            if (exit) {
                this.update();
            }
        }
        catch (Exception var9) {
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(var9);
            LOGGER.error(ERROR_INFO, (Throwable)var9);
        }
        result.setLog(log);
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        String QUERY_UPDATE_SQL = "select fid,ftaxtype,fewblname,fbqdybtse from t_tctb_declare_entry  where fid in (select a.fid from t_tctb_declare_main a  where a.fnsrtype = 'zzsyjskb' and fid not in (select ttde.fid from t_tam_declare_entry ttde))";
        List sourceData = DBUtils.query((String)QUERY_UPDATE_SQL);
        if (CollectionUtils.isEmpty((Collection)sourceData)) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(sourceData.size());
        for (Map source : sourceData) {
            Object ftaxtype = source.get("FTAXTYPE");
            try {
                int seq = Integer.parseInt(String.valueOf(ftaxtype));
                long entryId = DBUtils.getLongId((String)"t_tam_declare_entry");
                paramsList.add(new Object[]{source.get("FID"), entryId, seq, source.get("FBQDYBTSE"), source.get("FEWBLNAME")});
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
        if (CollectionUtils.isEmpty(paramsList)) {
            return;
        }
        String INSERT_SQL = "insert into t_tam_declare_entry(fid,fentryid,fseq,fbqybtse,ftaxtype) values (?,?,?,?,?);";
        DBUtils.executeBatch((String)INSERT_SQL, paramsList);
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }
}

