/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.mservice.declare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleFetchConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxableListEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.taxdeclare.taxrange.TaxableListQueryService;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.batch.BatchServiceFactory;
import kd.taxc.tccit.business.batch.IBatchHandler;
import kd.taxc.tccit.business.pojo.DataResultVo;

public class TaxableListQueryServiceImpl
implements TaxableListQueryService {
    private static Log LOGGER = LogFactory.getLog(TaxableListQueryServiceImpl.class);
    private static final String DECLARE_BATCH_TYPE = "declare";
    private static final String DRAFT_BATCH_TYPE = "draft";

    public List<Map<String, Object>> queryDraftTaxableList(List<Long> orgList, List<String> draftCategories, Date declareDate) {
        LOGGER.info("TaxableListQueryServiceImpl-queryDraftTaxableList \u8bf7\u6c42\u53c2\u6570\uff1aorgList:{},draftCategories:{},queryDate:{}", new Object[]{orgList != null ? orgList.size() : 0, draftCategories != null ? draftCategories.size() : 0, declareDate});
        LicenseCheckResult licenseCheckResult = LicenseCheckServiceHelper.checkTxftPerformGroup((String)"tcdrs");
        if (!licenseCheckResult.getHasLicense().booleanValue()) {
            LOGGER.info("\u6ca1\u6709\u6240\u5f97\u7a0e\u5e95\u7a3f\u8bb8\u53ef\u65e0\u9700\u7f16\u5236\u5e95\u7a3f");
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<TaxableListDto> taxableListDtos = draftCategories != null && orgList != null ? this.queryTaxableList(orgList, draftCategories, declareDate, false) : new ArrayList<TaxableListDto>();
        this.fillDgInfo(taxableListDtos, declareDate);
        return taxableListDtos.stream().map(a -> a.transformToMap()).collect(Collectors.toList());
    }

    public List<Map<String, Object>> queryDeclareTaxableList(List<Long> orgList, List<String> declareCategories, Date declareDate) {
        LOGGER.info("TaxableListQueryServiceImpl-queryDeclareTaxableList \u8bf7\u6c42\u53c2\u6570\uff1aorgList:{},draftCategories:{},queryDate:{}", new Object[]{orgList != null ? orgList.size() : 0, declareCategories != null ? declareCategories.size() : 0, declareDate});
        ArrayList<TaxableListDto> taxableListDtos = declareCategories != null && orgList != null ? this.queryTaxableList(orgList, declareCategories, declareDate, true) : new ArrayList<TaxableListDto>();
        this.fillSbbInfo(taxableListDtos, declareDate);
        return taxableListDtos.stream().map(a -> a.transformToMap()).collect(Collectors.toList());
    }

    public ArrayList<TaxableListDto> queryTaxableList(List<Long> orgList, List<String> declareCategories, Date declareDate, boolean isDeclare) {
        ArrayList<TaxableListDto> taxableListDtos = new ArrayList<TaxableListDto>();
        if (declareCategories != null && orgList != null) {
            String batchType = isDeclare ? DECLARE_BATCH_TYPE : DRAFT_BATCH_TYPE;
            Date month = DateUtils.getFirstDateOfMonth((Date)declareDate);
            for (String category : declareCategories) {
                List taxableListEnums = isDeclare ? TaxableListEnum.valueOfSbbCode((String)category) : TaxableListEnum.valueOfDgCode((String)category);
                if (taxableListEnums == null || taxableListEnums.size() <= 0) continue;
                TaxableListEnum taxableListEnum = (TaxableListEnum)taxableListEnums.get(0);
                for (Long orgId : orgList) {
                    DataResultVo dataResultVo1;
                    IBatchHandler iBatchHandler = BatchServiceFactory.createHandler((String)category, (String)batchType);
                    DataResultVo dataResultVo = iBatchHandler.checkBeforeRun(orgId.toString(), category, batchType);
                    if (!dataResultVo.getSuccess().booleanValue() || !(dataResultVo1 = iBatchHandler.initDateAndType(orgId.toString(), null, null, declareDate)).getSuccess().booleanValue() || !(dataResultVo1.getData() instanceof TaxableListDto)) continue;
                    TaxableListDto taxableListDto = (TaxableListDto)dataResultVo1.getData();
                    taxableListDto.setTaxcatetory(taxableListEnum.getBaseTaxId());
                    taxableListDto.setSbbcategory(taxableListEnum.getSbbCategory());
                    taxableListDto.setDgcategory(taxableListEnum.getDgCategory());
                    taxableListDto.setMonth(month);
                    taxableListDto.setPaystatus(TaxableListDto.PAYSTATUS_WJK);
                    taxableListDto.setDeclarestatus(TaxableListDto.DECLARESTATUS_WBZ);
                    taxableListDto.setTaxationsys(RuleFetchConstant.DEFALUT_TAXSYSTEM);
                    taxableListDto.setTaxareagroup(RuleFetchConstant.DEFALUT_TAXAREAGROUP);
                    taxableListDto.setDraftstatus(TaxableListDto.DRAFTSTATUS_WXBZ);
                    taxableListDtos.add(taxableListDto);
                }
            }
            ArrayList results = taxableListDtos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TaxableListDto>(Comparator.comparing(a -> a.getOrg() + DateUtils.format((Date)a.getSkssqq()) + DateUtils.format((Date)a.getSkssqz()) + a.getTemplatetype()))), ArrayList::new));
            return results;
        }
        return taxableListDtos;
    }

    public void fillDgInfo(ArrayList<TaxableListDto> taxableListDtos, Date declareDate) {
        LicenseCheckResult licenseCheckResult = LicenseCheckServiceHelper.checkTxftPerformGroup((String)"tcdrs");
        if (!licenseCheckResult.getHasLicense().booleanValue()) {
            taxableListDtos.forEach(a -> a.setDraftstatus(TaxableListDto.DRAFTSTATUS_WXBZ));
            return;
        }
        Set<Long> orgs = taxableListDtos.stream().map(TaxableListDto::getOrg).collect(Collectors.toSet());
        Date lastYearFirstDate = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)declareDate, (int)-1));
        Date lastYearLastDate = DateUtils.getLastDateOfYear1((Date)lastYearFirstDate);
        Date lastSeasonFirstDate = DateUtils.getFirstDateOfSeason((Date)DateUtils.addMonth((Date)declareDate, (int)-3));
        Date lastSeasonLastDate = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)declareDate, (int)-1));
        Map<Long, Long> taxMainMap = this.getMainOfficeMap(orgs);
        QFilter orgFilter = new QFilter("org", "in", orgs);
        QFilter draftpurposeFilter = new QFilter("draftpurpose", "=", (Object)"nssb");
        QFilter typeFilter = new QFilter("drafttype", "in", Arrays.asList("qysdsjb", "qysdsnb"));
        QFilter yearFilter = new QFilter("startdate", ">=", (Object)lastYearFirstDate).and("enddate", "<=", (Object)lastYearLastDate).and("drafttype", "=", (Object)"qysdsnb");
        QFilter seasonFilter = new QFilter("startdate", ">=", (Object)lastSeasonFirstDate).and("enddate", "<=", (Object)lastSeasonLastDate).and("drafttype", "=", (Object)"qysdsjb");
        QFilter dateFilter = yearFilter.or(seasonFilter);
        DynamicObjectCollection dgList = QueryServiceHelper.query((String)"tctb_draft_main", (String)"billstatus,billno,startdate,enddate,org,id", (QFilter[])new QFilter[]{orgFilter, dateFilter, draftpurposeFilter, typeFilter});
        Map<String, DynamicObject> dgMap = dgList.stream().collect(Collectors.toMap(a -> this.getUniqKey((DynamicObject)a, false), b -> b, (m, n) -> m));
        DynamicObjectCollection fzjgList = this.getFzjg(orgs, declareDate);
        List orgids = fzjgList.stream().map(e -> e.getString("orgid")).collect(Collectors.toList());
        for (TaxableListDto result : taxableListDtos) {
            String key = result.getOrg().toString() + DateUtils.format((Date)result.getSkssqq()) + DateUtils.format((Date)result.getSkssqz());
            DynamicObject dynamicObject = dgMap.get(key);
            if (!orgids.contains(result.getOrg().toString())) {
                if (dynamicObject != null) {
                    result.setDraftstatus(StringUtil.isEmpty((CharSequence)dynamicObject.getString("billstatus")) ? TaxableListDto.DRAFTSTATUS_WBZ : dynamicObject.getString("billstatus"));
                    result.setDraftNo(dynamicObject.getString("billno"));
                } else {
                    result.setDraftstatus(TaxableListDto.DRAFTSTATUS_WBZ);
                }
            }
            Long taxoffice = taxMainMap.getOrDefault(result.getOrg(), 0L);
            result.setTaxauthority(taxoffice);
        }
    }

    public void fillSbbInfo(ArrayList<TaxableListDto> taxableListDtos, Date declareDate) {
        Set<Long> orgs = taxableListDtos.stream().map(a -> a.getOrg()).collect(Collectors.toSet());
        Date lastYearFirstDate = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)declareDate, (int)-1));
        Date lastYearLastDate = DateUtils.getLastDateOfYear1((Date)lastYearFirstDate);
        Date lastSeasonFirstDate = DateUtils.getFirstDateOfSeason((Date)DateUtils.addMonth((Date)declareDate, (int)-3));
        Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)declareDate, (int)-1));
        Map<Long, Long> taxMainMap = this.getMainOfficeMap(orgs);
        QFilter orgFilter = new QFilter("org", "in", orgs);
        QFilter typeFilter = new QFilter("type", "in", TemplateTypeConstant.getTypeMap().get("qysds"));
        QFilter yearFilter = new QFilter("skssqq", ">=", (Object)lastYearFirstDate).and("skssqz", "<=", (Object)lastYearLastDate);
        QFilter seasonFilter = new QFilter("skssqq", ">=", (Object)lastSeasonFirstDate).and("skssqz", "<=", (Object)lastDateOfMonth);
        QFilter dateFilter = yearFilter.or(seasonFilter);
        DynamicObjectCollection sbbList = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"paystatus,declarestatus,billno,skssqq,skssqz,org,type,id", (QFilter[])new QFilter[]{dateFilter, orgFilter, typeFilter});
        Map<String, DynamicObject> sbbMap = sbbList.stream().collect(Collectors.toMap(a -> this.getUniqKey((DynamicObject)a, true), b -> b, (m, n) -> m));
        for (TaxableListDto result : taxableListDtos) {
            String key = result.getOrg().toString() + DateUtils.format((Date)result.getSkssqq()) + DateUtils.format((Date)result.getSkssqz()) + result.getTemplatetype();
            DynamicObject dynamicObject = sbbMap.get(key);
            if (dynamicObject != null) {
                result.setSbbno(dynamicObject.getString("billno"));
                result.setPaystatus(dynamicObject.getString("paystatus"));
                result.setDeclarestatus(dynamicObject.getString("declarestatus"));
            } else {
                result.setPaystatus(TaxableListDto.PAYSTATUS_WJK);
                result.setDeclarestatus(TaxableListDto.DECLARESTATUS_WBZ);
            }
            Long taxoffice = taxMainMap.getOrDefault(result.getOrg(), 0L);
            result.setTaxauthority(taxoffice);
        }
    }

    private Map<Long, Long> getMainOfficeMap(Collection<Long> orgs) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(new ArrayList<Long>(orgs));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            return ((List)result.getData()).stream().collect(Collectors.toMap(d -> d.getLong("taxorg.id"), d -> d.getLong("taxoffice.id"), (m, n) -> m));
        }
        return new HashMap<Long, Long>();
    }

    private String getUniqKey(DynamicObject a, boolean isDeclare) {
        if (isDeclare) {
            return a.getString("org") + DateUtils.format((Date)a.getDate("skssqq")) + DateUtils.format((Date)a.getDate("skssqz")) + a.getString("type");
        }
        return a.getString("org") + DateUtils.format((Date)a.getDate("startdate")) + DateUtils.format((Date)a.getDate("enddate"));
    }

    private DynamicObjectCollection getFzjg(Set<Long> orgids, Date endDate) {
        return QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.orgid orgid, orgrow.kdqjyqylx kdqjyqylx", (QFilter[])new QFilter[]{new QFilter("orgrow.orgid", "in", orgids), new QFilter("orgrow.kdqjyqylx", "in", Arrays.asList("311", "312")), new QFilter("taxtype", "=", (Object)"qysds"), new QFilter("status", "=", (Object)"2"), new QFilter("billstatus", "=", (Object)"C"), OrgUtils.getQFilter((Date)endDate)});
    }
}

