/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.mservice.engine;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.vo.AccrualRequest;
import kd.taxc.tccit.business.batch.BatchServiceFactory;
import kd.taxc.tccit.business.batch.IBatchHandler;
import kd.taxc.tccit.mservice.api.EngineService;
import kd.taxc.tccit.mservice.engine.BatchEngineAbstract;

public class AccrualEngineServiceImpl
extends BatchEngineAbstract
implements EngineService {
    private static final String BATCH_TYPE = "sjjt";
    private static final String ORGLIST = "orglist";
    private static final String DECLARETYPE = "declaretype";
    private static final String DRAFTPURPOSE = "draftpurpose";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String ORGID = "orgid";

    @Override
    public String generate(String request) {
        AccrualRequest accrualRequest = (AccrualRequest)SerializationUtils.fromJsonString((String)request, AccrualRequest.class);
        String orgId = accrualRequest.getOrgId();
        String category = accrualRequest.getCategory();
        Date accrualDate = accrualRequest.getAccrualDate();
        IBatchHandler iBatchHandler = BatchServiceFactory.createHandler((String)category, (String)BATCH_TYPE);
        return super.superGenerate(iBatchHandler, orgId, category, accrualRequest.getSkssqq(), accrualRequest.getSkssqz(), BATCH_TYPE, accrualDate);
    }

    @Override
    protected Map<String, Object> createCustomMap(String orgId, String category, Map<String, Object> data) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put(ORGID, orgId);
        customParams.put(SKSSQQ, data.get(SKSSQQ));
        customParams.put(SKSSQZ, data.get(SKSSQZ));
        ArrayList orgList = Lists.newArrayList((Object[])new Object[]{Long.parseLong(orgId)});
        customParams.put(ORGLIST, orgList);
        customParams.put(DRAFTPURPOSE, BATCH_TYPE);
        customParams.put("policy", data.get("policy"));
        return customParams;
    }

    @Override
    protected EngineModel createEngineModel(String orgId, String category, Map<String, Object> map) {
        String startDate = (String)map.get(SKSSQQ);
        String endDate = (String)map.get(SKSSQZ);
        EngineModel model = new EngineModel(orgId, startDate, endDate);
        model.setDeclareType(category);
        model.getCustom().putAll(map);
        return model;
    }
}

