/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.mservice.engine;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.tccit.business.batch.IBatchHandler;
import kd.taxc.tccit.business.pojo.DataResultVo;

public abstract class BatchEngineAbstract {
    private static final Log LOGGER = LogFactory.getLog(BatchEngineAbstract.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String superGenerate(IBatchHandler iBatchHandler, String orgId, String category, Date startDate, Date endDate, String batchType, Date executeTime) {
        DLock lock = DLock.create((String)("TCCIT_BATCH_LOCK_" + orgId + DateUtils.format((Date)startDate) + DateUtils.format((Date)endDate) + batchType + category));
        try {
            if (lock.tryLock(30000L)) {
                DataResultVo dataResultVo = iBatchHandler.checkBeforeRun(orgId, category, batchType);
                if (!dataResultVo.getSuccess().booleanValue()) {
                    String string = SerializationUtils.toJsonString((Object)EngineResponse.fail((String)dataResultVo.getMessage(), null));
                    return string;
                }
                DataResultVo initData = iBatchHandler.initData(orgId, startDate, endDate, executeTime);
                if (!initData.getSuccess().booleanValue()) {
                    String string = SerializationUtils.toJsonString((Object)EngineResponse.fail((String)initData.getMessage(), (Object)initData.getData()));
                    return string;
                }
                Map data = (Map)initData.getData();
                Map<String, Object> custom = this.createCustomMap(orgId, category, data);
                EngineModel engineModel = this.createEngineModel(orgId, category, custom);
                iBatchHandler.runTask(engineModel);
                String string = SerializationUtils.toJsonString((Object)EngineResponse.success((String)ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u6210\u529f", (String)"BatchEngineAbstract_0", (String)"taxc-tccit-mservice", (Object[])new Object[0]), (Object)data));
                return string;
            }
            String dataResultVo = SerializationUtils.toJsonString((Object)EngineResponse.fail((String)ResManager.loadKDString((String)"\u4efb\u52a1\u751f\u6210\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u4efb\u52a1\u6b63\u5728\u6267\u884c", (String)"BatchEngineAbstract_2", (String)"taxc-tccit-mservice", (Object[])new Object[0]), null));
            return dataResultVo;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            String string = SerializationUtils.toJsonString((Object)EngineResponse.failByMsgCode((String)String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"BatchEngineAbstract_1", (String)"taxc-tccit-mservice", (Object[])new Object[0]), e.getMessage()), (String)"500"));
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract Map<String, Object> createCustomMap(String var1, String var2, Map<String, Object> var3);

    protected abstract EngineModel createEngineModel(String var1, String var2, Map<String, Object> var3);
}

