/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.mservice.engine;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.vo.DeclareRequest;
import kd.taxc.tccit.business.batch.BatchServiceFactory;
import kd.taxc.tccit.business.batch.IBatchHandler;
import kd.taxc.tccit.mservice.api.EngineService;
import kd.taxc.tccit.mservice.engine.BatchEngineAbstract;

public class DeclareEngineServiceImpl
extends BatchEngineAbstract
implements EngineService {
    private static final String BATCH_TYPE = "declare";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String ORGLIST = "orglist";
    private static final String DECLARETYPE = "declaretype";
    private static final String DRAFTPURPOSE = "draftpurpose";
    private static final String ORGID = "orgid";

    @Override
    public String generate(String request) {
        DeclareRequest declareRequest = (DeclareRequest)SerializationUtils.fromJsonString((String)request, DeclareRequest.class);
        String orgId = declareRequest.getOrgId();
        String category = declareRequest.getCategory();
        Date startDate = declareRequest.getStartDate();
        Date endDate = declareRequest.getEndDate();
        Date executeTime = declareRequest.getExecuteTime();
        IBatchHandler iBatchHandler = BatchServiceFactory.createHandler((String)category, (String)BATCH_TYPE);
        return super.superGenerate(iBatchHandler, orgId, category, startDate, endDate, BATCH_TYPE, executeTime);
    }

    @Override
    protected Map<String, Object> createCustomMap(String orgId, String category, Map<String, Object> data) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put(ORGID, orgId);
        customParams.put(SKSSQQ, data.get(SKSSQQ));
        customParams.put(SKSSQZ, data.get(SKSSQZ));
        customParams.put("policy", data.get("policy"));
        customParams.put(ORGLIST, orgId);
        customParams.put(DECLARETYPE, category);
        return customParams;
    }

    @Override
    protected EngineModel createEngineModel(String orgId, String category, Map<String, Object> custom) {
        String startDate = (String)custom.get(SKSSQQ);
        String endDate = (String)custom.get(SKSSQZ);
        EngineModel engineModel = new EngineModel(orgId, startDate, endDate);
        engineModel.setDeclareType(category);
        engineModel.getCustom().putAll(custom);
        return engineModel;
    }
}

