/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.mservice.engine;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.vo.DraftRequest;
import kd.taxc.tccit.business.batch.BatchServiceFactory;
import kd.taxc.tccit.business.batch.IBatchHandler;
import kd.taxc.tccit.business.batch.PolicyService;
import kd.taxc.tccit.common.constant.DiscountTypeConstant;
import kd.taxc.tccit.mservice.api.EngineService;
import kd.taxc.tccit.mservice.engine.BatchEngineAbstract;

public class DraftEngineServiceImpl
extends BatchEngineAbstract
implements EngineService {
    private static final String BATCH_TYPE = "draft";
    private static final String ORGLIST = "orglist";
    private static final String DECLARETYPE = "declaretype";
    private static final String DRAFTPURPOSE = "draftpurpose";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String ORGID = "orgid";

    @Override
    public String generate(String request) {
        DraftRequest draftRequest = (DraftRequest)SerializationUtils.fromJsonString((String)request, DraftRequest.class);
        String orgId = draftRequest.getOrgId();
        String category = draftRequest.getCategory();
        Date executeTime = draftRequest.getExecuteTime();
        IBatchHandler iBatchHandler = BatchServiceFactory.createHandler((String)category, (String)BATCH_TYPE);
        return super.superGenerate(iBatchHandler, orgId, category, null, null, BATCH_TYPE, executeTime);
    }

    @Override
    protected Map<String, Object> createCustomMap(String orgId, String category, Map<String, Object> data) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put(ORGID, orgId);
        customParams.put(SKSSQQ, data.get(SKSSQQ));
        customParams.put(SKSSQZ, data.get(SKSSQZ));
        List orgList = "qysdsnb".equals(category) ? (data.get("isYearBranch") != null && ((Boolean)data.get("isYearBranch")).booleanValue() ? Lists.newArrayList((Object[])new Object[]{Long.parseLong(orgId)}) : PolicyService.getOrgIdsByYearPolicy((String)orgId, (String)((String)data.get(SKSSQQ)), (String)((String)data.get(SKSSQZ)))) : PolicyService.getOrgIdsBySeaSonalPolicy((String)orgId, (String)((String)data.get(SKSSQQ)), (String)((String)data.get(SKSSQZ)));
        customParams.put(ORGLIST, orgList);
        customParams.put(DECLARETYPE, category);
        customParams.put(DRAFTPURPOSE, "nssb");
        customParams.put("policy", data.get("policy"));
        customParams.put("isYearBranch", data.get("isYearBranch"));
        this.reductionItem(customParams, data);
        return customParams;
    }

    private void reductionItem(Map<String, Object> customParams, Map<String, Object> data) {
        DynamicObjectCollection ruleentryentity = (DynamicObjectCollection)data.get("itemchoiceentity");
        if (CollectionUtils.isEmpty((Collection)ruleentryentity)) {
            customParams.put("shownontax", "false");
            customParams.put("showtreduced", "false");
            customParams.put("showincred", "false");
            customParams.put("showtechincred", "false");
        } else {
            Optional<DynamicObject> type1 = ruleentryentity.stream().filter(e -> "1".equals(e.getString("type"))).findFirst();
            Optional<DynamicObject> type2 = ruleentryentity.stream().filter(e -> "2".equals(e.getString("type"))).findFirst();
            Optional<DynamicObject> type3 = ruleentryentity.stream().filter(e -> "3".equals(e.getString("type"))).findFirst();
            Optional<DynamicObject> type4 = ruleentryentity.stream().filter(e -> DiscountTypeConstant.techIds.contains(e.getLong("itemchoiceid"))).findFirst();
            customParams.put("shownontax", String.valueOf(type1.isPresent()));
            customParams.put("showtreduced", String.valueOf(type2.isPresent()));
            customParams.put("showincred", String.valueOf(type3.isPresent()));
            customParams.put("showtechincred", String.valueOf(type4.isPresent()));
        }
    }

    @Override
    protected EngineModel createEngineModel(String orgId, String category, Map<String, Object> map) {
        String startDate = (String)map.get(SKSSQQ);
        String endDate = (String)map.get(SKSSQZ);
        EngineModel model = new EngineModel(orgId, startDate, endDate);
        model.setDeclareType(category);
        model.getCustom().putAll(map);
        return model;
    }
}

