/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class AssertAcceDepreUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final String QUERY_NSSR_DRAFT = "select fid,forgid,ftaxorgid,fskssqq,fskssqz,fruleid  FROM t_tccit_assert_acce_total WHERE fispredata != '1'";
    private static final String QUERY_SJJT_DRAFT = "select fid,forgid,ftaxorgid,fskssqq,fskssqz,fruleid  FROM t_tccit_ass_acce_tot_sjjt WHERE fispredata != '1'";
    private static final String QUERY_NSSR_DRAFT_DE = "SELECT fid,forgid,ftaxorgid,fskssqq,fskssqz,famount,ffetchamount,fentrytype,fruleid  FROM t_tccit_depreciation_det WHERE forgid in (%s)";
    private static final String QUERY_SJJT_DRAFT_DE = "SELECT fid,forgid,ftaxorgid,fskssqq,fskssqz,famount,ffetchamount,fentrytype,fruleid  FROM t_tccit_dep_detail_sjjt WHERE forgid in (%s)";
    private static final String UPDATE_NSSR_DRAFT = "UPDATE t_tccit_assert_acce_total SET fzzzjje1=?, fxsjszjyhjsdzjje1= ?,fcurrentadjustamount1=? WHERE fid = ?";
    private static final String UPDATE_SJJT_DRAFT = "UPDATE t_tccit_ass_acce_tot_sjjt SET fzzzjje1=?, fxsjszjyhjsdzjje1= ?,fcurrentadjustamount1=? WHERE fid = ?";
    private static final Log LOGGER = LogFactory.getLog(AssertAcceDepreUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log;
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String info = log = SUCCESS_INFO;
        try {
            this.update();
        }
        catch (Exception var9) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(var9);
            LOGGER.error(ERROR_INFO, (Throwable)var9);
        }
        result.setLog(log);
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        List<Object[]> params = this.getParams(QUERY_NSSR_DRAFT, QUERY_NSSR_DRAFT_DE);
        List<Object[]> params1 = this.getParams(QUERY_SJJT_DRAFT, QUERY_SJJT_DRAFT_DE);
        try (TXHandle h = TX.requiresNew();){
            try {
                if (!CollectionUtils.isEmpty(params)) {
                    DBUtils.executeBatch((String)UPDATE_NSSR_DRAFT, params);
                }
                if (!CollectionUtils.isEmpty(params1)) {
                    DBUtils.executeBatch((String)UPDATE_SJJT_DRAFT, params1);
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private List<Object[]> getParams(String queryDraft, String queryDetail) {
        List queryNssbDraftDe;
        String forgidstr;
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        List queryNssbDraft = DBUtils.query((String)queryDraft);
        if (!CollectionUtils.isEmpty((Collection)queryNssbDraft) && (forgidstr = queryNssbDraft.stream().filter(a -> a.get("FORGID") != null).map(a -> a.get("FORGID").toString()).collect(Collectors.joining(","))) != null && forgidstr.length() > 0 && !CollectionUtils.isEmpty((Collection)(queryNssbDraftDe = DBUtils.query((String)String.format(queryDetail, forgidstr))))) {
            String key;
            HashMap<String, List> detailMap = new HashMap<String, List>();
            for (Map objectMap : queryNssbDraftDe) {
                key = this.getkey(objectMap);
                List orDefault = detailMap.getOrDefault(key, new ArrayList());
                orDefault.add(objectMap);
                detailMap.putIfAbsent(key, orDefault);
            }
            for (Map draftMap : queryNssbDraft) {
                key = this.getkey(draftMap);
                List details = (List)detailMap.get(key);
                if (CollectionUtils.isEmpty((Collection)details)) continue;
                BigDecimal zzzjje1 = details.stream().filter(a -> a.get("FAMOUNT") != null && "depreciate".equals(a.get("FENTRYTYPE"))).map(a -> (BigDecimal)a.get("FAMOUNT")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal xsjszjyhjsdzjje1 = details.stream().filter(a -> a.get("FAMOUNT") != null && "quick".equals(a.get("FENTRYTYPE"))).map(a -> (BigDecimal)a.get("FAMOUNT")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal currentadjustamount = xsjszjyhjsdzjje1.subtract(zzzjje1);
                paramsList.add(new Object[]{zzzjje1, xsjszjyhjsdzjje1, currentadjustamount, draftMap.get("FID")});
            }
        }
        return paramsList;
    }

    private String getkey(Map<String, Object> objectMap) {
        Object forgid = objectMap.get("FORGID");
        Object ftaxorgid = objectMap.get("FTAXORGID");
        Date fskssqq = (Date)objectMap.get("FSKSSQQ");
        Date fskssqz = (Date)objectMap.get("FSKSSQZ");
        Object fruleid = objectMap.get("FRULEID");
        forgid = forgid == null ? "" : forgid.toString();
        ftaxorgid = ftaxorgid == null ? "" : ftaxorgid.toString();
        fruleid = fruleid == null ? "" : fruleid.toString();
        return forgid + "_" + ftaxorgid + "_" + fruleid + "_" + DateUtils.format((Date)fskssqq) + "_" + DateUtils.format((Date)fskssqz);
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }
}

