/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.servicehelper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ServiceFactory {
    private static Log logger = LogFactory.getLog(ServiceFactory.class);
    private static Map<String, String> serviceMap = new ConcurrentHashMap<String, String>();

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            String appName = Instance.getAppName();
            String clusterName = Instance.getClusterName();
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u5728%2$s: %3$s\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"taxc-tccit-mservice", (Object[])new Object[0]), serviceName, clusterName, appName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        serviceMap.put("TaxinfoIncInfoUpgradeService", "kd.taxc.tccit.business.upgrade.TaxinfoIncInfoUpgradeService");
        serviceMap.put("DraftSeasonUpgradeService", "kd.taxc.tccit.business.upgrade.DraftSeasonUpDataUpgradeService");
        serviceMap.put("YearReportRuleUpgradeService", "kd.taxc.tccit.business.upgrade.YearReportRuleUpgradeService");
        serviceMap.put("SalaryAccountUpgradeService", "kd.taxc.tccit.business.upgrade.SalaryAccountUpgradeService");
        serviceMap.put("InterteDeductUpgradeService", "kd.taxc.tccit.business.upgrade.InterteDeductUpgradeService");
        serviceMap.put("SalaryIntedeductUpgradeService", "kd.taxc.tccit.business.upgrade.SalaryIntedeductUpgradeService");
        serviceMap.put("TccitDraftEditUpgradeService", "kd.taxc.tccit.business.upgrade.TccitDraftEditUpgradeService");
        serviceMap.put("TccitShareRateUpgradeService", "kd.taxc.tccit.business.upgrade.TccitShareRateUpgradeService");
        serviceMap.put("BranchShareBillPeriodUpgradeService", "kd.taxc.tccit.business.upgrade.BranchShareBillPeriodUpgradeService");
        serviceMap.put("TaxableListQueryService", "kd.taxc.tccit.mservice.declare.TaxableListQueryServiceImpl");
        serviceMap.put("MbksTaxbookSyncService", "kd.taxc.tccit.mservice.sync.MbksTaxbookSyncServiceImpl");
        serviceMap.put("AccrualService", "kd.taxc.tccit.mservice.engine.AccrualEngineServiceImpl");
        serviceMap.put("DraftService", "kd.taxc.tccit.mservice.engine.DraftEngineServiceImpl");
        serviceMap.put("DeclareService", "kd.taxc.tccit.mservice.engine.DeclareEngineServiceImpl");
        serviceMap.put("JtynseUpgradeService", "kd.taxc.tccit.business.upgrade.JtynseUpgradeService");
        serviceMap.put("YjAdmindivisionUpgradeService", "kd.taxc.tccit.business.upgrade.YjAdmindivisionUpgradeService");
        serviceMap.put("TaxBookAttachmentFileUpDataUpgradeService", "kd.taxc.tccit.business.upgrade.TaxBookAttachmentFileUpDataUpgradeService");
        serviceMap.put("BranchShareBillUpgradePlugin", "kd.taxc.tccit.formplugin.upgrade.BranchShareBillUpgradePlugin");
        serviceMap.put("RecoupDeficitStandBookService", "kd.taxc.tccit.mservice.standbook.RecoupDeficitStandBookServiceImpl");
        serviceMap.put("TccitDraftEditUpgradePlugin", "kd.taxc.tccit.formplugin.upgrade.TccitDraftEditUpgradePlugin");
        serviceMap.put("TccitAssertAcceDepreUpgradeService", "kd.taxc.tccit.mservice.upgrade.AssertAcceDepreUpgradeService");
        serviceMap.put("JtBqyjtsdseDraftSeasonUpDataUpgradeService", "kd.taxc.tccit.business.upgrade.JtBqyjtsdseDraftSeasonUpDataUpgradeService");
        serviceMap.put("TccitRuleConfigSynUpgradeService", "kd.taxc.tccit.business.upgrade.TccitRuleConfigSynUpgradeService");
        serviceMap.put("TccitRulePermItemUpgradeService", "kd.taxc.tccit.business.upgrade.TccitRulePermItemUpgradeService");
        serviceMap.put("TccitSharePlanSynUpgradeService", "kd.taxc.tccit.business.upgrade.TccitSharePlanSynUpgradeService");
        serviceMap.put("ApiRuleService", "kd.taxc.tccit.mservice.rule.ApiRuleServiceImpl");
        serviceMap.put("ZeroYjAdmindivisionUpgradeService", "kd.taxc.tccit.business.upgrade.ZeroYjAdmindivisionUpgradeService");
        serviceMap.put("AppParamsUpgradeService", "kd.taxc.tccit.business.upgrade.AppParamsUpgradeService");
        serviceMap.put("TccitPermItemUpgradeService", "kd.taxc.tccit.business.upgrade.TccitPermItemUpgradeService");
        serviceMap.put("TccitBranchSharePermItemUpgradeService", "kd.taxc.tccit.business.upgrade.TccitBranchSharePermItemUpgradeService");
        serviceMap.put("TccitBranchSharePermItemUpgradeService2", "kd.taxc.tccit.business.upgrade.TccitBranchSharePermItemUpgradeService2");
    }
}

