/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.apitude;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.apitude.ApitudeService;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.common.enums.ApitudeMiddEnum;
import org.apache.commons.collections.CollectionUtils;

public class ApitudeMiddService {
    private DraftTypeObjectVo draftTypeObjectVo;
    private Set<ApitudeMiddEnum> list24 = Sets.newHashSet((Object[])new ApitudeMiddEnum[]{ApitudeMiddEnum.RJJCDLQY_110, ApitudeMiddEnum.RJJCDLQY_400_ORIGINAL, ApitudeMiddEnum.RJJCDLQY_500_ORIGINAL, ApitudeMiddEnum.RJJCDLQY_600_ORIGINAL, ApitudeMiddEnum.RJJCDLQY_140_ORIGINAL, ApitudeMiddEnum.RJJCDLQY_140_NEW, ApitudeMiddEnum.RJJCDLQY_600_NEW, ApitudeMiddEnum.RJJCDLQY_500_NEW, ApitudeMiddEnum.RJJCDLQY_400_NEW, ApitudeMiddEnum.GXJSQYLX_HT002, ApitudeMiddEnum.QTZZQYLX_ETC001, ApitudeMiddEnum.SSYHQYLX_FTA002, ApitudeMiddEnum.RJJCDLQY_240_ORIGINAL, ApitudeMiddEnum.RJJCDLQY_330_ORIGINAL, ApitudeMiddEnum.RJJCDLQY_240_NEW, ApitudeMiddEnum.RJJCDLQY_330_NEW});
    private Set<ApitudeMiddEnum> list59 = Sets.newHashSet((Object[])new ApitudeMiddEnum[]{ApitudeMiddEnum.RJJCDLQY_120, ApitudeMiddEnum.RJJCDLQY_130, ApitudeMiddEnum.RJJCDLQY_131, ApitudeMiddEnum.RJJCDLQY_160, ApitudeMiddEnum.RJJCDLQY_151_ORIGINAL, ApitudeMiddEnum.RJJCDLQY_151_NEW});
    private Set<ApitudeMiddEnum> list15Rates = Sets.newHashSet((Object[])new ApitudeMiddEnum[]{ApitudeMiddEnum.RJJCDLQY_250, ApitudeMiddEnum.RJJCDLQY_340});
    private Set<ApitudeMiddEnum> list10Rates = Sets.newHashSet((Object[])new ApitudeMiddEnum[]{ApitudeMiddEnum.GXJSQYLX_HT001, ApitudeMiddEnum.JSXJXFWQY_110, ApitudeMiddEnum.JSXJXFWQY_120, ApitudeMiddEnum.JSXJXFWQY_130, ApitudeMiddEnum.JSXJXFWQY_210, ApitudeMiddEnum.JSXJXFWQY_220, ApitudeMiddEnum.JSXJXFWQY_230, ApitudeMiddEnum.JSXJXFWQY_240, ApitudeMiddEnum.QTZZQYLX_ETC004, ApitudeMiddEnum.SSYHQYLX_FTA004, ApitudeMiddEnum.SSYHQYLX_FTA006, ApitudeMiddEnum.SSYHQYLX_FTA007, ApitudeMiddEnum.SSYHQYLX_FTA008, ApitudeMiddEnum.SSYHQYLX_FTA009});
    private Set<ApitudeMiddEnum> list04 = Sets.newHashSet((Object[])new ApitudeMiddEnum[]{ApitudeMiddEnum.QTZZQYLX_ETC002});
    private Set<ApitudeMiddEnum> list02 = Sets.newHashSet((Object[])new ApitudeMiddEnum[]{ApitudeMiddEnum.QTZZQYLX_ETC003});
    private static final BigDecimal ZERO_FIVE = new BigDecimal("0.5");
    private static final BigDecimal ZERO_ONE = new BigDecimal("0.10");
    private static final BigDecimal ZERO_FOUR = new BigDecimal("0.40");
    private static final BigDecimal ZERO_ONE_FIVE = new BigDecimal("0.15");

    public ApitudeMiddService(DraftTypeObjectVo draftTypeObjectVo) {
        this.draftTypeObjectVo = draftTypeObjectVo;
    }

    public void clearMiddApitude(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)this.draftTypeObjectVo.getJmsdMiddApitude().getNumber(), (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    public DynamicObjectCollection createMiddApitudeTable(Date skssqq, Date skssqz, String orgid, DynamicObjectCollection apitudeEntryEntity, String suittype, BigDecimal row9, BigDecimal row10, BigDecimal row11) {
        this.clearMiddApitude(Long.valueOf(orgid), skssqq, skssqz);
        DynamicObjectCollection sumObj = new DynamicObjectCollection();
        List<DynamicObject> collects = apitudeEntryEntity.stream().filter(s -> s.getBoolean("yxsy")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collects)) {
            return null;
        }
        int index = 1;
        index = this.buildByApitudeType(orgid, skssqq, skssqz, suittype, row9, row11, sumObj, collects, index);
        this.buildBySummary(orgid, skssqq, skssqz, row9, row10, row11, sumObj, index, suittype);
        if (CollectionUtils.isNotEmpty((Collection)sumObj)) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sumObj.toArray((Object[])new DynamicObject[0])));
        }
        return sumObj;
    }

    private void buildBySummary(String orgid, Date skssqq, Date skssqz, BigDecimal row9, BigDecimal row10, BigDecimal row11, DynamicObjectCollection sumObj, int index, String suittype) {
        QFilter filter = QFilter.of((String)"orgid=? and skssqq=? and skssqz=?", (Object[])new Object[]{Long.parseLong(orgid), skssqq, skssqz});
        DynamicObject[] summary = BusinessDataServiceHelper.load((String)this.draftTypeObjectVo.getQyyh().getNumber(), (String)"companytype,ftrate,jmrate", (QFilter[])new QFilter[]{filter});
        if (summary == null || summary.length == 0) {
            return;
        }
        Map<DynamicObject, List<DynamicObject>> groupMap = Arrays.stream(summary).collect(Collectors.groupingBy(s -> s.getDynamicObject("companytype")));
        for (Map.Entry<DynamicObject, List<DynamicObject>> entry : groupMap.entrySet()) {
            DynamicObject companytype = entry.getKey();
            String name = companytype.getString("projectname");
            String parentnumber = companytype.getString("parentnumber");
            String number = companytype.getString("number");
            List<DynamicObject> values = entry.getValue();
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject dynamicObject : values) {
                BigDecimal ftrate = dynamicObject.getBigDecimal("ftrate");
                BigDecimal jmrate = dynamicObject.getBigDecimal("jmrate");
                amount = amount.add(row11.multiply(ftrate).multiply(jmrate));
            }
            amount = amount.divide(row10, 2, 4);
            List<ApitudeMiddEnum> apitudeMiddEnums = ApitudeMiddEnum.filterByCode(parentnumber, number);
            ApitudeMiddEnum apitudeMiddEnum = null;
            if (!CollectionUtils.isEmpty(apitudeMiddEnums)) {
                apitudeMiddEnum = ApitudeMiddService.getApitudeMiddEnum(apitudeMiddEnums, parentnumber, number, suittype);
            }
            if (apitudeMiddEnum == null) continue;
            DynamicObject object = this.buildTable(Long.valueOf(orgid), skssqq, skssqz, name, apitudeMiddEnum != null ? apitudeMiddEnum.getKeyword() : null, amount, parentnumber, number, String.valueOf(index));
            sumObj.add((Object)object);
            ++index;
        }
    }

    private int buildByApitudeType(String orgid, Date skssqq, Date skssqz, String suittype, BigDecimal row9, BigDecimal row11, DynamicObjectCollection sumObj, List<DynamicObject> collects, int index) {
        int declareYear = DateUtils.getYearOfDate((Date)skssqq);
        ApitudeMiddService.makeToLastOne(collects);
        for (DynamicObject dynamicObject : collects) {
            String apitudetype = dynamicObject.getString("apitudetype");
            String type = ApitudeService.getApitudeTypeMap().get(apitudetype);
            if ("SSYHQYLX".equals(type)) continue;
            DynamicObject companytype = dynamicObject.getDynamicObject("companytype");
            String code = companytype.getString("number");
            int profitmyear = dynamicObject.getInt("profitmyear");
            DynamicObject middApitude = BusinessDataServiceHelper.newDynamicObject((String)this.draftTypeObjectVo.getJmsdMiddApitude().getNumber());
            middApitude.set("orgid", (Object)Long.valueOf(orgid));
            middApitude.set("skssqq", (Object)skssqq);
            middApitude.set("skssqz", (Object)skssqz);
            middApitude.set("parentcode", (Object)type);
            middApitude.set("code", (Object)code);
            List<ApitudeMiddEnum> apitudeMiddEnums = ApitudeMiddEnum.filterByCode(type, code);
            ApitudeMiddEnum apitudeMiddEnum = null;
            if (CollectionUtils.isEmpty(apitudeMiddEnums)) continue;
            apitudeMiddEnum = ApitudeMiddService.getApitudeMiddEnum(apitudeMiddEnums, type, code, suittype);
            middApitude.set("itemname", (Object)(apitudeMiddEnum != null ? apitudeMiddEnum.getMsg() : ""));
            middApitude.set("item", (Object)ApitudeMiddService.getItemByName(apitudeMiddEnum != null ? apitudeMiddEnum.getKeyword() : null));
            BigDecimal sumAmount = this.getSumAmount(Long.valueOf(orgid), skssqq, skssqz, declareYear, profitmyear, apitudeMiddEnum, collects, row9, row11);
            middApitude.set("sumamount", (Object)(sumAmount != null ? sumAmount.setScale(2, 4) : BigDecimal.ZERO));
            middApitude.set("itemno", (Object)String.valueOf(index++));
            sumObj.add((Object)middApitude);
        }
        return index;
    }

    private static Long getItemByName(String itemname) {
        QFilter q1 = new QFilter("template", "=", (Object)"qysdsyj");
        QFilter q2 = new QFilter("type", "=", (Object)"yhxm");
        QFilter q3 = new QFilter("name", "like", (Object)("%" + itemname + "%"));
        DynamicObject[] discountTrees = BusinessDataServiceHelper.load((String)"tpo_discount_tree", (String)"id,name,number", (QFilter[])new QFilter[]{q1, q2, q3});
        if (discountTrees != null & discountTrees.length > 0) {
            return discountTrees[0].getLong("id");
        }
        return 0L;
    }

    public DynamicObject createMiddApitudeTable(Date skssqq, Date skssqz, String orgid, BigDecimal amount) {
        this.clearMiddApitude(Long.valueOf(orgid), skssqq, skssqz);
        DynamicObject object = this.buildTable(Long.valueOf(orgid), skssqq, skssqz, ApitudeMiddEnum.ISXXWLQY_ISXXWLQY.getMsg(), ApitudeMiddEnum.ISXXWLQY_ISXXWLQY.getKeyword(), amount, ApitudeMiddEnum.ISXXWLQY_ISXXWLQY.getParentCode(), ApitudeMiddEnum.ISXXWLQY_ISXXWLQY.getCode(), "1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        return object;
    }

    public DynamicObject buildTable(Long orgid, Date skssqq, Date skssqz, String itemname, String keyword, BigDecimal amount, String parentcode, String code, String itemno) {
        DynamicObject middApitude = BusinessDataServiceHelper.newDynamicObject((String)this.draftTypeObjectVo.getJmsdMiddApitude().getNumber());
        middApitude.set("orgid", (Object)orgid);
        middApitude.set("skssqq", (Object)skssqq);
        middApitude.set("skssqz", (Object)skssqz);
        middApitude.set("parentcode", (Object)parentcode);
        middApitude.set("code", (Object)code);
        middApitude.set("itemname", (Object)itemname);
        middApitude.set("item", (Object)ApitudeMiddService.getItemByName(keyword));
        middApitude.set("sumamount", (Object)amount);
        middApitude.set("itemno", (Object)itemno);
        return middApitude;
    }

    public static void makeToLastOne(List<DynamicObject> collects) {
        Map<Boolean, List<DynamicObject>> maps = collects.stream().collect(Collectors.partitioningBy(s -> s.getDynamicObject("companytype").getString("number").equals("FTA001")));
        collects.clear();
        collects.addAll((Collection<DynamicObject>)maps.get(Boolean.FALSE));
        collects.addAll((Collection<DynamicObject>)maps.get(Boolean.TRUE));
    }

    private static ApitudeMiddEnum getApitudeMiddEnum(List<ApitudeMiddEnum> apitudeMiddEnums, String parentCode, String code, String suittype) {
        if (apitudeMiddEnums.size() == 1) {
            return apitudeMiddEnums.get(0);
        }
        String flag = "1".equals(suittype) ? "_NEW" : "_ORIGINAL";
        Optional<ApitudeMiddEnum> first = apitudeMiddEnums.stream().filter(s -> s.name().endsWith(flag)).findFirst();
        return first.isPresent() ? first.get() : null;
    }

    public BigDecimal getSumAmount(Long orgid, Date startDate, Date endDate, int declareYear, int profitmyear, ApitudeMiddEnum apitudeMiddEnum, List<DynamicObject> collects, BigDecimal row9, BigDecimal row11) {
        int diff = declareYear - profitmyear;
        IntFunction<Boolean> test02 = a -> 0 <= a && a < 2;
        IntFunction<Boolean> test24 = a -> 2 <= a && a <= 4;
        IntFunction<Boolean> test05 = a -> 0 <= a && a < 5;
        IntFunction<Boolean> test59 = a -> 5 <= a && a <= 9;
        IntFunction<Boolean> test04 = a -> 0 <= a && a <= 4;
        IntFunction<Boolean> after2030 = year -> 2030 - year < 0;
        IntFunction<Boolean> before2030 = year -> 2030 - year >= 0;
        if (this.list24.contains((Object)apitudeMiddEnum)) {
            if (test02.apply(diff).booleanValue()) {
                return row11;
            }
            if (test24.apply(diff).booleanValue()) {
                return row11.multiply(ZERO_FIVE);
            }
        }
        if (this.list59.contains((Object)apitudeMiddEnum)) {
            if (test05.apply(diff).booleanValue()) {
                return row11;
            }
            if (test59.apply(diff).booleanValue()) {
                return row11.multiply(ZERO_FIVE);
            }
        }
        if (this.list15Rates.contains((Object)apitudeMiddEnum)) {
            if (test05.apply(diff).booleanValue()) {
                return row11;
            }
            if (test59.apply(diff).booleanValue()) {
                return row9.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : row9.multiply(ZERO_ONE_FIVE);
            }
        }
        if (this.list10Rates.contains((Object)apitudeMiddEnum)) {
            if (ApitudeMiddEnum.GXJSQYLX_HT001 == apitudeMiddEnum && this.isSZTaxOffice(orgid)) {
                return row11.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : row11.multiply(ZERO_FOUR);
            }
            return row9.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : row9.multiply(ZERO_ONE);
        }
        if (this.list04.contains((Object)apitudeMiddEnum) && test04.apply(diff).booleanValue()) {
            return row11;
        }
        if (this.list02.contains((Object)apitudeMiddEnum)) {
            if (after2030.apply(declareYear).booleanValue()) {
                return BigDecimal.ZERO;
            }
            return row11;
        }
        if (ApitudeMiddEnum.QTZZQYLX_ETC009 == apitudeMiddEnum) {
            return row11;
        }
        if (ApitudeMiddEnum.SSYHQYLX_FTA001 == apitudeMiddEnum) {
            if (collects.size() == 1) {
                if (before2030.apply(declareYear).booleanValue()) {
                    return row9.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : row9.multiply(ZERO_ONE);
                }
            } else {
                BigDecimal bnlj;
                QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
                QFilter quarterFilter = new QFilter("skssqq", "=", (Object)startDate).and(new QFilter("skssqz", "=", (Object)endDate));
                DynamicObject second = (DynamicObject)collects.stream().skip(1L).findFirst().get();
                String apitudetype = second.getString("apitudetype");
                String type = ApitudeService.getApitudeTypeMap().get(apitudetype);
                QFilter parentcodeFilter = new QFilter("parentcode", "=", (Object)type);
                DynamicObject companytype = second.getDynamicObject("companytype");
                QFilter codeFilter = new QFilter("code", "=", (Object)companytype.getString("number"));
                DynamicObjectCollection collection = QueryServiceHelper.query((String)this.draftTypeObjectVo.getJmsdMiddApitude().getNumber(), (String)"sum(sumamount) as sumamount", (QFilter[])new QFilter[]{orgFilter, quarterFilter});
                BigDecimal bigDecimal = bnlj = CollectionUtils.isEmpty((Collection)collection) ? BigDecimal.ZERO : ((DynamicObject)collection.get(0)).getBigDecimal("sumamount");
                if (before2030.apply(declareYear).booleanValue()) {
                    if (row11.compareTo(bnlj) == 0) {
                        return BigDecimal.ZERO;
                    }
                    if (bnlj.compareTo(BigDecimal.ZERO) == 0) {
                        return row9.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : row9.multiply(ZERO_ONE);
                    }
                    if (bnlj.compareTo(BigDecimal.ZERO) != 0 || row11.compareTo(bnlj) != 0) {
                        return row9.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : row9.multiply(ZERO_FIVE).multiply(ZERO_ONE);
                    }
                }
            }
        }
        if (ApitudeMiddEnum.SSYHQYLX_FTA003 == apitudeMiddEnum && before2030.apply(declareYear).booleanValue() && test04.apply(diff).booleanValue()) {
            return row11;
        }
        if (ApitudeMiddEnum.SSYHQYLX_FTA005 == apitudeMiddEnum && test04.apply(diff).booleanValue()) {
            return row9.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : row9.multiply(ZERO_ONE);
        }
        return BigDecimal.ZERO;
    }

    private boolean isSZTaxOffice(Long orgid) {
        if (orgid == null) {
            return false;
        }
        DynamicObject object = OrgGroupService.loadTaxMainByOrgId(orgid.toString());
        return "14403000000".equals(Optional.ofNullable(object.getDynamicObject("taxoffice")).map(s -> s.getString("number")).orElseGet(() -> ""));
    }
}

