/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.apitude;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class ApitudeService {
    public static Map<String, String> getApitudeTypeMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "RJJCDLQY");
        map.put("2", "JSXJXFWQY");
        map.put("3", "SSYHQYLX");
        map.put("4", "GXJSQYLX");
        map.put("5", "QTZZQYLX");
        return map;
    }

    public static DynamicObjectCollection getApitudeEntryEntity(Long orgId) {
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId).getData();
        DynamicObjectCollection apitudeentryentity = new DynamicObjectCollection();
        if (taxMain == null) {
            return apitudeentryentity;
        }
        apitudeentryentity = taxMain.getDynamicObjectCollection("apitudeentryentity");
        return apitudeentryentity;
    }

    public static Boolean show(DynamicObjectCollection entryEntity, Date startdate, Date enddate) {
        List<DynamicObject> list = ApitudeService.findSuitOneCard(entryEntity, startdate, enddate);
        return CollectionUtils.isNotEmpty(list);
    }

    public static DynamicObject findSuitOne(DynamicObjectCollection entryEntity, Date startdate, Date enddate) {
        Date declareLastMonth = DateUtils.getLastDateOfYear((Date)startdate);
        Optional<DynamicObject> anyOne = entryEntity.stream().filter(s -> {
            Date apitudestartdate = s.getDate("apitudestartdate");
            Date apitudeenddate = s.getDate("apitudeenddate");
            return !apitudestartdate.after(DateUtils.getLastDateOfYear((Date)declareLastMonth));
        }).findAny();
        return anyOne.isPresent() ? anyOne.get() : null;
    }

    public static List<DynamicObject> findSuitOneCard(DynamicObjectCollection entryEntity, Date startdate, Date enddate) {
        ArrayList highTechCompanytypeCodes = Lists.newArrayList((Object[])new String[]{"HT001", "HT002"});
        Date declareLastMonth = DateUtils.getLastDateOfYear((Date)startdate);
        List<DynamicObject> result = entryEntity.stream().filter(s -> "4".equals(s.getString("apitudetype")) && highTechCompanytypeCodes.contains(s.getDynamicObject("companytype").getString("number"))).filter(s -> {
            Date apitudestartdate = s.getDate("apitudestartdate");
            Date apitudeenddate = s.getDate("apitudeenddate");
            if (apitudeenddate == null) {
                return apitudestartdate.before(DateUtils.getLastDateOfYear((Date)declareLastMonth));
            }
            int monthOfDate = DateUtils.getMonthOfDate((Date)apitudeenddate);
            int declareMonth = DateUtils.getMonthOfDate((Date)declareLastMonth);
            return apitudestartdate.before(DateUtils.getLastDateOfYear((Date)declareLastMonth)) && !declareLastMonth.after(apitudeenddate);
        }).collect(Collectors.toList());
        return result;
    }

    public static DynamicObjectCollection getShareHolderEntry(Long orgId) {
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId).getData();
        DynamicObjectCollection shareHolderEntryEntity = new DynamicObjectCollection();
        if (taxMain == null) {
            return shareHolderEntryEntity;
        }
        shareHolderEntryEntity = taxMain.getDynamicObjectCollection("entryentity1");
        return shareHolderEntryEntity;
    }
}

