/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.batch;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;

public class DeclareHelperService {
    public DeclareRequestModel createDeclareRequestModel(DynamicObject org, Date skssqq, Date skssqz, String templateType) {
        long orgid = org.getDynamicObject("taxorg").getLong("id");
        boolean sysParams = SystemParamUtil.getZeroDeclareParameter((String)"tccit", (String)"zerodeclare", (long)orgid);
        String zerodeclare = sysParams ? "1" : "0";
        String billNo = DeclareUtils.getBillNo((String)String.valueOf(orgid), (Date)skssqq, (Date)skssqz, (String)templateType);
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setOrgId(Long.valueOf(orgid));
        requestModel.setId(DeclareServiceHelper.generateSBBId(null));
        requestModel.setSkssqq(DateUtils.format((Date)skssqq));
        requestModel.setSkssqz(DateUtils.format((Date)skssqz));
        requestModel.setBillNo(billNo);
        requestModel.setTemplateType(templateType);
        requestModel.setRefresh(Boolean.TRUE);
        HashMap<String, String> extendParams = new HashMap<String, String>();
        extendParams.put("zerodeclare", zerodeclare);
        requestModel.setExtendParams(extendParams);
        requestModel.addBusinessValue("zerodeclare", zerodeclare);
        return requestModel;
    }

    public String getTemplateType(String category, String levytype, Boolean isFzSummary, boolean zerodecclare) {
        if (zerodecclare && "qysdsjb".equals(category)) {
            return "qysdsjb";
        }
        if ("qysdsjb".equals(category) && "czzs".equals(levytype)) {
            return "qysdsjb";
        }
        if ("qysdsjb".equals(category) && "hdzs".equals(levytype)) {
            return "qysds_hdzs_jb";
        }
        if ("qysdsnb".equals(category) && "hdzs".equals(levytype)) {
            return "qysds_hdzs_nb";
        }
        if ("qysdsnb".equals(category) && isFzSummary.booleanValue()) {
            return "qysdsnb_fzjg";
        }
        return "qysdsnb";
    }

    public Long getDefaultAccountOrg(Long taxOrg) {
        Long orgRelation = (Long)OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId((Long)taxOrg).getData();
        return null != orgRelation ? orgRelation : 0L;
    }
}

