/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.batch;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.tccit.business.batch.AbstractCheckHandler;
import kd.taxc.tccit.business.pojo.DataResultVo;

public class LicenseCheckService
extends AbstractCheckHandler {
    private static final String DRAFT = "draft";
    private static final String DECLARE = "declare";
    private static Log logger = LogFactory.getLog(LicenseCheckService.class);

    @Override
    public DataResultVo handle(String orgid, String category, String batchType, TaxableListDto taxableListDto) {
        DataResultVo checkLicense;
        boolean zerodeclare;
        logger.info("==========license\u6821\u9a8c\u5f00\u59cb===========");
        if (DRAFT.equals(batchType)) {
            zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tccit", (String)"zerodeclare", (long)Long.parseLong(orgid));
            if (zerodeclare) {
                return DataResultVo.fail(ResManager.loadKDString((String)"\u96f6\u7533\u62a5\u65e0\u9700\u751f\u6210\u5e95\u7a3f", (String)"LicenseCheckService_0", (String)"taxc-tccit", (Object[])new Object[0]));
            }
            DataResultVo checkDraft = this.checkDraftLicense();
            if (!checkDraft.getSuccess().booleanValue()) {
                return DataResultVo.fail(checkDraft.getMessage());
            }
        }
        if (DECLARE.equals(batchType) && !(checkLicense = (zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tccit", (String)"zerodeclare", (long)Long.parseLong(orgid))) && "qysdsjb".equals(category) ? this.checkDeclareLicense(orgid, "tccit", true) : this.checkDeclareLicense(orgid, "tccit", false)).getSuccess().booleanValue()) {
            return checkLicense;
        }
        return super.next(orgid, category, batchType, taxableListDto);
    }

    private DataResultVo checkDraftLicense() {
        LicenseCheckResult result = LicenseCheckServiceHelper.checkTxftPerformGroup((String)"tcdrs");
        if (result.getHasLicense().booleanValue()) {
            return DataResultVo.success("ok");
        }
        return DataResultVo.fail(result.getMsg());
    }

    private DataResultVo checkDeclareLicense(Object orgid, String appid, boolean isZeroDeclare) {
        TaxResult result;
        if (!isZeroDeclare && (result = TaxcLicenseCheckDataServiceHelper.check((Long)Long.parseLong(String.valueOf(orgid)), (String)appid)) != null && Boolean.TRUE.equals(result.getData())) {
            return DataResultVo.fail(result.getMessage());
        }
        return DataResultVo.success("ok");
    }
}

