/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.batch;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.declare.DeclareCompanyTypeService;

public class OrgHelperService {
    public DynamicObject findTaxMain(Long orgId) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQysdsByOrgIds(Collections.singletonList(orgId));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            return (DynamicObject)((List)result.getData()).get(0);
        }
        return null;
    }

    public DynamicObject findTaxInfos(DynamicObject org, String taxType) {
        return org.getDynamicObjectCollection("categoryentryentity").stream().filter(s -> taxType.equals(s.getString("taxtype"))).findFirst().orElse(null);
    }

    public Boolean checkOrgDeclaration(Long orgid, Date startDate, Date endDate, String declaration, String taxtype, String levelname) {
        DynamicObjectCollection dynamicObjects = this.queryOrgDeclaration(orgid, startDate, endDate, declaration, taxtype, levelname);
        return dynamicObjects != null && dynamicObjects.size() > 0;
    }

    public DynamicObjectCollection queryOrgDeclaration(Long orgid, Date startDate, Date endDate, String declaration, String taxtype, String levelname) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter q1 = new QFilter("orgrow.orgid", "=", (Object)orgid);
        QFilter q2 = new QFilter("taxtype", "=", (Object)taxtype);
        QFilter q3 = new QFilter("orgrow.declaration", "=", (Object)declaration);
        QFilter q4 = new QFilter("effectdate", "<=", (Object)startDate);
        QFilter q5 = new QFilter("invaliddate", "is null", null).or(new QFilter("invaliddate", ">=", (Object)endDate));
        QFilter q6 = new QFilter("billstatus", "=", (Object)"C");
        if (StringUtil.isNotEmpty((CharSequence)levelname)) {
            q5.and(new QFilter("orgrow.levelname", "=", (Object)levelname));
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"id,orgrow.orgid as orgid,orgrow.collectorg as collectorg,orgrow.shareid as shareid", (QFilter[])new QFilter[]{statusFilter, q1, q2, q3, q4, q5, q6});
        return dynamicObjects;
    }

    public Boolean isFzGroup(String orgid, String startDate, String endDate) {
        String declaretype = DeclareCompanyTypeService.getDeclareCompanyType(orgid, endDate);
        return DeclareCompanyTypeService.noNeedApply(declaretype, orgid, startDate, endDate);
    }
}

