/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.batch;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class PolicyService {
    public static final String TCCIT_POLICY_CONFIRM = "tccit_policy_confirm";
    public static final String TCCIT_SEASONAL_POLICY = "tccit_seasonal_policy";

    public static List<Object> getOrgIdsByYearPolicy(String orgid, String startdate, String enddate) {
        QFilter q1 = new QFilter("orgid", "=", (Object)Long.parseLong(orgid));
        QFilter q2 = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)startdate));
        QFilter q3 = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)enddate));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)TCCIT_POLICY_CONFIRM, (String)"id", (QFilter[])new QFilter[]{q1, q2, q3});
        if (dynamicObject != null) {
            DynamicObject load = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)TCCIT_POLICY_CONFIRM);
            DynamicObjectCollection treeentryentity = load.getDynamicObjectCollection("treeentryentity");
            List<Object> taxorgs = treeentryentity.stream().map(s -> s.getString("taxorg_id")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(taxorgs)) {
                return Lists.newArrayList((Object[])new Object[]{orgid});
            }
            return taxorgs;
        }
        return Lists.newArrayList((Object[])new Object[]{orgid});
    }

    public static List<Object> getOrgIdsBySeaSonalPolicy(String orgid, String startdate, String enddate) {
        QFilter q1 = new QFilter("orgid", "=", (Object)Long.parseLong(orgid));
        QFilter q2 = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)startdate));
        QFilter q3 = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)enddate));
        QFilter q4 = new QFilter("draftpurpose", "=", (Object)"nssb");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)TCCIT_SEASONAL_POLICY, (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4});
        if (dynamicObject != null) {
            DynamicObject load = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)TCCIT_SEASONAL_POLICY);
            DynamicObjectCollection treeentryentity = load.getDynamicObjectCollection("treeentryentity");
            List<Object> taxorgs = treeentryentity.stream().map(s -> s.getLong("taxorg_id")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(taxorgs)) {
                return Lists.newArrayList((Object[])new Object[]{Long.parseLong(orgid)});
            }
            return taxorgs;
        }
        return Lists.newArrayList((Object[])new Object[]{Long.parseLong(orgid)});
    }
}

