/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.batch;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tccit.business.batch.AbstractCheckHandler;
import kd.taxc.tccit.business.pojo.DataResultVo;

public class TaxcCardCheckService
extends AbstractCheckHandler {
    private static Log logger = LogFactory.getLog(TaxcCardCheckService.class);

    @Override
    public DataResultVo handle(String orgid, String category, String batchType, TaxableListDto taxableListDto) {
        logger.info("==============\u6821\u9a8c\u7eb3\u7a0e\u4e3b\u4f53\u7ef4\u62a4\u7684\u4f01\u4e1a\u6240\u5f97\u7a0e\u7a0e\u79cd\u662f\u5426\u542f\u7528==================");
        DataResultVo dataResultVo = this.isEnableTaxcCard(orgid);
        if (!dataResultVo.getSuccess().booleanValue()) {
            return dataResultVo;
        }
        return super.next(orgid, category, batchType, taxableListDto);
    }

    private DataResultVo isEnableTaxcCard(String orgid) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgid));
        if (!result.isSuccess()) {
            return DataResultVo.fail(result.getMessage());
        }
        if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7a0e\u52a1\u4fe1\u606f", (String)"TaxcCardCheckService_0", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        DynamicObject taxMain = (DynamicObject)result.getData();
        Boolean qysdsEnable = (Boolean)TaxcMainDataServiceHelper.isTaxcMainQysdsEnableByOrgId((Long)Long.parseLong(orgid)).getData();
        if (!qysdsEnable.booleanValue()) {
            return DataResultVo.fail(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7,\u4f01\u4e1a\u6240\u5f97\u7a0e\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"TaxcCardCheckService_1", (String)"taxc-tccit", (Object[])new Object[0]), taxMain.getString("taxorg.taxpayer")));
        }
        return DataResultVo.success("ok");
    }
}

