/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.batch.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.accrual.AccrualMQSender;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.batch.IBatchDraftService;
import kd.taxc.tccit.business.declare.DeclareCompanyTypeService;
import kd.taxc.tccit.business.draft.ApportionService;
import kd.taxc.tccit.business.draft.BranchCalcPageService;
import kd.taxc.tccit.business.pojo.DataResultVo;
import kd.taxc.tccit.business.pojo.InitSeasonalPolicyVo;
import kd.taxc.tccit.business.policy.SeasonalPolicyService;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class BatchAccrualService
implements IBatchDraftService {
    private static Log LOGGER = LogFactory.getLog(BatchAccrualService.class);
    private static final String ENTRY = "apitudeentryentity";
    protected static final String BRANCH_ENTRY = "branchapitudeentryentity";
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String ITEMCHOICEENTITY = "itemchoiceentity";
    private static final String RULERNTRYENTITY = "ruleentryentity";
    private static final String POLICY_ENTRY = "tccit_seasonal_policy";
    private BranchCalcPageService branchCalcPageService = new BranchCalcPageService();
    private ApportionService apportionService = new ApportionService();

    @Override
    public DataResultVo isExistLastData(Long orgid, Date startDate, Date endDate, Date lastStartDate, Date lastEndDate) {
        List<QFilter> qFilters = BatchAccrualService.buildQFilters(orgid, startDate, endDate);
        boolean exists = QueryServiceHelper.exists((String)"tpo_declare_main_tsd", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (exists) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u518d\u6b21\u751f\u6210", (String)"BatchAccrualService_0", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        if (this.isFzjg(orgid, endDate)) {
            return DataResultVo.ok();
        }
        return DataResultVo.ok();
    }

    @Override
    public Boolean draftIsExists(Long orgid, String templatetype, Date startdate, Date enddate) {
        return null;
    }

    private boolean isFzjg(Long orgid, Date endDate) {
        return QueryServiceHelper.exists((String)"tctb_org_group_latest", (QFilter[])new QFilter[]{new QFilter("orgrow.orgid", "=", (Object)orgid), new QFilter("orgrow.declaration", "=", (Object)"3"), new QFilter("taxtype", "=", (Object)"qysds"), new QFilter("status", "=", (Object)"2"), new QFilter("billstatus", "=", (Object)"C"), OrgUtils.getQFilter((Date)endDate)});
    }

    @Override
    public DataResultVo createPolicyNew(Long orgid, Date startdate, Date enddate, Date lastStartDate, Date lastEndDate) {
        InitSeasonalPolicyVo initSeasonalPolicyVo = SeasonalPolicyService.initSeasonalPolicy(orgid, startdate, enddate, "sjjt");
        if (!initSeasonalPolicyVo.getExistsPreviousDraft().booleanValue() || initSeasonalPolicyVo.getSospersonnum() == 0 || initSeasonalPolicyVo.getEospersonnum() == 0) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u4e0a\u671f\u9884\u7f34\u7533\u62a5\u4ece\u4e1a\u4eba\u6570\u4fe1\u606f\uff0c\u65e0\u6cd5\u751f\u6210\u8ba1\u63d0\u5e95\u7a3f", (String)"BatchAccrualService_1", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        DynamicObject dynamicObject = this.contractPolicy(initSeasonalPolicyVo, orgid, startdate, enddate);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return DataResultVo.success("ok", dynamicObject);
    }

    @Override
    public DynamicObject createPolicy(Long orgid, Date startdate, Date enddate, Date lastStartDate, Date lastEndDate) {
        QFilter q1 = new QFilter("startdate", "=", (Object)lastStartDate);
        QFilter q2 = new QFilter("enddate", "=", (Object)lastEndDate);
        QFilter q3 = new QFilter("orgid", "=", (Object)orgid);
        QFilter draftpurposeFilter = new QFilter("draftpurpose", "=", (Object)"sjjt");
        DynamicObject policyId = QueryServiceHelper.queryOne((String)POLICY_ENTRY, (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, draftpurposeFilter});
        if (policyId == null) {
            return null;
        }
        InitSeasonalPolicyVo initSeasonalPolicyVo = SeasonalPolicyService.initSeasonalPolicy(orgid, startdate, enddate, "sjjt");
        if (!this.isFzjg(orgid, enddate) && !initSeasonalPolicyVo.getExistsPreviousDraft().booleanValue()) {
            return null;
        }
        DynamicObject dynamicObject = this.contractPolicy(initSeasonalPolicyVo, orgid, startdate, enddate);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return dynamicObject;
    }

    private DynamicObject contractPolicy(InitSeasonalPolicyVo initSeasonalPolicyVo, Long orgid, Date startdate, Date enddate) {
        boolean exists;
        boolean fzjg = this.isFzjg(orgid, enddate);
        DynamicObject policy = BusinessDataServiceHelper.newDynamicObject((String)POLICY_ENTRY);
        policy.set("orgid", (Object)orgid);
        policy.set("startdate", (Object)startdate);
        policy.set("enddate", (Object)enddate);
        policy.set("draftpurpose", (Object)"sjjt");
        policy.set("sospersonnum", (Object)(fzjg ? Integer.valueOf(0) : initSeasonalPolicyVo.getSospersonnum()));
        policy.set("eospersonnum", (Object)(fzjg ? Integer.valueOf(0) : initSeasonalPolicyVo.getEospersonnum()));
        policy.set("illegal", (Object)initSeasonalPolicyVo.getIllegal());
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid).getData();
        Long registerTypeId = taxMain != null ? taxMain.getLong("registertype.id") : 0L;
        String declareType = DeclareCompanyTypeService.getDeclareCompanyType(String.valueOf(orgid), DateUtils.format((Date)enddate));
        policy.set("illegal", (Object)initSeasonalPolicyVo.getIllegal());
        policy.set("registertype", (Object)registerTypeId);
        policy.set("residenttype", (Object)initSeasonalPolicyVo.getResidenttype());
        policy.set("declareType", (Object)declareType);
        String yjprofitslogic = (String)SystemParamUtil.getAppParameter((String)"tccit", (String)"yjprofitslogic", (long)orgid);
        policy.set("yjprofitslogic", (Object)yjprofitslogic);
        DynamicObjectCollection apitudeEntryEntity = policy.getDynamicObjectCollection(ENTRY);
        this.initAptitude(taxMain, apitudeEntryEntity, startdate, enddate);
        boolean bl = exists = !CollectionUtils.isEmpty((Collection)apitudeEntryEntity) && apitudeEntryEntity.stream().anyMatch(s -> "1".equals(s.getString("apitudetype")));
        if (exists) {
            policy.set("suittype", (Object)initSeasonalPolicyVo.getSuittype());
        }
        DynamicObjectCollection treeEntryEntity = policy.getDynamicObjectCollection(TREEENTRYENTITY);
        ArrayList orgidList = Lists.newArrayList((Object[])new Long[]{orgid});
        this.initTreeentryentity(orgid, declareType, treeEntryEntity, enddate);
        DynamicObjectCollection itemChoicEentity = policy.getDynamicObjectCollection(ITEMCHOICEENTITY);
        this.initItemchoiceentity(orgidList, itemChoicEentity);
        DynamicObjectCollection ruleEentity = policy.getDynamicObjectCollection(RULERNTRYENTITY);
        this.initRuleEntity(orgidList, ruleEentity);
        this.initfpbl(orgid, declareType, policy, startdate);
        List categoryCard = (List)TaxcMainDataServiceHelper.queryTaxcMainAndCategoryByOrgIdsAndTaxtype(Collections.singletonList(orgid), (String)TaxcMainConstant.TAXTYPE_QYSDS).getData();
        String levytype = CollectionUtils.isEmpty((Collection)categoryCard) ? "" : ((DynamicObject)((DynamicObject)categoryCard.get(0)).getDynamicObjectCollection("categoryentryentity").get(0)).getString("levytype");
        policy.set("levytype", (Object)levytype);
        DynamicObjectCollection branchAptitudeEntryEntity = policy.getDynamicObjectCollection(BRANCH_ENTRY);
        this.initBranchAptitude(POLICY_ENTRY, branchAptitudeEntryEntity, orgid, DateUtils.format((Date)startdate), DateUtils.format((Date)enddate), declareType, levytype);
        return policy;
    }

    @Override
    public DynamicObject createDraftMain(Long orgid, String templatetype, Date skssqq, Date skssqz) {
        List orgRelations = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(orgid), (Date)skssqq, (Date)skssqz);
        Long accountOrg = orgid;
        if (EmptyCheckUtils.isNotEmpty((Object)orgRelations)) {
            accountOrg = (Long)orgRelations.get(0);
        }
        StatusUtils.createStatus((String)"draft_qysdsjb", (String)String.valueOf(orgid), (String)DateUtils.format((Date)skssqq), (String)DateUtils.format((Date)skssqz), (String)"2", (String)"sjjt", (String)String.valueOf(accountOrg));
        return this.saveDraftNumber(orgid, skssqq, skssqz);
    }

    private DynamicObject saveDraftNumber(Long orgId, Date startDate, Date endDate) {
        String dgType = this.getDgType(orgId, endDate);
        DynamicObject billObject = this.queryDraftBillObject(orgId, startDate, endDate);
        if (EmptyCheckUtils.isNotEmpty((Object)billObject)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billObject.getLong("id"), (String)"tpo_declare_main_tsd");
            String billno = DeclareServiceHelper.generateSBBNo((String)"tctb_draft_main");
            dynamicObject.set("type", (Object)dgType.split("-")[1]);
            dynamicObject.set("billno", (Object)billno.replaceAll("X", "EITACCURE"));
            OperationServiceHelper.executeOperate((String)"save", (String)"tpo_declare_main_tsd", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
            AccrualMQSender.sendMQ((DynamicObject)dynamicObject);
        }
        return billObject;
    }

    public DynamicObject queryDraftBillObject(Long orgId, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter skssqqzFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        QFilter templatetype = new QFilter("templatetype", "=", (Object)"draft_qysdsjb");
        QFilter draftpurposeype = new QFilter("draftpurpose", "=", (Object)"sjjt");
        return QueryServiceHelper.queryOne((String)"tpo_declare_main_tsd", (String)"id,billno,billstatus,businessdocno", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, templatetype, draftpurposeype});
    }

    private String getDgType(Long orgId, Date endDate) {
        String billType = DeclareCompanyTypeService.getDgType(String.valueOf(orgId), DateUtils.format((Date)endDate), "seasonal");
        return "EITACCURE-" + billType;
    }

    private void initfpbl(Long orgid, String declareType, DynamicObject policy, Date startdate) {
        boolean contains = Sets.newHashSet((Object[])new String[]{"100", "220", "230"}).contains(declareType);
        if (!contains) {
            Date endyear;
            Date startyear = DateUtils.getFirstDateOfYear((Date)startdate);
            QFilter filter = QFilter.of((String)"org.id = ? and period >= ? and period <= ? and declaration = ? and participation = ?", (Object[])new Object[]{orgid, startyear, endyear = DateUtils.getLastDateOfYear((Date)startdate), "2", "1"});
            DynamicObject branchData = QueryServiceHelper.queryOne((String)"tccit_branch_share_bill", (String)"sharerate", (QFilter[])new QFilter[]{filter});
            if (null != branchData) {
                String sharerate = branchData.getString("sharerate");
                if (sharerate.contains("%")) {
                    sharerate = sharerate.substring(0, sharerate.indexOf("%"));
                }
                policy.set("zjgftbl", (Object)(StringUtil.isBlank((CharSequence)sharerate) ? BigDecimal.ZERO : new BigDecimal(sharerate)));
                policy.set("czjzfpbl", (Object)BigDecimal.ZERO);
                policy.set("qbfzjgftbl", (Object)new BigDecimal("1").subtract(StringUtil.isBlank((CharSequence)sharerate) ? BigDecimal.ZERO : new BigDecimal(sharerate)));
            } else {
                policy.set("zjgftbl", (Object)new BigDecimal("0.25"));
                policy.set("czjzfpbl", (Object)new BigDecimal("0.25"));
                policy.set("qbfzjgftbl", (Object)new BigDecimal("0.50"));
            }
        } else {
            policy.set("zjgftbl", (Object)BigDecimal.ZERO);
            policy.set("czjzfpbl", (Object)BigDecimal.ZERO);
            policy.set("qbfzjgftbl", (Object)BigDecimal.ZERO);
        }
    }

    private void initRuleEntity(List<Long> orgidList, DynamicObjectCollection ruleEentity) {
        HashMap ruleMap = new HashMap();
        orgidList.forEach(org -> ruleMap.putAll(RuleService.getAllSharingAndOrgRuleList(org, "sjjt", "czzs")));
        if (ruleMap.size() > 0) {
            for (Map.Entry typeEnumListEntry : ruleMap.entrySet()) {
                RuleTypeEnum ruleTypeEnum = (RuleTypeEnum)((Object)typeEnumListEntry.getKey());
                List ruleList = (List)typeEnumListEntry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)ruleList)) continue;
                for (DynamicObject rule : ruleList) {
                    DynamicObject addNew = ruleEentity.addNew();
                    addNew.set("itemtype", (Object)ruleTypeEnum.getName());
                    addNew.set("ruleid", (Object)rule.getLong("id"));
                }
            }
        }
    }

    private void initItemchoiceentity(List<Long> orgidList, DynamicObjectCollection itemChoicEentity) {
        ArrayList incomeRuleList = new ArrayList();
        orgidList.forEach(org -> incomeRuleList.addAll(RuleService.getSharingAndOrgRules(org, RuleTypeEnum.INCOME, "sjjt").get((Object)RuleTypeEnum.INCOME)));
        if (CollectionUtils.isNotEmpty(incomeRuleList)) {
            HashSet<Long> ids = new HashSet<Long>(incomeRuleList.size());
            for (DynamicObject rule : incomeRuleList) {
                DynamicObject item = rule.getDynamicObject("itemchoicename");
                if (null == item || ids.contains(item.getLong("id"))) continue;
                DynamicObject addNew = itemChoicEentity.addNew();
                Long itemchoiceid = item.getLong("id");
                ids.add(itemchoiceid);
                addNew.set("itemchoiceid", (Object)itemchoiceid);
                addNew.set("type", (Object)this.getType(item));
            }
        }
    }

    private String getType(DynamicObject item) {
        String number = item.getString("number");
        String type = "1";
        if (number.startsWith("MSSR")) {
            type = "1";
        } else if (number.startsWith("JJSR")) {
            type = "2";
        } else if (number.startsWith("SD") || number.startsWith("YJ-SDJM2021")) {
            type = "3";
        }
        return type;
    }

    private void initTreeentryentity(Long orgid, String declaretype, DynamicObjectCollection treeEntryEntity, Date endDate) {
        if ("210".equals(declaretype) || "220".equals(declaretype) || "230".equals(declaretype)) {
            QFilter orgFilter = new QFilter("orgrow.collectorg", "=", (Object)String.valueOf(orgid));
            QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
            QFilter statusFilter = new QFilter("status", "=", (Object)"2");
            DynamicObjectCollection objects = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.id,orgrow.pid,orgrow.orgid,orgrow.shareid as share,orgrow.declaration as declare,orgrow.kdqjyqylx as kdqjyqylx", (QFilter[])new QFilter[]{taxtypeFilter, orgFilter, statusFilter, OrgUtils.getQFilter((Date)endDate)});
            for (int i = 0; i < objects.size(); ++i) {
                DynamicObject addNew = treeEntryEntity.addNew();
                addNew.set("taxorg", (Object)((DynamicObject)objects.get(i)).getLong("orgrow.orgid"));
                addNew.set("declaration", (Object)((DynamicObject)objects.get(i)).getString("declare"));
                addNew.set("shareid", (Object)((DynamicObject)objects.get(i)).getString("share"));
                addNew.set("kdqjyqylx", (Object)((DynamicObject)objects.get(i)).getString("kdqjyqylx"));
            }
        }
    }

    private void initAptitude(DynamicObject dTctb, DynamicObjectCollection apitudeEntryEntity, Date startDate, Date endDate) {
        if (dTctb == null) {
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)POLICY_ENTRY);
        DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
        EntityType entityType = (EntityType)mainEntityType.getAllEntities().get(ENTRY);
        DataEntityPropertyCollection propertyCollection = entityType.getProperties();
        for (IDataEntityProperty property : mainPros) {
            if (!ENTRY.equals(property.getName())) continue;
            DynamicObjectCollection entryid = dTctb.getDynamicObjectCollection(ENTRY);
            for (DynamicObject d : entryid) {
                Date apitudestartdate = d.getDate("apitudestartdate");
                Date apitudeenddate = d.getDate("apitudeenddate");
                if (apitudestartdate.compareTo(endDate) > 0 || apitudeenddate != null && apitudeenddate.compareTo(startDate) < 0) continue;
                DynamicObject addNew = apitudeEntryEntity.addNew();
                for (IDataEntityProperty entityProperty : propertyCollection) {
                    if (entityProperty.getName().equals("id") || entityProperty.getName().equals("exporttype") || entityProperty.getName().equals("creditrating") || !d.getDynamicObjectType().getProperties().containsKey((Object)entityProperty.getName())) continue;
                    addNew.set(entityProperty.getName(), d.get(entityProperty.getName()));
                }
            }
        }
    }

    private void initBranchAptitude(String entity, DynamicObjectCollection branchAptitudeEntryEntity, Long orgid, String startDate, String endDate, String declareType, String levytype) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("draftpurpose", "sjjt");
        customParams.put("declaretype", declareType);
        customParams.put("levytype", levytype);
        customParams.put("billstatus", "A");
        if (!this.branchCalcPageService.checkBeforeCalcSplit(customParams)) {
            return;
        }
        List<DynamicObject> branchOrgObjList = this.apportionService.getBranchOrgList(orgid, startDate, endDate);
        if (CollectionUtils.isEmpty(branchOrgObjList)) {
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
        EntityType entityType = (EntityType)mainEntityType.getAllEntities().get(BRANCH_ENTRY);
        DataEntityPropertyCollection propertyCollection = entityType.getProperties();
        for (IDataEntityProperty property : mainPros) {
            if (!BRANCH_ENTRY.equals(property.getName())) continue;
            for (DynamicObject branchOrgObj : branchOrgObjList) {
                for (DynamicObject aptitude : branchOrgObj.getDynamicObjectCollection(ENTRY)) {
                    Date apitudestartdate = aptitude.getDate("apitudestartdate");
                    Date apitudeenddate = aptitude.getDate("apitudeenddate");
                    if (apitudestartdate.compareTo(DateUtils.stringToDate((String)endDate)) > 0 || apitudeenddate != null && apitudeenddate.compareTo(DateUtils.stringToDate((String)startDate)) < 0) continue;
                    DynamicObject branchAptitude = branchAptitudeEntryEntity.addNew();
                    for (IDataEntityProperty entityProperty : propertyCollection) {
                        if (entityProperty.getName().equals("id") || entityProperty.getName().equals("exporttype") || entityProperty.getName().equals("creditrating")) continue;
                        try {
                            branchAptitude.set(entityProperty.getName(), aptitude.get(entityProperty.getName().replace("branch", "")));
                        }
                        catch (Exception exception) {}
                    }
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                    dynamicObject.set("id", (Object)branchOrgObj.getLong("taxorg.org.id"));
                    branchAptitude.set("branchorgid", (Object)dynamicObject);
                }
            }
        }
    }

    private static List<QFilter> buildQFilters(Long orgid, Date skssqq, Date skssqz) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("templatetype", "=", (Object)"draft_qysdsjb"));
        list.add(new QFilter("skssqq", "=", (Object)skssqq));
        list.add(new QFilter("skssqz", "=", (Object)skssqz));
        list.add(new QFilter("org", "=", (Object)orgid));
        list.add(new QFilter("draftpurpose", "=", (Object)"sjjt"));
        return list;
    }
}

