/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.batch.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BooleanProp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.tccit.common.DeclareCompanyTypeUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.apitude.ApitudeService;
import kd.taxc.tccit.business.batch.IBatchDraftService;
import kd.taxc.tccit.business.batch.OrgHelperService;
import kd.taxc.tccit.business.draft.TypesProviderService;
import kd.taxc.tccit.business.pojo.DataResultVo;

public class HjBatchDraftService
implements IBatchDraftService {
    private static final String POLICY_ENTRY = "tccit_policy_confirm";
    private OrgHelperService orgHelperService = new OrgHelperService();

    @Override
    public DynamicObject createPolicy(Long orgid, Date startdate, Date enddate, Date lastStartDate, Date lastEndDate) {
        DynamicObject taxMain = this.orgHelperService.findTaxMain(orgid);
        if (taxMain == null) {
            return null;
        }
        DynamicObject currentPolicy = this.getPolicy(orgid, startdate, enddate);
        if (currentPolicy != null) {
            return currentPolicy;
        }
        DynamicObject policy = BusinessDataServiceHelper.newDynamicObject((String)POLICY_ENTRY);
        DataEntityPropertyCollection properties = policy.getDynamicObjectType().getProperties();
        DynamicObject lastPolicy = this.getPolicy(orgid, DateUtils.addYear((Date)startdate, (int)-1), DateUtils.addYear((Date)enddate, (int)-1));
        properties.stream().filter(s -> s instanceof BooleanProp).forEach(s -> policy.set(s.getName(), lastPolicy != null ? lastPolicy.get(s.getName()) : Boolean.TRUE));
        String declareType = this.getDeclareType(String.valueOf(orgid), DateUtils.format((Date)enddate));
        policy.set("orgid", (Object)orgid);
        policy.set("startdate", (Object)startdate);
        policy.set("enddate", (Object)enddate);
        policy.set("status", (Object)"1");
        policy.set("registertype", (Object)taxMain.getDynamicObject("registertype"));
        policy.set("accountingstandards", (Object)taxMain.getDynamicObject("accountingstandards"));
        policy.set("declaretype", (Object)declareType);
        policy.set("deductway", (Object)"");
        policy.set("codeandname", (Object)taxMain.getDynamicObject("codeandname"));
        policy.set("softtype", (Object)"110");
        policy.set("illegal", (Object)"false");
        policy.set("mbkstype", (Object)"100");
        policy.set("curryeardividendsum", (Object)BigDecimal.valueOf(0.0));
        if ("210".equals(declareType)) {
            if (lastPolicy != null && "210".equals(lastPolicy.getString("declaretype"))) {
                policy.set("zjgftbl", (Object)lastPolicy.getString("zjgftbl"));
                policy.set("czjzfpbl", (Object)lastPolicy.getString("czjzfpbl"));
                policy.set("fzjgftbl", (Object)lastPolicy.getString("fzjgftbl"));
            } else {
                policy.set("zjgftbl", (Object)BigDecimal.valueOf(0.25));
                policy.set("czjzfpbl", (Object)BigDecimal.valueOf(0.25));
                policy.set("fzjgftbl", (Object)BigDecimal.valueOf(0.5));
            }
        } else {
            policy.set("zjgftbl", (Object)BigDecimal.ZERO);
            policy.set("czjzfpbl", (Object)BigDecimal.ZERO);
            policy.set("fzjgftbl", (Object)BigDecimal.ZERO);
        }
        policy.set("registertype_id", taxMain.getDynamicObject("registertype").get("id"));
        policy.set("codeandname_id", taxMain.getDynamicObject("codeandname").get("id"));
        policy.set("accountingstandards_id", taxMain.getDynamicObject("accountingstandards").get("id"));
        DynamicObjectCollection policyApitudeentryentity = policy.getDynamicObjectCollection("apitudeentryentity");
        DynamicObjectCollection taxMainApitudeentryentity = taxMain.getDynamicObjectCollection("apitudeentryentity");
        if (taxMainApitudeentryentity != null) {
            taxMainApitudeentryentity.forEach(taxApitude -> {
                DynamicObject policyApitude = policyApitudeentryentity.addNew();
                policyApitude.set("apitudetype", taxApitude.get("apitudetype"));
                policyApitude.set("companytype", taxApitude.get("companytype"));
                policyApitude.set("profitmyear", taxApitude.get("profitmyear"));
                policyApitude.set("profittype", taxApitude.get("profittype"));
                policyApitude.set("apitudestartdate", taxApitude.get("apitudestartdate"));
                policyApitude.set("apitudeenddate", taxApitude.get("apitudeenddate"));
                policyApitude.set("yxsy", taxApitude.get("yxsy"));
            });
        }
        DynamicObjectCollection gdentryentity = policy.getDynamicObjectCollection("gdentryentity");
        List<DynamicObject> collects = this.getShareHolderEntryEntity(orgid);
        BigDecimal suminvestrate = collects.stream().map(s -> s.getBigDecimal("investrate")).reduce(BigDecimal.ZERO, BigDecimal::add);
        Boolean less100 = suminvestrate.compareTo(new BigDecimal("100")) < 0;
        for (DynamicObject object : collects) {
            DynamicObject item = gdentryentity.addNew();
            item.set("gdname", (Object)object.getString("name"));
            item.set("fidtype", (Object)object.getString("fidtype"));
            item.set("idnumber", (Object)object.getString("idnumber"));
            item.set("investrate", (Object)object.getBigDecimal("investrate"));
            item.set("nationality", (Object)object.getDynamicObject("nationality"));
        }
        if (less100.booleanValue()) {
            DynamicObject item = gdentryentity.addNew();
            item.set("gdname", (Object)ResManager.loadKDString((String)"\u5176\u4f59\u80a1\u4e1c\u5408\u8ba1", (String)"HjBatchDraftService_0", (String)"taxc-tccit", (Object[])new Object[0]));
            item.set("fidtype", (Object)"count");
            item.set("idnumber", (Object)"");
            item.set("investrate", (Object)new BigDecimal("100").subtract(suminvestrate));
            item.set("nationality", (Object)0L);
        }
        DynamicObjectCollection treeentryentity = policy.getDynamicObjectCollection("treeentryentity");
        DynamicObjectCollection objects = this.getTreeentryentity(String.valueOf(orgid), DateUtils.format((Date)enddate), declareType);
        if (objects != null) {
            long[] pks = DBServiceHelper.genLongIds((String)"tccit_policy_confirm.treeentryentity", (int)objects.size());
            HashMap<Long, Integer> map = new HashMap<Long, Integer>(pks.length);
            for (int i = 0; i < pks.length; ++i) {
                map.put(((DynamicObject)objects.get(i)).getLong("orgrow.id"), i);
                DynamicObject object = treeentryentity.addNew();
                object.set("taxorg", (Object)((DynamicObject)objects.get(i)).getLong("orgrow.orgid"));
                object.set("declaration", (Object)((DynamicObject)objects.get(i)).getString("declare"));
                object.set("shareid", (Object)((DynamicObject)objects.get(i)).getString("share"));
                object.set("kdqjyqylx", (Object)((DynamicObject)objects.get(i)).getString("kdqjyqylx"));
                Integer a = (Integer)map.get(((DynamicObject)objects.get(i)).getLong("orgrow.pid"));
                object.set("pid", a == null ? null : Long.valueOf(pks[a]));
                object.set("id", (Object)pks[i]);
            }
        }
        DynamicObjectCollection entryentity = policy.getDynamicObjectCollection("entryentity");
        List<DynamicObject> declare = this.getDeclareSbbId(policy);
        if (declare != null) {
            declare.forEach(s -> {
                DynamicObject object = entryentity.addNew();
                object.set("declareid", (Object)s.getLong("id"));
            });
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{policy});
        return policy;
    }

    private DynamicObject getPolicy(Long orgid, Date startdate, Date enddate) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter startFilter = new QFilter("startdate", ">=", (Object)startdate);
        QFilter endFilter = new QFilter("startdate", "<=", (Object)enddate);
        DynamicObject policy = QueryServiceHelper.queryOne((String)POLICY_ENTRY, (String)"id", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
        return Optional.ofNullable(policy).map(s -> BusinessDataServiceHelper.loadSingle((Object)s.getLong("id"), (String)POLICY_ENTRY)).orElse(null);
    }

    @Override
    public DynamicObject createDraftMain(Long orgid, String templatetype, Date skssqq, Date skssqz) {
        DynamicObject object = StatusUtils.createStatus((String)"draft_qysdsnb", (String)String.valueOf(orgid), (String)DateUtils.format((Date)skssqq), (String)DateUtils.format((Date)skssqz), (String)"5", (String)"nssb", null);
        if (object != null) {
            String billType = DeclareCompanyTypeUtils.getDgType((String)String.valueOf(orgid), (String)DateUtils.format((Date)skssqz), (String)"year");
            object.set("billno", (Object)object.getString("billno").replace("X", "CIT-" + billType));
            object.set("type", (Object)billType);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            this.sendDraftSaveMQ(object, object.getDate("startdate"), object.getDate("enddate"));
            return object;
        }
        return null;
    }

    @Override
    public DataResultVo isExistLastData(Long orgid, Date startDate, Date endDate, Date lastStartDate, Date lastEndDate) {
        return DataResultVo.ok();
    }

    @Override
    public Boolean draftIsExists(Long orgid, String templatetype, Date startdate, Date enddate) {
        DynamicObject object = StatusUtils.queryOne((String)templatetype, (String)String.valueOf(orgid), (String)DateUtils.format((Date)startdate), (String)DateUtils.format((Date)enddate), (String)"nssb");
        return object != null;
    }

    private DynamicObjectCollection getTreeentryentity(String orgid, String endDate, String declaretype) {
        Date date1 = DateUtils.stringToDate((String)endDate);
        if ("210".equals(declaretype) || "220".equals(declaretype) || "230".equals(declaretype)) {
            QFilter orgFilter = new QFilter("orgrow.collectorg", "=", (Object)orgid);
            QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
            QFilter statusFilter = new QFilter("status", "=", (Object)"2");
            QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
            DynamicObjectCollection objects = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.id,orgrow.pid,orgrow.orgid,orgrow.shareid as share,orgrow.declaration as declare,orgrow.kdqjyqylx as kdqjyqylx", (QFilter[])new QFilter[]{taxtypeFilter, orgFilter, statusFilter, billstatusFilter, OrgUtils.getQFilter((Date)date1)}, (String)"orgrow.seq asc");
            return objects;
        }
        return null;
    }

    private String getDeclareType(String orgid, String endDate) {
        Date date1 = DateUtils.stringToDate((String)endDate);
        QFilter orgFilter = new QFilter("orgrow.orgid", "=", (Object)Long.valueOf(orgid));
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.id,orgrow.pid,orgrow.orgid,orgrow.shareid as share,orgrow.declaration as declare,orgrow.kdqjyqylx as kdqjyqylx", (QFilter[])new QFilter[]{taxtypeFilter, orgFilter, statusFilter, billstatusFilter, OrgUtils.getQFilter((Date)date1)});
        if (!CollectionUtils.isEmpty((Collection)objects)) {
            DynamicObject dynamicObject = (DynamicObject)objects.get(0);
            String kdqjyqylx = dynamicObject.getString("kdqjyqylx");
            return kdqjyqylx;
        }
        return "100";
    }

    private List<DynamicObject> getShareHolderEntryEntity(Long orgid) {
        DynamicObjectCollection shareHolderEntry = ApitudeService.getShareHolderEntry(orgid);
        shareHolderEntry.sort(Comparator.comparing(d -> d.getBigDecimal("investrate")).reversed());
        if (CollectionUtils.isEmpty((Collection)shareHolderEntry)) {
            return new ArrayList<DynamicObject>();
        }
        List<DynamicObject> collects = shareHolderEntry.stream().limit(10L).collect(Collectors.toList());
        return collects;
    }

    private List<DynamicObject> getDeclareSbbId(DynamicObject policy) {
        DynamicObjectCollection deList = TypesProviderService.getTypes(policy, null, "sbb", "number");
        if (!deList.isEmpty()) {
            List<DynamicObject> collect = deList.stream().filter(s -> s.getLong("id") != 22000001L && s.getLong("id") != 22000002L).collect(Collectors.toList());
            return collect;
        }
        return null;
    }
}

