/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.batch.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.tccit.business.batch.IBatchDraftService;
import kd.taxc.tccit.business.declare.DeclareCompanyTypeService;
import kd.taxc.tccit.business.pojo.DataResultVo;
import kd.taxc.tccit.business.pojo.InitSeasonalPolicyVo;
import kd.taxc.tccit.business.policy.SeasonalPolicyService;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class YjBatchDraftService
implements IBatchDraftService {
    private static Log LOGGER = LogFactory.getLog(YjBatchDraftService.class);
    private static final String ENTRY = "apitudeentryentity";
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String ITEMCHOICEENTITY = "itemchoiceentity";
    private static final String RULERNTRYENTITY = "ruleentryentity";
    private static final String POLICY_ENTRY = "tccit_seasonal_policy";
    private static final String TCTB_DRAFT_MAIN = "tctb_draft_main";

    @Override
    public DataResultVo isExistLastData(Long orgid, Date startDate, Date endDate, Date lastStartDate, Date lastEndDate) {
        List<QFilter> qFilters = YjBatchDraftService.buildQFilters(orgid, startDate, endDate);
        boolean exists = QueryServiceHelper.exists((String)TCTB_DRAFT_MAIN, (QFilter[])qFilters.toArray(new QFilter[0]));
        if (exists) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u5e95\u7a3f\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u518d\u6b21\u751f\u6210", (String)"YjBatchDraftService_0", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        if (this.isFzjg(orgid, endDate)) {
            return DataResultVo.ok();
        }
        return DataResultVo.ok();
    }

    @Override
    public Boolean draftIsExists(Long orgid, String templatetype, Date startdate, Date enddate) {
        return null;
    }

    private boolean isFzjg(Long orgid, Date endDate) {
        return QueryServiceHelper.exists((String)"tctb_org_group_latest", (QFilter[])new QFilter[]{new QFilter("orgrow.orgid", "=", (Object)orgid), new QFilter("orgrow.declaration", "=", (Object)"3"), new QFilter("taxtype", "=", (Object)"qysds"), new QFilter("status", "=", (Object)"2"), new QFilter("billstatus", "=", (Object)"C"), OrgUtils.getQFilter((Date)endDate)});
    }

    @Override
    public DataResultVo createPolicyNew(Long orgid, Date startdate, Date enddate, Date lastStartDate, Date lastEndDate) {
        DynamicObject lastPolicy = SeasonalPolicyService.getPolicy(orgid, lastStartDate, lastEndDate, "nssb");
        String declareType = this.initDeclareCompanyType(orgid, enddate);
        InitSeasonalPolicyVo initSeasonalPolicyVo = SeasonalPolicyService.initSeasonalPolicy(orgid, startdate, enddate, "nssb");
        if (!initSeasonalPolicyVo.getExistsPreviousDraft().booleanValue() || initSeasonalPolicyVo.getSospersonnum() == 0 || initSeasonalPolicyVo.getEospersonnum() == 0) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u4e0a\u671f\u9884\u7f34\u7533\u62a5\u4ece\u4e1a\u4eba\u6570\u4fe1\u606f\uff0c\u65e0\u6cd5\u751f\u6210\u9884\u7f34\u7533\u62a5\u5e95\u7a3f", (String)"YjBatchDraftService_2", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        DynamicObject dynamicObject = this.contractPolicy(initSeasonalPolicyVo, orgid, startdate, enddate, lastPolicy, declareType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return DataResultVo.success("ok", dynamicObject);
    }

    public DynamicObject contractPolicy(InitSeasonalPolicyVo initSeasonalPolicyVo, long orgid, Date startdate, Date enddate, DynamicObject lastPolicy, String declareType) {
        boolean exists;
        DynamicObject policy = BusinessDataServiceHelper.newDynamicObject((String)POLICY_ENTRY);
        policy.set("orgid", (Object)orgid);
        policy.set("startdate", (Object)startdate);
        policy.set("enddate", (Object)enddate);
        policy.set("draftpurpose", (Object)"nssb");
        policy.set("sospersonnum", (Object)initSeasonalPolicyVo.getSospersonnum());
        policy.set("eospersonnum", (Object)initSeasonalPolicyVo.getEospersonnum());
        policy.set("illegal", (Object)initSeasonalPolicyVo.getIllegal());
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid).getData();
        Long registerTypeId = taxMain != null ? taxMain.getLong("registertype.id") : 0L;
        policy.set("registertype", (Object)registerTypeId);
        policy.set("declareType", (Object)declareType);
        policy.set("levytype", (Object)initSeasonalPolicyVo.getLevytype());
        policy.set("residenttype", (Object)initSeasonalPolicyVo.getResidenttype());
        policy.set("checkcollectway", (Object)initSeasonalPolicyVo.getCheckcollectway());
        policy.set("taxableincomerate", (Object)initSeasonalPolicyVo.getTaxableincomerate());
        String yjprofitslogic = (String)SystemParamUtil.getAppParameter((String)"tccit", (String)"yjprofitslogic", (long)orgid);
        policy.set("yjprofitslogic", (Object)yjprofitslogic);
        DynamicObjectCollection apitudeEntryEntity = policy.getDynamicObjectCollection(ENTRY);
        this.initAptitude(taxMain, apitudeEntryEntity, startdate, enddate);
        boolean bl = exists = !CollectionUtils.isEmpty((Collection)apitudeEntryEntity) && apitudeEntryEntity.stream().anyMatch(s -> "1".equals(s.getString("apitudetype")));
        if (exists) {
            policy.set("suittype", (Object)initSeasonalPolicyVo.getSuittype());
        }
        DynamicObjectCollection treeEntryEntity = policy.getDynamicObjectCollection(TREEENTRYENTITY);
        ArrayList orgidList = Lists.newArrayList((Object[])new Long[]{orgid});
        this.initTreeentryentity(orgid, declareType, treeEntryEntity, enddate);
        DynamicObjectCollection itemChoicEentity = policy.getDynamicObjectCollection(ITEMCHOICEENTITY);
        this.initItemchoiceentity(orgidList, itemChoicEentity);
        DynamicObjectCollection ruleEentity = policy.getDynamicObjectCollection(RULERNTRYENTITY);
        this.initRuleEntity(orgidList, ruleEentity);
        this.initfpbl(declareType, policy, lastPolicy);
        return policy;
    }

    @Override
    public DynamicObject createDraftMain(Long orgid, String templatetype, Date skssqq, Date skssqz) {
        StatusUtils.createStatus((String)"draft_qysdsjb", (String)String.valueOf(orgid), (String)DateUtils.format((Date)skssqq), (String)DateUtils.format((Date)skssqz), (String)"2", (String)"nssb", (String)"");
        return this.saveDraftNumber(orgid, skssqq, skssqz);
    }

    private DynamicObject saveDraftNumber(Long orgId, Date startDate, Date endDate) {
        String dgType = this.getDgType(orgId, endDate);
        DynamicObject billObject = this.queryDraftBillObject(orgId, startDate, endDate);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCTB_DRAFT_MAIN);
        String readNumber = DeclareServiceHelper.generateSBBNo((String)TCTB_DRAFT_MAIN, (DynamicObject)dynamicObject, (String)String.valueOf(orgId));
        readNumber = readNumber.replaceAll("X", dgType);
        if (billObject == null) {
            dynamicObject.set("billstatus", (Object)"A");
            dynamicObject.set("startdate", (Object)startDate);
            dynamicObject.set("enddate", (Object)endDate);
            dynamicObject.set("org", (Object)orgId);
            dynamicObject.set("templatetype", (Object)"draft_qysdsjb");
            dynamicObject.set("billno", (Object)readNumber);
            dynamicObject.set("draftpurpose", (Object)"nssb");
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billObject.getLong("id"), (String)TCTB_DRAFT_MAIN);
        }
        dynamicObject.set("type", (Object)dgType.split("-")[1]);
        dynamicObject.set("billno", (Object)readNumber);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)TCTB_DRAFT_MAIN, (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
        this.sendDraftSaveMQ(dynamicObject, startDate, endDate);
        return dynamicObject;
    }

    private DynamicObject queryDraftBillObject(Long orgId, Date startdate, Date enddate) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)startdate).and(new QFilter("enddate", "=", (Object)enddate));
        QFilter templatetype = new QFilter("templatetype", "=", (Object)"draft_qysdsjb");
        QFilter draftpurposeype = new QFilter("draftpurpose", "=", (Object)"nssb");
        return QueryServiceHelper.queryOne((String)TCTB_DRAFT_MAIN, (String)"id,billno,billstatus,jtnumber", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, templatetype, draftpurposeype});
    }

    private String getDgType(Long orgId, Date endDate) {
        String billType = DeclareCompanyTypeService.getDgType(String.valueOf(orgId), DateUtils.format((Date)endDate), "seasonal");
        return "CIT-" + billType;
    }

    private void initfpbl(String declareType, DynamicObject policy, DynamicObject lastPolicy) {
        if ("210".equals(declareType)) {
            if (lastPolicy != null && "210".equals(lastPolicy.getString("declaretype"))) {
                policy.set("zjgftbl", (Object)lastPolicy.getBigDecimal("zjgftbl"));
                policy.set("czjzfpbl", (Object)lastPolicy.getBigDecimal("czjzfpbl"));
                policy.set("qbfzjgftbl", (Object)lastPolicy.getBigDecimal("qbfzjgftbl"));
            } else {
                policy.set("zjgftbl", (Object)new BigDecimal("0.25"));
                policy.set("czjzfpbl", (Object)new BigDecimal("0.25"));
                policy.set("qbfzjgftbl", (Object)new BigDecimal("0.50"));
            }
        } else {
            policy.set("zjgftbl", (Object)BigDecimal.ZERO);
            policy.set("czjzfpbl", (Object)BigDecimal.ZERO);
            policy.set("qbfzjgftbl", (Object)BigDecimal.ZERO);
        }
    }

    private void initRuleEntity(List<Long> orgidList, DynamicObjectCollection ruleEentity) {
        HashMap ruleMap = new HashMap();
        orgidList.forEach(org -> ruleMap.putAll(RuleService.getAllSharingAndOrgRuleList(org, "nssb", "czzs")));
        if (ruleMap.size() > 0) {
            for (Map.Entry typeEnumListEntry : ruleMap.entrySet()) {
                RuleTypeEnum ruleTypeEnum = (RuleTypeEnum)((Object)typeEnumListEntry.getKey());
                List ruleList = (List)typeEnumListEntry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)ruleList)) continue;
                for (DynamicObject rule : ruleList) {
                    DynamicObject addNew = ruleEentity.addNew();
                    addNew.set("itemtype", (Object)ruleTypeEnum.getName());
                    addNew.set("ruleid", (Object)rule.getLong("id"));
                }
            }
        }
    }

    private void initItemchoiceentity(List<Long> orgidList, DynamicObjectCollection itemChoicEentity) {
        ArrayList incomeRuleList = new ArrayList();
        orgidList.forEach(org -> incomeRuleList.addAll(RuleService.getSharingAndOrgRules(org, RuleTypeEnum.INCOME, "nssb").get((Object)RuleTypeEnum.INCOME)));
        if (CollectionUtils.isNotEmpty(incomeRuleList)) {
            HashSet<Long> ids = new HashSet<Long>(incomeRuleList.size());
            for (DynamicObject rule : incomeRuleList) {
                DynamicObject item = rule.getDynamicObject("itemchoicename");
                if (null == item || ids.contains(item.getLong("id"))) continue;
                DynamicObject addNew = itemChoicEentity.addNew();
                Long itemchoiceid = item.getLong("id");
                ids.add(itemchoiceid);
                addNew.set("itemchoiceid", (Object)itemchoiceid);
                addNew.set("type", (Object)this.getType(item));
            }
        }
    }

    private String getType(DynamicObject item) {
        String number = item.getString("number");
        String type = "1";
        if (number.startsWith("MSSR")) {
            type = "1";
        } else if (number.startsWith("JJSR")) {
            type = "2";
        } else if (number.startsWith("SD") || number.startsWith("YJ-SDJM2021")) {
            type = "3";
        }
        return type;
    }

    private void initTreeentryentity(Long orgid, String declaretype, DynamicObjectCollection treeEntryEntity, Date endDate) {
        if ("210".equals(declaretype) || "220".equals(declaretype) || "230".equals(declaretype)) {
            QFilter orgFilter = new QFilter("orgrow.collectorg", "=", (Object)String.valueOf(orgid));
            QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
            QFilter statusFilter = new QFilter("status", "=", (Object)"2");
            QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
            DynamicObjectCollection objects = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.id,orgrow.pid,orgrow.orgid,orgrow.shareid as share,orgrow.declaration as declare,orgrow.kdqjyqylx as kdqjyqylx", (QFilter[])new QFilter[]{taxtypeFilter, orgFilter, statusFilter, billstatusFilter, OrgUtils.getQFilter((Date)endDate)}, (String)"orgrow.seq asc");
            long[] pks = DBServiceHelper.genLongIds((String)"tccit_seasonal_policy.treeentryentity", (int)objects.size());
            HashMap<Long, Integer> map = new HashMap<Long, Integer>(pks.length);
            for (int i = 0; i < pks.length; ++i) {
                map.put(((DynamicObject)objects.get(i)).getLong("orgrow.id"), i);
                DynamicObject object = treeEntryEntity.addNew();
                object.set("taxorg", (Object)((DynamicObject)objects.get(i)).getLong("orgrow.orgid"));
                object.set("declaration", (Object)((DynamicObject)objects.get(i)).getString("declare"));
                object.set("shareid", (Object)((DynamicObject)objects.get(i)).getString("share"));
                object.set("kdqjyqylx", (Object)((DynamicObject)objects.get(i)).getString("kdqjyqylx"));
                Integer a = (Integer)map.get(((DynamicObject)objects.get(i)).getLong("orgrow.pid"));
                object.set("pid", a == null ? null : Long.valueOf(pks[a]));
                object.set("id", (Object)pks[i]);
            }
        }
    }

    private void initAptitude(DynamicObject taxMain, DynamicObjectCollection apitudeEntryEntity, Date startDate, Date endDate) {
        if (taxMain != null) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)POLICY_ENTRY);
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            EntityType entityType = (EntityType)mainEntityType.getAllEntities().get(ENTRY);
            DataEntityPropertyCollection propertyCollection = entityType.getProperties();
            for (IDataEntityProperty property : mainPros) {
                if (!ENTRY.equals(property.getName())) continue;
                DynamicObjectCollection entryid = taxMain.getDynamicObjectCollection(ENTRY);
                for (DynamicObject d : entryid) {
                    Date apitudestartdate = d.getDate("apitudestartdate");
                    Date apitudeenddate = d.getDate("apitudeenddate");
                    if (apitudestartdate.compareTo(endDate) > 0 || apitudeenddate != null && apitudeenddate.compareTo(startDate) < 0) continue;
                    DynamicObject addNew = apitudeEntryEntity.addNew();
                    for (IDataEntityProperty entityProperty : propertyCollection) {
                        if (entityProperty.getName().equals("id") || entityProperty.getName().equals("exporttype") || entityProperty.getName().equals("creditrating") || !d.getDynamicObjectType().getProperties().containsKey((Object)entityProperty.getName())) continue;
                        addNew.set(entityProperty.getName(), d.get(entityProperty.getName()));
                    }
                }
            }
        }
    }

    public String initDeclareCompanyType(Long orgid, Date endDate) {
        QFilter orgFilter = new QFilter("orgrow.orgid", "=", (Object)orgid);
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.id,orgrow.pid,orgrow.orgid,orgrow.shareid as share,orgrow.declaration as declare,orgrow.kdqjyqylx as kdqjyqylx", (QFilter[])new QFilter[]{taxtypeFilter, orgFilter, statusFilter, billstatusFilter, OrgUtils.getQFilter((Date)endDate)});
        if (CollectionUtils.isNotEmpty((Collection)objects)) {
            DynamicObject dynamicObject = (DynamicObject)objects.get(0);
            return dynamicObject.getString("kdqjyqylx");
        }
        return "100";
    }

    private static List<QFilter> buildQFilters(Long orgid, Date startdate, Date enddate) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("templatetype", "=", (Object)"draft_qysdsjb"));
        list.add(new QFilter("startdate", "=", (Object)startdate));
        list.add(new QFilter("enddate", "=", (Object)enddate));
        list.add(new QFilter("org", "=", (Object)orgid));
        list.add(new QFilter("draftpurpose", "=", (Object)"nssb"));
        return list;
    }
}

