/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.batch.impl.handler;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.batch.IBatchHandler;
import kd.taxc.tccit.business.batch.OrgHelperService;
import kd.taxc.tccit.business.batch.ParamsCheckService;
import kd.taxc.tccit.business.batch.impl.BatchAccrualService;
import kd.taxc.tccit.business.declare.DeclareCompanyTypeService;
import kd.taxc.tccit.business.draft.DraftMainService;
import kd.taxc.tccit.business.engine.refactoring.handler.SeasonalDraftEngineHandler;
import kd.taxc.tccit.business.pojo.DataResultVo;
import kd.taxc.tccit.business.pojo.DateRangeVo;
import kd.taxc.tccit.business.policy.SeasonalPolicyService;
import kd.taxc.tccit.common.utils.DateRangeUtils;
import kd.taxc.tccit.formplugin.seasonal.SeasonalCalcPagePlugin;

public class AccrualHandlerService
implements IBatchHandler {
    private static ParamsCheckService paramsCheckService = new ParamsCheckService();
    private static BatchAccrualService batchAccrualService = new BatchAccrualService();
    private static OrgHelperService orgHelperService = new OrgHelperService();
    private DateRangeVo dateRangeVo = new DateRangeVo();

    @Override
    public DataResultVo checkBeforeRun(String orgId, String category, String batchType) {
        return paramsCheckService.check(orgId, category, batchType);
    }

    @Override
    public DataResultVo initDateAndType(String orgId, Date skssqq, Date skssqz, Date executeTime) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("orgid", orgId);
        DynamicObject taxMain = orgHelperService.findTaxMain(Long.parseLong(orgId));
        if (taxMain == null) {
            return DataResultVo.fail(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u8868\u4e2d\u4e0d\u5b58\u5728\u8be5orgid\uff1a%s", (String)"AccrualHandlerService_0", (String)"taxc-tccit", (Object[])new Object[0]), orgId), result);
        }
        DynamicObject taxInfos = orgHelperService.findTaxInfos(taxMain, "qysds");
        if (taxInfos == null) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6240\u5f97\u7a0e\u7a0e\u79cd\u5361\u7247", (String)"AccrualHandlerService_1", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange((List)Lists.newArrayList((Object[])new Long[]{Long.parseLong(orgId)}), (Long)BaseTaxCategory.QYSDS, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)DateUtils.addMonth((Date)executeTime, (int)-1), (Date)DateUtils.addMonth((Date)executeTime, (int)-1)).getData();
        if (dynamicObjectCollection.size() == 0 || ((DynamicObject)dynamicObjectCollection.get(0)).getString("ruleentity.rule.enable").equals("0")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u7a0e\u91d1\u8ba1\u63d0\u8bbe\u7f6e\u201d\u7ef4\u62a4\u201c\u8ba1\u63d0\u65b9\u6848\u201d\u53ca\u5176\u201c\u5171\u4eab\u65b9\u6848\u201d\u3002", (String)"AccrualHandlerService_2", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        String cycle = ((DynamicObject)dynamicObjectCollection.get(0)).getString("ruleentity.rule.cycle");
        this.dateRangeVo = DateRangeUtils.initStartAndEndDate(cycle, executeTime);
        if (!DateUtils.format((Date)skssqq).equals(DateUtils.format((Date)this.dateRangeVo.getStartDate())) || !DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)this.dateRangeVo.getEndDate()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u63d0\u65b9\u6848\u5bf9\u5e94\u7684\u8ba1\u63d0\u5468\u671f\u4e0e\u8ba1\u63d0\u5c5e\u671f\u4e0d\u7b26\uff0c\u65e0\u6cd5\u751f\u6210\u8ba1\u63d0\u5e95\u7a3f", (String)"AccrualHandlerService_3", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        String declaretype = DeclareCompanyTypeService.getDeclareCompanyType(orgId, DateUtils.format((Date)this.dateRangeVo.getEndDate()));
        Boolean isFz = declaretype.equals("311") || declaretype.equals("312");
        if (isFz.booleanValue()) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u7f16\u5236\u5e95\u7a3f\u3002", (String)"AccrualHandlerService_4", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        result.put("skssqq", DateUtils.format((Date)this.dateRangeVo.getStartDate()));
        result.put("skssqz", DateUtils.format((Date)this.dateRangeVo.getEndDate()));
        Boolean islevel3 = orgHelperService.isFzGroup(orgId, DateUtils.format((Date)this.dateRangeVo.getStartDate()), DateUtils.format((Date)this.dateRangeVo.getEndDate()));
        if (islevel3.booleanValue()) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e3a\u4e09\u7ea7\u5206\u652f\u673a\u6784\u65e0\u9700\u751f\u6210\u4f01\u4e1a\u6240\u5f97\u7a0e\u9884\u7f34\u7533\u62a5\u5e95\u7a3f\u6570\u636e", (String)"AccrualHandlerService_5", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        DataResultVo hasIntersection = DraftMainService.hasIntersection(orgId, DateUtils.format((Date)this.dateRangeVo.getStartDate()), DateUtils.format((Date)this.dateRangeVo.getEndDate()), "sjjt");
        if (!hasIntersection.getSuccess().booleanValue()) {
            return DataResultVo.fail(hasIntersection.getMessage());
        }
        TaxableListDto taxableListDto = new TaxableListDto();
        taxableListDto.setSkssqq(this.dateRangeVo.getStartDate());
        taxableListDto.setSkssqz(this.dateRangeVo.getEndDate());
        taxableListDto.setOrg(Long.valueOf(Long.parseLong(orgId)));
        return DataResultVo.success("success", taxableListDto);
    }

    @Override
    public DataResultVo initData(String orgId, Date startdate, Date enddate, Date executeTime) {
        DataResultVo dataResultVo = this.initDateAndType(orgId, startdate, enddate, executeTime);
        if (!dataResultVo.getSuccess().booleanValue()) {
            return dataResultVo;
        }
        TaxableListDto taxableListDto = (TaxableListDto)dataResultVo.getData();
        if (taxableListDto == null) {
            return DataResultVo.fail("initDateAndType not get data");
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("orgid", orgId);
        result.put("skssqq", DateUtils.format((Date)this.dateRangeVo.getStartDate()));
        result.put("skssqz", DateUtils.format((Date)this.dateRangeVo.getEndDate()));
        List orgRelations = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(Long.parseLong(orgId)), (Date)startdate, (Date)enddate);
        if (EmptyCheckUtils.isEmpty((Object)orgRelations) || ((Long)orgRelations.get(0)).equals(0L)) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6838\u7b97\u7ec4\u7ec7", (String)"AccrualHandlerService_6", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        DataResultVo existLastData = batchAccrualService.isExistLastData(Long.parseLong(orgId), this.dateRangeVo.getStartDate(), this.dateRangeVo.getEndDate(), this.dateRangeVo.getLastStartDate(), this.dateRangeVo.getLastEndDate());
        if (!existLastData.getSuccess().booleanValue()) {
            existLastData.setData(result);
            return existLastData;
        }
        DataResultVo resultVo = batchAccrualService.createPolicyNew(Long.parseLong(orgId), this.dateRangeVo.getStartDate(), this.dateRangeVo.getEndDate(), this.dateRangeVo.getLastStartDate(), this.dateRangeVo.getLastEndDate());
        if (!resultVo.getSuccess().booleanValue()) {
            return resultVo;
        }
        result.put("policy", resultVo.getData());
        batchAccrualService.createDraftMain(Long.parseLong(orgId), "", this.dateRangeVo.getStartDate(), this.dateRangeVo.getEndDate());
        return DataResultVo.success(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u8ba1\u63d0\u5e95\u7a3f\u653f\u7b56\u8fd0\u7ef4\u6570\u636e\u521b\u5efa\u6210\u529f", (String)"AccrualHandlerService_8", (String)"taxc-tccit", (Object[])new Object[0]), result);
    }

    @Override
    public void runTask(EngineModel engineModel) {
        try (TXHandle h = TX.required();){
            try {
                new SeasonalDraftEngineHandler().run(engineModel);
                HashMap<String, Object> customParams = new HashMap<String, Object>(16);
                customParams.put("orgid", String.valueOf(engineModel.getOrgId()));
                customParams.put("skssqq", engineModel.getStartDate());
                customParams.put("skssqz", engineModel.getEndDate());
                customParams.put("draftpurpose", "sjjt");
                new SeasonalCalcPagePlugin().calcSummery(customParams);
                DynamicObject policyObject = SeasonalPolicyService.getPolicy(Long.valueOf(engineModel.getOrgId()), DateUtils.stringToDate2((String)engineModel.getStartDate()), DateUtils.stringToDate2((String)engineModel.getEndDate()), "sjjt");
                customParams.put("declaretype", policyObject.getString("declaretype"));
                customParams.put("levytype", policyObject.getString("levytype"));
                customParams.put("billstatus", "A");
                DynamicObject draftQueryObject = batchAccrualService.queryDraftBillObject(Long.valueOf(engineModel.getOrgId()), DateUtils.stringToDate2((String)engineModel.getStartDate()), DateUtils.stringToDate2((String)engineModel.getEndDate()));
                customParams.put("draftnumber", draftQueryObject.getString("billno"));
                new SeasonalCalcPagePlugin().calcTaxAmountSplitPage(customParams, true);
                StatusUtils.updateStatus((String)"draft_qysdsjb", (String)engineModel.getOrgId(), (String)engineModel.getStartDate(), (String)engineModel.getEndDate(), (String)"3", (String)"sjjt");
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
    }
}

