/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.batch.impl.handler;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.batch.DeclareHelperService;
import kd.taxc.tccit.business.batch.IBatchDeclareService;
import kd.taxc.tccit.business.batch.IBatchHandler;
import kd.taxc.tccit.business.batch.OrgHelperService;
import kd.taxc.tccit.business.batch.ParamsCheckService;
import kd.taxc.tccit.business.batch.impl.HjBatchDeclareService;
import kd.taxc.tccit.business.pojo.DataResultVo;

public class HjDeclareHandlerService
implements IBatchHandler {
    private static final String TAX_TYPE = "qysds";
    private static final String CATEGORY = "qysdsnb";
    private static ParamsCheckService paramsCheckService = new ParamsCheckService();
    private static IBatchDeclareService hjBatchDeclareService = new HjBatchDeclareService();
    private static OrgHelperService orgHelperService = new OrgHelperService();
    private static DeclareHelperService declareHelperService = new DeclareHelperService();

    @Override
    public DataResultVo checkBeforeRun(String orgId, String category, String batchType) {
        return paramsCheckService.check(orgId, category, batchType);
    }

    @Override
    public DataResultVo initDateAndType(String orgId, Date startDate, Date endDate, Date executeTime) {
        Date skssqz;
        Date skssqq;
        if (startDate != null && endDate != null) {
            skssqq = startDate;
            skssqz = endDate;
        } else {
            skssqq = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)executeTime, (int)-1));
            skssqz = DateUtils.getLastDateOfYear((Date)skssqq);
        }
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("orgid", orgId);
        result.put("skssqq", DateUtils.format((Date)skssqq));
        result.put("skssqz", DateUtils.format((Date)skssqz));
        DynamicObject taxMain = orgHelperService.findTaxMain(Long.parseLong(orgId));
        if (taxMain == null) {
            return DataResultVo.fail(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u8868\u4e2d\u4e0d\u5b58\u5728\u8be5orgid\uff1a%s", (String)"HjDeclareHandlerService_0", (String)"taxc-tccit", (Object[])new Object[0]), orgId), result);
        }
        DynamicObject taxInfos = orgHelperService.findTaxInfos(taxMain, TAX_TYPE);
        if (taxInfos == null) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6240\u5f97\u7a0e\u7a0e\u79cd\u5361\u7247", (String)"HjDeclareHandlerService_1", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        String levytype = taxInfos.getString("levytype");
        Boolean islevel3 = orgHelperService.isFzGroup(orgId, DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
        if (islevel3.booleanValue()) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e3a\u4e09\u7ea7\u5206\u652f\u673a\u6784\u65e0\u9700\u751f\u6210\u4f01\u4e1a\u6240\u5f97\u7a0e\u5e74\u5ea6\u7533\u62a5\u6570\u636e", (String)"HjDeclareHandlerService_2", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        Boolean isFzSummary = orgHelperService.checkOrgDeclaration(Long.parseLong(orgId), skssqq, skssqz, "3", TAX_TYPE, null);
        String templateType = declareHelperService.getTemplateType(CATEGORY, levytype, isFzSummary, false);
        TaxableListDto taxableListDto = new TaxableListDto();
        taxableListDto.setTemplatetype(templateType);
        taxableListDto.setSkssqq(skssqq);
        taxableListDto.setSkssqz(skssqz);
        taxableListDto.setOrg(Long.valueOf(Long.parseLong(orgId)));
        return DataResultVo.success("success", taxableListDto);
    }

    @Override
    public DataResultVo initData(String orgId, Date startDate, Date endDate, Date executeTime) {
        DataResultVo dataResultVo = this.initDateAndType(orgId, startDate, endDate, executeTime);
        if (!dataResultVo.getSuccess().booleanValue()) {
            return dataResultVo;
        }
        TaxableListDto taxableListDto = (TaxableListDto)dataResultVo.getData();
        if (taxableListDto == null) {
            return DataResultVo.fail("initDateAndType not get data");
        }
        String templateType = taxableListDto.getTemplatetype();
        Date skssqq = taxableListDto.getSkssqq();
        Date skssqz = taxableListDto.getSkssqz();
        DynamicObject taxMain = orgHelperService.findTaxMain(Long.parseLong(orgId));
        if (taxMain == null) {
            return DataResultVo.fail(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u8868\u4e2d\u4e0d\u5b58\u5728\u8be5orgid\uff1a%s", (String)"HjDeclareHandlerService_0", (String)"taxc-tccit", (Object[])new Object[0]), orgId));
        }
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("orgid", orgId);
        result.put("skssqq", DateUtils.format((Date)skssqq));
        result.put("skssqz", DateUtils.format((Date)skssqz));
        DynamicObject dyo = YbnsrService.queryYbnsr((String)orgId, (String)templateType, (String)DateUtils.format((Date)skssqq), (String)DateUtils.format((Date)skssqz), null);
        if (dyo != null) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u5b58\u5728\u5bf9\u5e94\u5c5e\u671f\u7684\u4f01\u4e1a\u6240\u5f97\u7a0e\u5e74\u5ea6\u7533\u62a5\u6570\u636e", (String)"HjDeclareHandlerService_3", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        DeclareRequestModel declareRequestModel = declareHelperService.createDeclareRequestModel(taxMain, skssqq, skssqz, templateType);
        Long templateId = DeclareServiceHelper.getTemplateId((DeclareRequestModel)declareRequestModel);
        if (templateId == null) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4f01\u4e1a\u6240\u5f97\u7a0e\u5e74\u5ea6\u7533\u62a5\u6a21\u677f", (String)"HjDeclareHandlerService_4", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        declareRequestModel.setTemplateId(templateId);
        Map<String, String> map = hjBatchDeclareService.createNsrxxCalcAndSave(declareRequestModel);
        return DataResultVo.success(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u5e74\u5ea6\u7533\u62a5\u6570\u636e\u521b\u5efa\u6210\u529f", (String)"HjDeclareHandlerService_5", (String)"taxc-tccit", (Object[])new Object[0]), result);
    }

    @Override
    public void runTask(EngineModel engineModel) {
    }
}

