/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.batch.impl.handler;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.batch.IBatchDraftService;
import kd.taxc.tccit.business.batch.IBatchHandler;
import kd.taxc.tccit.business.batch.OrgHelperService;
import kd.taxc.tccit.business.batch.ParamsCheckService;
import kd.taxc.tccit.business.batch.impl.HjBatchDraftService;
import kd.taxc.tccit.business.batch.impl.handler.HjDeclareHandlerService;
import kd.taxc.tccit.business.batch.impl.handler.HjYearBranchDraftService;
import kd.taxc.tccit.business.calc.impl.CalcSummery;
import kd.taxc.tccit.business.draft.DraftService;
import kd.taxc.tccit.business.engine.BranchTaxpayEngine;
import kd.taxc.tccit.business.engine.YearAccEngine;
import kd.taxc.tccit.business.pojo.DataResultVo;
import kd.taxc.tccit.business.taxbook.BranchTaxbookBusinessService;
import kd.taxc.tccit.formplugin.branch.BranchCalcPagePlugin;

public class HjDraftHandlerService
implements IBatchHandler {
    private static ParamsCheckService paramsCheckService = new ParamsCheckService();
    private static IBatchDraftService hjBatchDraftService = new HjBatchDraftService();
    private static IBatchDraftService hjYearBranchDraftService = new HjYearBranchDraftService();
    private static OrgHelperService orgHelperService = new OrgHelperService();
    private static HjDeclareHandlerService hjDeclareHandlerService = new HjDeclareHandlerService();

    @Override
    public DataResultVo checkBeforeRun(String orgId, String category, String batchType) {
        return paramsCheckService.check(orgId, category, batchType);
    }

    @Override
    public DataResultVo initDateAndType(String orgId, Date startDate, Date endDate, Date executeTime) {
        Date startdate = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)executeTime, (int)-1));
        Date enddate = DateUtils.getLastDateOfYear((Date)startdate);
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("orgid", orgId);
        result.put("skssqq", DateUtils.format((Date)startdate));
        result.put("skssqz", DateUtils.format((Date)enddate));
        Boolean islevel3 = orgHelperService.isFzGroup(orgId, DateUtils.format((Date)startdate), DateUtils.format((Date)enddate));
        if (islevel3.booleanValue()) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e3a\u4e09\u7ea7\u5206\u652f\u673a\u6784\u65e0\u9700\u751f\u6210\u4f01\u4e1a\u6240\u5f97\u7a0e\u5e74\u5ea6\u7533\u62a5\u5e95\u7a3f\u6570\u636e", (String)"HjDraftHandlerService_0", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        TaxableListDto taxableListDto = new TaxableListDto();
        taxableListDto.setSkssqq(startdate);
        taxableListDto.setSkssqz(enddate);
        taxableListDto.setOrg(Long.valueOf(Long.parseLong(orgId)));
        return DataResultVo.success("success", taxableListDto);
    }

    @Override
    public DataResultVo initData(String orgId, Date startDate, Date endDate, Date executeTime) {
        DataResultVo dataResultVo = this.initDateAndType(orgId, startDate, endDate, executeTime);
        if (!dataResultVo.getSuccess().booleanValue()) {
            return dataResultVo;
        }
        TaxableListDto taxableListDto = (TaxableListDto)dataResultVo.getData();
        if (taxableListDto == null) {
            return DataResultVo.fail("initDateAndType not get data");
        }
        Date startdate = taxableListDto.getSkssqq();
        Date enddate = taxableListDto.getSkssqz();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("orgid", orgId);
        result.put("skssqq", DateUtils.format((Date)startdate));
        result.put("skssqz", DateUtils.format((Date)enddate));
        Boolean draftIsExists = hjBatchDraftService.draftIsExists(Long.parseLong(orgId), "draft_qysdsnb", startdate, enddate);
        if (draftIsExists.booleanValue()) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u5b58\u5728\u5bf9\u5e94\u5c5e\u671f\u7684\u4f01\u4e1a\u6240\u5f97\u7a0e\u5e74\u5ea6\u7533\u62a5\u5e95\u7a3f\u6570\u636e", (String)"HjDraftHandlerService_1", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        DynamicObjectCollection dynamicObjects = orgHelperService.queryOrgDeclaration(Long.parseLong(orgId), startdate, enddate, "3", "qysds", null);
        Boolean isYearBranch = dynamicObjects != null && dynamicObjects.size() > 0 && ((DynamicObject)dynamicObjects.get(0)).getBoolean("shareid");
        DataResultVo checkResultVo = BranchTaxbookBusinessService.checkBrankShare(Long.parseLong(orgId), startdate, enddate);
        if (isYearBranch.booleanValue()) {
            result.put("isYearBranch", isYearBranch);
            DataResultVo checkExists = this.existSummeryDraft(orgId, startdate, enddate, executeTime);
            if (!checkExists.getSuccess().booleanValue()) {
                return checkExists;
            }
            DynamicObject policy = hjYearBranchDraftService.createPolicy(Long.parseLong(orgId), startdate, enddate, null, null);
            if (policy == null) {
                return DataResultVo.fail(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u5e74\u5ea6\u7533\u62a5\u5e95\u7a3f\u653f\u7b56\u8fd0\u7ef4\u6570\u636e\u521b\u5efa\u5931\u8d25", (String)"HjDraftHandlerService_2", (String)"taxc-tccit", (Object[])new Object[0]), result);
            }
            if (!checkResultVo.getSuccess().booleanValue()) {
                return checkResultVo;
            }
            hjYearBranchDraftService.createDraftMain(Long.parseLong(orgId), "draft_qysdsnb", startdate, enddate);
            result.put("policy", policy);
            if (StringUtil.isNotBlank((CharSequence)dataResultVo.getMessage())) {
                return checkResultVo;
            }
            return DataResultVo.success(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u5e74\u5ea6\u7533\u62a5\u5e95\u7a3f\u653f\u7b56\u8fd0\u7ef4\u6570\u636e\u521b\u5efa\u6210\u529f", (String)"HjDraftHandlerService_3", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        if (!checkResultVo.getSuccess().booleanValue()) {
            return checkResultVo;
        }
        DynamicObject policy = hjBatchDraftService.createPolicy(Long.parseLong(orgId), startdate, enddate, null, null);
        if (policy == null) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u5e74\u5ea6\u7533\u62a5\u5e95\u7a3f\u653f\u7b56\u8fd0\u7ef4\u6570\u636e\u521b\u5efa\u5931\u8d25", (String)"HjDraftHandlerService_2", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        hjBatchDraftService.createDraftMain(Long.parseLong(orgId), "draft_qysdsnb", startdate, enddate);
        DynamicObject yearDgBill = DraftService.getYearDgBill(Long.parseLong(orgId), startdate, enddate);
        yearDgBill.set("fetchstatus", (Object)"2");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yearDgBill});
        result.put("policy", policy);
        if (StringUtil.isNotBlank((CharSequence)checkResultVo.getMessage())) {
            checkResultVo.setData(result);
            return checkResultVo;
        }
        return DataResultVo.success(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u5e74\u5ea6\u7533\u62a5\u5e95\u7a3f\u653f\u7b56\u8fd0\u7ef4\u6570\u636e\u521b\u5efa\u6210\u529f", (String)"HjDraftHandlerService_3", (String)"taxc-tccit", (Object[])new Object[0]), result);
    }

    @Override
    public void runTask(EngineModel engineModel) {
        Map custom = engineModel.getCustom();
        Boolean isYearBranch = custom.getOrDefault("isYearBranch", Boolean.FALSE);
        if (isYearBranch != null && isYearBranch.booleanValue()) {
            try (TXHandle h = TX.required();){
                try {
                    BranchTaxpayEngine branchTaxpayEngine = new BranchTaxpayEngine();
                    branchTaxpayEngine.deleteData(engineModel);
                    branchTaxpayEngine.runEngine(engineModel);
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw t;
                }
                new BranchCalcPagePlugin().calcSummery(custom);
            }
        }
        YearAccEngine yearAccEngine = new YearAccEngine();
        yearAccEngine.deleteData(engineModel);
        yearAccEngine.runEngine(engineModel);
        CopyOnWriteArrayList<List<DynamicObject>> saveDetails = yearAccEngine.getSaveDetails();
        try (TXHandle h = TX.required();){
            try {
                saveDetails.stream().forEach(s -> SaveServiceHelper.save((DynamicObject[])s.toArray(new DynamicObject[0])));
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
        new CalcSummery().notifyObservers(engineModel.getCustom());
    }

    private DataResultVo existSummeryDraft(String orgId, Date skssqq, Date skssqz, Date executeTime) {
        DynamicObjectCollection dynamicObjects = orgHelperService.queryOrgDeclaration(Long.parseLong(orgId), skssqq, skssqz, "3", "qysds", null);
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u5206\u652f\u673a\u6784\u5bf9\u5e94\u7684\u603b\u673a\u6784\u4e0d\u5b58\u5728", (String)"HjDraftHandlerService_4", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        String parentOrgId = ((DynamicObject)dynamicObjects.get(0)).getString("collectorg");
        DataResultVo dataResultVo = hjDeclareHandlerService.checkBeforeRun(parentOrgId, "qysdsnb", "draft");
        if (!dataResultVo.getSuccess().booleanValue()) {
            return dataResultVo;
        }
        dataResultVo = hjDeclareHandlerService.initDateAndType(parentOrgId, skssqq, skssqz, executeTime);
        if (!dataResultVo.getSuccess().booleanValue()) {
            return dataResultVo;
        }
        DynamicObject dyo = YbnsrService.queryYbnsr((String)parentOrgId, (String)((TaxableListDto)dataResultVo.getData()).getTemplatetype(), (String)DateUtils.format((Date)skssqq), (String)DateUtils.format((Date)skssqz), null);
        if (dyo == null) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u5206\u652f\u673a\u6784\u5e95\u7a3f\u4ece\u603b\u673a\u6784\u7533\u62a5\u8868\u53d6\u6570\uff0c\u7531\u4e8e\u603b\u673a\u6784\u7533\u62a5\u8868\u672a\u751f\u6210\uff0c\u5206\u652f\u673a\u6784\u5e95\u7a3f\u6682\u4e0d\u751f\u6210\u3002", (String)"HjDraftHandlerService_5", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        return DataResultVo.success("ok");
    }
}

