/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.batch.impl.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.batch.IBatchDraftService;
import kd.taxc.tccit.business.declare.DeclareCompanyTypeService;
import kd.taxc.tccit.business.pojo.DataResultVo;
import org.apache.commons.collections.CollectionUtils;

public class HjYearBranchDraftService
implements IBatchDraftService {
    private static Log LOGGER = LogFactory.getLog(HjYearBranchDraftService.class);
    private static final String ENTRY = "apitudeentryentity";
    private static final String POLICY_ENTRY = "tccit_branch_confpolicy";
    private static final String TCTB_DRAFT_MAIN = "tctb_draft_main";

    @Override
    public DataResultVo isExistLastData(Long orgid, Date startDate, Date endDate, Date lastStartDate, Date lastEndDate) {
        List<QFilter> qFilters = HjYearBranchDraftService.buildQFilters(orgid, startDate, endDate);
        boolean exists = QueryServiceHelper.exists((String)TCTB_DRAFT_MAIN, (QFilter[])qFilters.toArray(new QFilter[0]));
        if (exists) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u5e95\u7a3f\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u518d\u6b21\u751f\u6210", (String)"HjYearBranchDraftService_0", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        if (this.isFzjg(orgid, endDate)) {
            return DataResultVo.ok();
        }
        List<QFilter> qFilters1 = HjYearBranchDraftService.buildQFilters(orgid, lastStartDate, lastEndDate);
        boolean exists1 = QueryServiceHelper.exists((String)TCTB_DRAFT_MAIN, (QFilter[])qFilters1.toArray(new QFilter[0]));
        if (!exists1) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u4e0a\u671f\u9884\u7f34\u7533\u62a5\u5e95\u7a3f\u6570\u636e\uff0c\u65e0\u6cd5\u751f\u6210\u9884\u7f34\u7533\u62a5\u5e95\u7a3f", (String)"HjYearBranchDraftService_1", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        return DataResultVo.ok();
    }

    @Override
    public Boolean draftIsExists(Long orgid, String templatetype, Date startdate, Date enddate) {
        return null;
    }

    private boolean isFzjg(Long orgid, Date endDate) {
        return QueryServiceHelper.exists((String)"tctb_org_group_latest", (QFilter[])new QFilter[]{new QFilter("orgrow.orgid", "=", (Object)orgid), new QFilter("orgrow.declaration", "=", (Object)"3"), new QFilter("taxtype", "=", (Object)"qysds"), new QFilter("status", "=", (Object)"2"), OrgUtils.getQFilter((Date)endDate)});
    }

    @Override
    public DynamicObject createPolicy(Long orgid, Date startdate, Date enddate, Date lastStartDate, Date lastEndDate) {
        DynamicObject dynamicObject = this.contractPolicy("0", "0", " ", orgid, startdate, enddate);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return dynamicObject;
    }

    private DynamicObject contractPolicy(String sospersonnum, String eospersonnum, String suittype, long orgid, Date startdate, Date enddate) {
        DynamicObject policy = BusinessDataServiceHelper.newDynamicObject((String)POLICY_ENTRY);
        policy.set("orgid", (Object)orgid);
        policy.set("startdate", (Object)startdate);
        policy.set("enddate", (Object)enddate);
        policy.set("suittype", (Object)suittype);
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid).getData();
        String illegal = taxMain != null ? taxMain.getString("restrictbanindustry") : "";
        Long registerTypeId = taxMain != null ? taxMain.getLong("registertype.id") : 0L;
        String declareType = this.initDeclareCompanyType(orgid, enddate);
        policy.set("illegal", (Object)illegal);
        policy.set("registertype", (Object)registerTypeId);
        policy.set("declareType", (Object)declareType);
        DynamicObjectCollection apitudeEntryEntity = policy.getDynamicObjectCollection(ENTRY);
        this.initAptitude(taxMain, apitudeEntryEntity, startdate, enddate);
        return policy;
    }

    @Override
    public DynamicObject createDraftMain(Long orgid, String templatetype, Date skssqq, Date skssqz) {
        StatusUtils.createStatus((String)"draft_qysdsnb", (String)String.valueOf(orgid), (String)DateUtils.format((Date)skssqq), (String)DateUtils.format((Date)skssqz), (String)"2", (String)"nssb", (String)"");
        return this.saveDraftNumber(orgid, skssqq, skssqz);
    }

    private DynamicObject saveDraftNumber(Long orgId, Date startDate, Date endDate) {
        String dgType = this.getDgType(orgId, endDate);
        DynamicObject billObject = this.queryDraftBillObject(orgId, startDate, endDate);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCTB_DRAFT_MAIN);
        String readNumber = DeclareServiceHelper.generateSBBNo((String)TCTB_DRAFT_MAIN, (DynamicObject)dynamicObject, (String)String.valueOf(orgId));
        readNumber = readNumber.replaceAll("X", dgType);
        if (billObject == null) {
            dynamicObject.set("billstatus", (Object)"A");
            dynamicObject.set("startdate", (Object)startDate);
            dynamicObject.set("enddate", (Object)endDate);
            dynamicObject.set("org", (Object)orgId);
            dynamicObject.set("templatetype", (Object)"draft_qysdsnb");
            dynamicObject.set("billno", (Object)readNumber);
            dynamicObject.set("draftpurpose", (Object)"nssb");
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billObject.getLong("id"), (String)TCTB_DRAFT_MAIN);
        }
        dynamicObject.set("type", (Object)dgType.split("-")[1]);
        dynamicObject.set("billno", (Object)readNumber);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)TCTB_DRAFT_MAIN, (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
        this.sendDraftSaveMQ(dynamicObject, startDate, endDate);
        return dynamicObject;
    }

    private DynamicObject queryDraftBillObject(Long orgId, Date startdate, Date enddate) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)startdate).and(new QFilter("enddate", "=", (Object)enddate));
        QFilter templatetype = new QFilter("templatetype", "=", (Object)"draft_qysdsnb");
        QFilter draftpurposeype = new QFilter("draftpurpose", "=", (Object)"nssb");
        return QueryServiceHelper.queryOne((String)TCTB_DRAFT_MAIN, (String)"id,billno,billstatus,jtnumber", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, templatetype, draftpurposeype});
    }

    private String getDgType(Long orgId, Date endDate) {
        String billType = DeclareCompanyTypeService.getDgType(String.valueOf(orgId), DateUtils.format((Date)endDate), "year");
        return "CIT-" + billType;
    }

    private void initAptitude(DynamicObject taxMain, DynamicObjectCollection apitudeEntryEntity, Date startDate, Date endDate) {
        if (taxMain != null) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)POLICY_ENTRY);
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            EntityType entityType = (EntityType)mainEntityType.getAllEntities().get(ENTRY);
            DataEntityPropertyCollection propertyCollection = entityType.getProperties();
            for (IDataEntityProperty property : mainPros) {
                if (!ENTRY.equals(property.getName())) continue;
                DynamicObjectCollection entryid = taxMain.getDynamicObjectCollection(ENTRY);
                for (DynamicObject d : entryid) {
                    Date apitudestartdate = d.getDate("apitudestartdate");
                    Date apitudeenddate = d.getDate("apitudeenddate");
                    if (apitudestartdate.compareTo(endDate) > 0 || apitudeenddate != null && apitudeenddate.compareTo(startDate) < 0) continue;
                    DynamicObject addNew = apitudeEntryEntity.addNew();
                    for (IDataEntityProperty entityProperty : propertyCollection) {
                        if (entityProperty.getName().equals("id") || entityProperty.getName().equals("exporttype") || entityProperty.getName().equals("creditrating")) continue;
                        addNew.set(entityProperty.getName(), d.get(entityProperty.getName()));
                    }
                }
            }
        }
    }

    private String initDeclareCompanyType(Long orgid, Date endDate) {
        QFilter orgFilter = new QFilter("orgrow.orgid", "=", (Object)orgid);
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.id,orgrow.pid,orgrow.orgid,orgrow.shareid as share,orgrow.declaration as declare,orgrow.kdqjyqylx as kdqjyqylx", (QFilter[])new QFilter[]{taxtypeFilter, orgFilter, statusFilter, OrgUtils.getQFilter((Date)endDate)});
        if (CollectionUtils.isNotEmpty((Collection)objects)) {
            DynamicObject dynamicObject = (DynamicObject)objects.get(0);
            return dynamicObject.getString("kdqjyqylx");
        }
        return "";
    }

    private static List<QFilter> buildQFilters(Long orgid, Date startdate, Date enddate) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("templatetype", "=", (Object)"draft_qysdsjb"));
        list.add(new QFilter("startdate", "=", (Object)startdate));
        list.add(new QFilter("enddate", "=", (Object)enddate));
        list.add(new QFilter("org", "=", (Object)orgid));
        list.add(new QFilter("draftpurpose", "=", (Object)"nssb"));
        return list;
    }
}

