/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.batch.impl.handler;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.batch.DeclareHelperService;
import kd.taxc.tccit.business.batch.IBatchDeclareService;
import kd.taxc.tccit.business.batch.IBatchHandler;
import kd.taxc.tccit.business.batch.OrgHelperService;
import kd.taxc.tccit.business.batch.ParamsCheckService;
import kd.taxc.tccit.business.batch.impl.YjBatchDeclareService;
import kd.taxc.tccit.business.pojo.DataResultVo;

public class YjDeclareHandlerService
implements IBatchHandler {
    private static final String TAX_TYPE = "qysds";
    private static final String CATEGORY = "qysdsjb";
    private static ParamsCheckService paramsCheckService = new ParamsCheckService();
    private static IBatchDeclareService yjBatchDeclareService = new YjBatchDeclareService();
    private static OrgHelperService orgHelperService = new OrgHelperService();
    private static DeclareHelperService declareHelperService = new DeclareHelperService();

    @Override
    public DataResultVo checkBeforeRun(String orgId, String category, String batchType) {
        return paramsCheckService.check(orgId, category, batchType);
    }

    @Override
    public DataResultVo initDateAndType(String orgId, Date startDate, Date endDate, Date executeTime) {
        Boolean islevel3;
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("orgid", orgId);
        DynamicObject taxMain = orgHelperService.findTaxMain(Long.parseLong(orgId));
        if (taxMain == null) {
            return DataResultVo.fail(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u8868\u4e2d\u4e0d\u5b58\u5728\u8be5orgid\uff1a%s", (String)"YjDeclareHandlerService_0", (String)"taxc-tccit", (Object[])new Object[0]), orgId), result);
        }
        DynamicObject taxInfos = orgHelperService.findTaxInfos(taxMain, TAX_TYPE);
        if (taxInfos == null) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6240\u5f97\u7a0e\u7a0e\u79cd\u5361\u7247", (String)"YjDeclareHandlerService_1", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        if ("hdzs".equals(taxInfos.getString("levytype"))) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u6838\u5b9a\u5f81\u6536\u7ec4\u7ec7\u4e0d\u5de5\u4f5c\u53f0\u65e0\u6cd5\u751f\u6210\u6570\u636e", (String)"YjDeclareHandlerService_2", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        String deadline = taxInfos.getString("deadline");
        String levytype = taxInfos.getString("levytype");
        Date skssqq = null;
        Date skssqz = null;
        if (startDate != null && endDate != null) {
            skssqq = startDate;
            skssqz = endDate;
        } else {
            if ("ajsb".equals(deadline)) {
                skssqq = DateUtils.getFirstDateOfSeason((Date)DateUtils.addMonth((Date)executeTime, (int)-3));
                skssqz = DateUtils.getLastDateOfSeason((Date)skssqq);
            }
            if ("aysb".equals(deadline)) {
                skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)executeTime, (int)-1));
                skssqz = DateUtils.getLastDateOfMonth((Date)skssqq);
            }
        }
        result.put("skssqq", DateUtils.format((Date)skssqq));
        result.put("skssqz", DateUtils.format((Date)skssqz));
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tccit", (String)"zerodeclare", (long)Long.parseLong(orgId));
        if (!zerodeclare && (islevel3 = orgHelperService.isFzGroup(orgId, DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz))).booleanValue()) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e3a\u4e09\u7ea7\u5206\u652f\u673a\u6784\u65e0\u9700\u751f\u6210\u4f01\u4e1a\u6240\u5f97\u7a0e\u9884\u7f34\u7533\u62a5\u6570\u636e", (String)"YjDeclareHandlerService_3", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        String templateType = declareHelperService.getTemplateType(CATEGORY, levytype, Boolean.FALSE, zerodeclare);
        TaxableListDto taxableListDto = new TaxableListDto();
        taxableListDto.setTemplatetype(templateType);
        taxableListDto.setSkssqq(skssqq);
        taxableListDto.setSkssqz(skssqz);
        taxableListDto.setOrg(Long.valueOf(Long.parseLong(orgId)));
        return DataResultVo.success("success", taxableListDto);
    }

    @Override
    public DataResultVo initData(String orgId, Date startDate, Date endDate, Date executeTime) {
        DataResultVo dataResultVo = this.initDateAndType(orgId, startDate, endDate, executeTime);
        if (!dataResultVo.getSuccess().booleanValue()) {
            return dataResultVo;
        }
        TaxableListDto taxableListDto = (TaxableListDto)dataResultVo.getData();
        if (taxableListDto == null) {
            return DataResultVo.fail("initDateAndType not get data");
        }
        String templateType = taxableListDto.getTemplatetype();
        Date skssqq = taxableListDto.getSkssqq();
        Date skssqz = taxableListDto.getSkssqz();
        DataResultVo generateDeclare = yjBatchDeclareService.isGenerateDeclare(Long.parseLong(orgId), templateType, skssqq, skssqz);
        if (!generateDeclare.getSuccess().booleanValue()) {
            return generateDeclare;
        }
        Map orgidAndNameMap = (Map)generateDeclare.getData();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("skssqq", DateUtils.format((Date)skssqq));
        result.put("skssqz", DateUtils.format((Date)skssqz));
        StringBuilder msg = new StringBuilder();
        String paymentPeriod = "";
        for (Map.Entry entry : orgidAndNameMap.entrySet()) {
            DataResultVo checkResult;
            Long needOrgid = (Long)entry.getKey();
            String orgName = (String)entry.getValue();
            result.put("orgid", needOrgid);
            if (StringUtil.isNotBlank((CharSequence)orgName) && !(checkResult = paramsCheckService.check(String.valueOf(needOrgid), CATEGORY, "declare")).getSuccess().booleanValue()) {
                msg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c%2$s\n", (String)"YjDeclareHandlerService_4", (String)"taxc-tccit", (Object[])new Object[0]), orgName, checkResult.getMessage()));
                continue;
            }
            DynamicObject taxMain = orgHelperService.findTaxMain(needOrgid);
            DynamicObject taxInfos = orgHelperService.findTaxInfos(taxMain, TAX_TYPE);
            if (StringUtil.isBlank((CharSequence)orgName)) {
                paymentPeriod = taxInfos.getString("deadline");
            } else {
                String fzjgPaymentPeriod = taxInfos.getString("deadline");
                if (!paymentPeriod.equals(fzjgPaymentPeriod)) {
                    msg.append(String.format(ResManager.loadKDString((String)"\u5206\u652f\u673a\u6784\uff1a%s\uff0c\u548c\u603b\u673a\u6784\u7f34\u7eb3\u671f\u9650\u4e0d\u4e00\u81f4\n", (String)"YjDeclareHandlerService_5", (String)"taxc-tccit", (Object[])new Object[0]), orgName));
                    continue;
                }
            }
            if (taxMain == null) {
                if (StringUtil.isBlank((CharSequence)orgName)) {
                    return DataResultVo.fail(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u8868\u4e2d\u4e0d\u5b58\u5728\u8be5orgid\uff1a%s", (String)"YjDeclareHandlerService_0", (String)"taxc-tccit", (Object[])new Object[0]), needOrgid));
                }
                msg.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u8868\u4e2d\u4e0d\u5b58\u5728\u8be5\u7ec4\u7ec7\uff1a%s\n", (String)"YjDeclareHandlerService_6", (String)"taxc-tccit", (Object[])new Object[0]), orgName));
                continue;
            }
            Date firstDayOfRegisterTime = DateUtils.getFirstDateOfMonth((Date)taxMain.getDate("registertime"));
            if (DateUtils.monthOfD1MinusD2((Date)executeTime, (Date)firstDayOfRegisterTime) <= 0) {
                msg.append(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\uff1a%s\u672c\u6708\u65b0\u6ce8\u518c\u767b\u8bb0\uff0c\u672c\u6708\u65e0\u9700\u7533\u62a5\u3002\n", (String)"YjDeclareHandlerService_7", (String)"taxc-tccit", (Object[])new Object[0]), orgName));
                continue;
            }
            DynamicObject dyo = YbnsrService.queryYbnsr((String)String.valueOf(needOrgid), (String)templateType, (String)DateUtils.format((Date)skssqq), (String)DateUtils.format((Date)skssqz), null);
            if (dyo != null) {
                if (StringUtil.isBlank((CharSequence)orgName)) {
                    return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u5b58\u5728\u5bf9\u5e94\u5c5e\u671f\u7684\u4f01\u4e1a\u6240\u5f97\u7a0e\u9884\u7f34\u7533\u62a5\u6570\u636e", (String)"YjDeclareHandlerService_8", (String)"taxc-tccit", (Object[])new Object[0]), result);
                }
                msg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s,\u5df2\u5b58\u5728\u5bf9\u5e94\u5c5e\u671f\u7684\u4f01\u4e1a\u6240\u5f97\u7a0e\u9884\u7f34\u7533\u62a5\u6570\u636e\n", (String)"YjDeclareHandlerService_9", (String)"taxc-tccit", (Object[])new Object[0]), orgName));
                continue;
            }
            DeclareRequestModel declareRequestModel = declareHelperService.createDeclareRequestModel(taxMain, skssqq, skssqz, templateType);
            Long templateId = DeclareServiceHelper.getTemplateId((DeclareRequestModel)declareRequestModel);
            if (templateId == null) {
                if (StringUtil.isBlank((CharSequence)orgName)) {
                    return DataResultVo.fail(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4f01\u4e1a\u6240\u5f97\u7a0e\u9884\u7f34\u7533\u62a5\u6a21\u677f", (String)"YjDeclareHandlerService_10", (String)"taxc-tccit", (Object[])new Object[0]), result);
                }
                msg.append(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\uff1a%s\uff0c\u5bf9\u5e94\u7684\u4f01\u4e1a\u6240\u5f97\u7a0e\u9884\u7f34\u7533\u62a5\u6a21\u677f\n", (String)"YjDeclareHandlerService_11", (String)"taxc-tccit", (Object[])new Object[0]), orgName));
                continue;
            }
            declareRequestModel.setTemplateId(templateId);
            Map<String, String> map = yjBatchDeclareService.createNsrxxCalcAndSave(declareRequestModel);
        }
        if (StringUtil.isBlank((CharSequence)msg)) {
            return DataResultVo.success(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u9884\u7f34\u7533\u62a5\u6570\u636e\u521b\u5efa\u6210\u529f", (String)"YjDeclareHandlerService_12", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        return DataResultVo.fail(msg.toString(), result);
    }

    @Override
    public void runTask(EngineModel engineModel) {
    }
}

