/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.batch.impl.handler;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.batch.IBatchDraftService;
import kd.taxc.tccit.business.batch.IBatchHandler;
import kd.taxc.tccit.business.batch.OrgHelperService;
import kd.taxc.tccit.business.batch.ParamsCheckService;
import kd.taxc.tccit.business.batch.impl.YjBatchDraftService;
import kd.taxc.tccit.business.batch.impl.handler.YjDeclareHandlerService;
import kd.taxc.tccit.business.draft.DraftMainService;
import kd.taxc.tccit.business.engine.refactoring.handler.SeasonalDraftEngineHandler;
import kd.taxc.tccit.business.pojo.DataResultVo;
import kd.taxc.tccit.business.pojo.DateRangeVo;
import kd.taxc.tccit.business.taxbook.BranchTaxbookBusinessService;
import kd.taxc.tccit.common.utils.DateRangeUtils;
import kd.taxc.tccit.formplugin.seasonal.SeasonalCalcPagePlugin;

public class YjDraftHandlerService
implements IBatchHandler {
    private static ParamsCheckService paramsCheckService = new ParamsCheckService();
    private static IBatchDraftService yjBatchDraftService = new YjBatchDraftService();
    private static OrgHelperService orgHelperService = new OrgHelperService();
    private static YjDeclareHandlerService yjDeclareHandlerService = new YjDeclareHandlerService();
    private DateRangeVo dateRangeVo = new DateRangeVo();

    @Override
    public DataResultVo checkBeforeRun(String orgId, String category, String batchType) {
        return paramsCheckService.check(orgId, category, batchType);
    }

    @Override
    public DataResultVo initDateAndType(String orgId, Date skssqq, Date skssqz, Date executeTime) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("orgid", orgId);
        DynamicObject taxMain = orgHelperService.findTaxMain(Long.parseLong(orgId));
        if (taxMain == null) {
            return DataResultVo.fail(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u8868\u4e2d\u4e0d\u5b58\u5728\u8be5orgid\uff1a%s", (String)"YjDraftHandlerService_0", (String)"taxc-tccit", (Object[])new Object[0]), orgId), result);
        }
        DynamicObject taxInfos = orgHelperService.findTaxInfos(taxMain, "qysds");
        if (taxInfos == null) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6240\u5f97\u7a0e\u7a0e\u79cd\u5361\u7247", (String)"YjDraftHandlerService_1", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        if ("hdzs".equals(taxInfos.getString("levytype"))) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u6838\u5b9a\u5f81\u6536\u7ec4\u7ec7\u4e0d\u5de5\u4f5c\u53f0\u65e0\u6cd5\u751f\u6210\u6570\u636e", (String)"YjDraftHandlerService_2", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        if ("fjmqy".equals(taxInfos.getString("residenttype"))) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u975e\u5c45\u6c11\u4f01\u4e1a\u6682\u4e0d\u652f\u6301\u751f\u6210\u5e95\u7a3f\u6570\u636e", (String)"YjDraftHandlerService_3", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        String deadline = taxInfos.getString("deadline");
        this.dateRangeVo = DateRangeUtils.initStartAndEndDate("ajsb".equals(deadline) ? "season" : "month", executeTime);
        result.put("skssqq", DateUtils.format((Date)this.dateRangeVo.getStartDate()));
        result.put("skssqz", DateUtils.format((Date)this.dateRangeVo.getEndDate()));
        Boolean islevel3 = orgHelperService.isFzGroup(orgId, DateUtils.format((Date)this.dateRangeVo.getStartDate()), DateUtils.format((Date)this.dateRangeVo.getEndDate()));
        if (islevel3.booleanValue()) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e3a\u4e09\u7ea7\u5206\u652f\u673a\u6784\u65e0\u9700\u751f\u6210\u4f01\u4e1a\u6240\u5f97\u7a0e\u9884\u7f34\u7533\u62a5\u5e95\u7a3f\u6570\u636e", (String)"YjDraftHandlerService_4", (String)"taxc-tccit", (Object[])new Object[0]), result);
        }
        DataResultVo hasIntersection = DraftMainService.hasIntersection(orgId, DateUtils.format((Date)this.dateRangeVo.getStartDate()), DateUtils.format((Date)this.dateRangeVo.getEndDate()), "nssb");
        if (!hasIntersection.getSuccess().booleanValue()) {
            return DataResultVo.fail(hasIntersection.getMessage());
        }
        TaxableListDto taxableListDto = new TaxableListDto();
        taxableListDto.setSkssqq(this.dateRangeVo.getStartDate());
        taxableListDto.setSkssqz(this.dateRangeVo.getEndDate());
        taxableListDto.setOrg(Long.valueOf(Long.parseLong(orgId)));
        return DataResultVo.success("success", taxableListDto);
    }

    @Override
    public DataResultVo initData(String orgId, Date startdate, Date enddate, Date executeTime) {
        DataResultVo checkExists;
        DataResultVo dataResultVo = this.initDateAndType(orgId, null, null, executeTime);
        if (!dataResultVo.getSuccess().booleanValue()) {
            return dataResultVo;
        }
        TaxableListDto taxableListDto = (TaxableListDto)dataResultVo.getData();
        if (taxableListDto == null) {
            return DataResultVo.fail("initDateAndType not get data");
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("orgid", orgId);
        result.put("skssqq", DateUtils.format((Date)this.dateRangeVo.getStartDate()));
        result.put("skssqz", DateUtils.format((Date)this.dateRangeVo.getEndDate()));
        DataResultVo existLastData = yjBatchDraftService.isExistLastData(Long.parseLong(orgId), this.dateRangeVo.getStartDate(), this.dateRangeVo.getEndDate(), this.dateRangeVo.getLastStartDate(), this.dateRangeVo.getLastEndDate());
        if (!existLastData.getSuccess().booleanValue()) {
            existLastData.setData(result);
            return existLastData;
        }
        DynamicObjectCollection dynamicObjects = orgHelperService.queryOrgDeclaration(Long.parseLong(orgId), this.dateRangeVo.getStartDate(), this.dateRangeVo.getEndDate(), "3", "qysds", null);
        if (dynamicObjects != null && dynamicObjects.size() > 0 && ((DynamicObject)dynamicObjects.get(0)).getBoolean("shareid") && !(checkExists = this.existSummeryDraft(orgId, this.dateRangeVo.getStartDate(), this.dateRangeVo.getEndDate(), executeTime)).getSuccess().booleanValue()) {
            return checkExists;
        }
        DataResultVo checkResultVo = BranchTaxbookBusinessService.checkBrankShare(Long.parseLong(orgId), this.dateRangeVo.getStartDate(), this.dateRangeVo.getEndDate());
        if (!checkResultVo.getSuccess().booleanValue()) {
            return checkResultVo;
        }
        DataResultVo policyResult = yjBatchDraftService.createPolicyNew(Long.parseLong(orgId), this.dateRangeVo.getStartDate(), this.dateRangeVo.getEndDate(), this.dateRangeVo.getLastStartDate(), this.dateRangeVo.getLastEndDate());
        if (!policyResult.getSuccess().booleanValue()) {
            return policyResult;
        }
        result.put("policy", policyResult.getData());
        yjBatchDraftService.createDraftMain(Long.parseLong(orgId), "", this.dateRangeVo.getStartDate(), this.dateRangeVo.getEndDate());
        if (StringUtil.isNotBlank((CharSequence)checkResultVo.getMessage())) {
            checkResultVo.setData(result);
            return checkResultVo;
        }
        DynamicObjectCollection itemchoiceentity = ((DynamicObject)policyResult.getData()).getDynamicObjectCollection("itemchoiceentity");
        result.put("itemchoiceentity", itemchoiceentity);
        return DataResultVo.success(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u9884\u7f34\u7533\u62a5\u5e95\u7a3f\u653f\u7b56\u8fd0\u7ef4\u6570\u636e\u521b\u5efa\u6210\u529f", (String)"YjDraftHandlerService_5", (String)"taxc-tccit", (Object[])new Object[0]), result);
    }

    private DataResultVo existSummeryDraft(String orgId, Date skssqq, Date skssqz, Date executeTime) {
        DynamicObjectCollection dynamicObjects = orgHelperService.queryOrgDeclaration(Long.parseLong(orgId), skssqq, skssqz, "3", "qysds", null);
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u5206\u652f\u673a\u6784\u5bf9\u5e94\u7684\u603b\u673a\u6784\u4e0d\u5b58\u5728", (String)"YjDraftHandlerService_6", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        String parentOrgId = ((DynamicObject)dynamicObjects.get(0)).getString("collectorg");
        DataResultVo dataResultVo = yjDeclareHandlerService.checkBeforeRun(parentOrgId, "qysdsjb", "draft");
        if (!dataResultVo.getSuccess().booleanValue()) {
            return dataResultVo;
        }
        dataResultVo = yjDeclareHandlerService.initDateAndType(parentOrgId, skssqq, skssqz, executeTime);
        if (!dataResultVo.getSuccess().booleanValue()) {
            return dataResultVo;
        }
        DynamicObject dyo = YbnsrService.queryYbnsr((String)parentOrgId, (String)((TaxableListDto)dataResultVo.getData()).getTemplatetype(), (String)DateUtils.format((Date)skssqq), (String)DateUtils.format((Date)skssqz), null);
        if (dyo == null) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u5206\u652f\u673a\u6784\u5e95\u7a3f\u4ece\u603b\u673a\u6784\u7533\u62a5\u8868\u53d6\u6570\uff0c\u7531\u4e8e\u603b\u673a\u6784\u7533\u62a5\u8868\u672a\u751f\u6210\uff0c\u5206\u652f\u673a\u6784\u5e95\u7a3f\u6682\u4e0d\u751f\u6210\u3002", (String)"YjDraftHandlerService_7", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        return DataResultVo.success("ok");
    }

    @Override
    public void runTask(EngineModel engineModel) {
        try (TXHandle h = TX.required();){
            try {
                new SeasonalDraftEngineHandler().run(engineModel);
                HashMap<String, Object> customParams = new HashMap<String, Object>(16);
                customParams.put("orgid", String.valueOf(engineModel.getOrgId()));
                customParams.put("skssqq", engineModel.getStartDate());
                customParams.put("skssqz", engineModel.getEndDate());
                customParams.put("draftpurpose", "nssb");
                new SeasonalCalcPagePlugin().calcSummery(customParams);
                StatusUtils.updateStatus((String)"draft_qysdsjb", (String)engineModel.getOrgId(), (String)engineModel.getStartDate(), (String)engineModel.getEndDate(), (String)"3", (String)"nssb");
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
    }
}

