/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.calc;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.engine.refactoring.handler.SeasonalDraftEngineHandler;
import kd.taxc.tccit.business.policy.SeasonalPolicyService;

public class SeasonalCalcTask
extends AbstractTask {
    public static final String SHOW_NONTAX = "shownontax";
    public static final String SHOW_TREDUCED = "showtreduced";
    public static final String SHOW_INCRED = "showincred";
    public static final String SHOW_TECH_INCRED = "showtechincred";
    public static final String DECLARETYPE = "declaretype";
    public static final String ORG_LIST = "orglist";
    public static final String LEVY_TYPE = "levytype";

    private EngineModel createEngineModel(String orgId, String startdate, String enddate, Map<String, Object> params) {
        EngineModel engineModel = new EngineModel(orgId, startdate, enddate);
        ArrayList<Long> orgs = new ArrayList<Long>(16);
        for (Object aLong : (List)params.get(ORG_LIST)) {
            Long org = Long.valueOf(aLong.toString());
            orgs.add(org);
        }
        engineModel.addCustom(ORG_LIST, orgs);
        engineModel.addCustom(DECLARETYPE, params.get(DECLARETYPE));
        engineModel.addCustom(SHOW_NONTAX, params.get(SHOW_NONTAX));
        engineModel.addCustom(SHOW_TREDUCED, params.get(SHOW_TREDUCED));
        engineModel.addCustom(SHOW_INCRED, params.get(SHOW_INCRED));
        engineModel.addCustom("draftpurpose", params.get("draftpurpose"));
        engineModel.addCustom(LEVY_TYPE, params.get(LEVY_TYPE));
        engineModel.addCustom("operateType", params.get("operateType"));
        DynamicObject policy = SeasonalPolicyService.getPolicy(Long.parseLong(engineModel.getOrgId()), DateUtils.stringToDate2((String)engineModel.getStartDate()), DateUtils.stringToDate2((String)engineModel.getEndDate()), engineModel.getCustom().getOrDefault("draftpurpose", "nssb"));
        engineModel.addCustom("policy", (Object)policy);
        return engineModel;
    }

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        Instant start = Instant.now();
        this.feedbackProgress(5, ResManager.loadKDString((String)"\u6570\u636e\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e", (String)"YearCalcTask_0", (String)"taxc-tccit", (Object[])new Object[0]), null);
        String orgId = (String)params.get("orgid");
        String startdate = (String)params.get("startdate");
        String enddate = (String)params.get("enddate");
        String focusPage = (String)params.get("focusPage");
        EngineModel engineModel = this.createEngineModel(orgId, startdate, enddate, params);
        new SeasonalDraftEngineHandler().run(engineModel);
        this.feedbackProgress(100, null, null);
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("success", "true");
        result.put("orgid", orgId);
        result.put("skssqq", startdate);
        result.put("skssqz", enddate);
        result.put("focusPage", focusPage);
        this.feedbackCustomdata(result);
    }
}

