/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.calc;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.graph.BuilderYearEngineGraphService;
import kd.taxc.tccit.business.policy.YearPolicyService;

public class YearAdjustCalcTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(YearAdjustCalcTask.class);
    private static final BuilderYearEngineGraphService builderYearEngineGraphService = BuilderYearEngineGraphService.getInstance();

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        Object orgid = params.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)params.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)params.get("skssqz")));
        String nodeName = (String)params.get("nodeName");
        RequestContext.copyAndSet((RequestContext)rc);
        params.put("policy", YearPolicyService.getPolicy(Long.parseLong(orgid.toString()), skssqq, skssqz));
        try (TXHandle h = TX.required();){
            try {
                Map<String, IEngine> pluginMapper = builderYearEngineGraphService.getYearEnginePluginMapper();
                List<String> nodes = builderYearEngineGraphService.getTopologicallys(nodeName);
                for (String node : nodes) {
                    ((Observer)pluginMapper.get(node)).calcSummery(params);
                }
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", "true");
        result.putAll(params);
        this.feedbackCustomdata(result);
    }
}

