/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.calc;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.impl.CalcSummery;
import kd.taxc.tccit.business.engine.YearAccEngine;
import kd.taxc.tccit.business.policy.YearPolicyService;
import kd.taxc.tccit.common.utils.SmalltoolsUtils;
import org.apache.commons.collections.CollectionUtils;

public class YearCalcTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(YearCalcTask.class);

    public Map<String, Object> getCustomParamsInfos(String orgId, String startdate, String enddate, String declaretype, Boolean removeAdjustByHand) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("orglist", this.getYearPolicyOrgList(orgId, startdate, enddate));
        customParams.put("orgid", orgId);
        customParams.put("skssqq", startdate);
        customParams.put("skssqz", enddate);
        customParams.put("policy", YearPolicyService.getPolicy(Long.parseLong(orgId), DateUtils.stringToDate2((String)startdate), DateUtils.stringToDate2((String)enddate)));
        customParams.put("declaretype", declaretype);
        customParams.put("remove_adjust_by_hand", removeAdjustByHand);
        return customParams;
    }

    private EngineModel createEngineModel(Map<String, Object> customParams, String orgid, String startdate, String enddate) {
        EngineModel engineModel = new EngineModel(orgid, startdate, enddate);
        engineModel.addCustom("orglist", customParams.get("orglist"));
        engineModel.addCustom("declaretype", customParams.get("declaretype"));
        engineModel.addCustom("remove_adjust_by_hand", customParams.get("remove_adjust_by_hand"));
        return engineModel;
    }

    private List<String> getYearPolicyOrgList(String orgId, String startdate, String enddate) {
        DynamicObjectCollection treeentryentity;
        List<String> orglist = new ArrayList<String>();
        DynamicObject policy = YearPolicyService.getPolicy(Long.parseLong(orgId), DateUtils.stringToDate2((String)startdate), DateUtils.stringToDate2((String)enddate));
        if (policy != null && CollectionUtils.isEmpty(orglist = (treeentryentity = policy.getDynamicObjectCollection("treeentryentity")).stream().map(e -> e.getString("taxorg_id")).collect(Collectors.toList()))) {
            orglist.add(orgId);
        }
        return orglist;
    }

    public void customfeedbackProgress(int progress, String desc, Map<String, Object> customData) {
        this.feedbackProgress(progress, desc, customData);
    }

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        Instant start = Instant.now();
        this.feedbackProgress(5, ResManager.loadKDString((String)"\u6570\u636e\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e", (String)"YearCalcTask_0", (String)"taxc-tccit", (Object[])new Object[0]), null);
        String orgId = (String)params.get("orgId");
        String startdate = (String)params.get("startdate");
        String enddate = (String)params.get("enddate");
        String declaretype = (String)params.get("declaretype");
        Boolean removeAdjustByHand = (Boolean)params.get("remove_adjust_by_hand");
        String calcType = (String)params.get("calcType");
        String focuspage = (String)params.get("focuspage");
        Map<String, Object> customParamsInfos = this.getCustomParamsInfos(orgId, startdate, enddate, declaretype, removeAdjustByHand);
        EngineModel engineModel = this.createEngineModel(customParamsInfos, orgId, startdate, enddate);
        RequestContext.copyAndSet((RequestContext)rc);
        SmalltoolsUtils.printTimeAndThread("year engine start calc");
        YearAccEngine yearAccEngine = new YearAccEngine(this);
        yearAccEngine.runEngine(engineModel);
        Instant t1 = Instant.now();
        logger.info("\u5e74\u62a5\u6267\u884c\u5f15\u64ce\u8017\u65f6\uff1a" + Duration.between(start, t1).toMillis());
        CopyOnWriteArrayList<List<DynamicObject>> saveDetails = yearAccEngine.getSaveDetails();
        try (TXHandle h = TX.required();){
            try {
                yearAccEngine.deleteData(engineModel);
                Instant t2 = Instant.now();
                logger.info("\u5e74\u62a5\u6267\u884c\u5220\u9664\u8017\u65f6\uff1a" + Duration.between(t1, t2).toMillis());
                saveDetails.stream().forEach(s -> SaveServiceHelper.save((DynamicObject[])s.toArray(new DynamicObject[0])));
                Instant t3 = Instant.now();
                logger.info("\u5e74\u62a5\u6267\u884c\u4fdd\u5b58\u8017\u65f6\uff1a" + Duration.between(t2, t3).toMillis());
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
        Instant end = Instant.now();
        logger.info("\u5e74\u62a5\u89c4\u5219\u53d6\u6570\uff1a==========================cost:" + Duration.between(start, end).toMillis());
        new CalcSummery(this).notifyObservers(customParamsInfos);
        this.feedbackProgress(100, null, null);
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("success", "true");
        result.put("orgid", orgId);
        result.put("skssqq", startdate);
        result.put("skssqz", enddate);
        result.put("calcType", calcType);
        result.put("focuspage", focuspage);
        this.feedbackCustomdata(result);
    }
}

