/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.calc.impl;

import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.calc.Subject;
import kd.taxc.tccit.business.calc.YearCalcTask;
import kd.taxc.tccit.common.utils.SmalltoolsUtils;
import kd.taxc.tccit.formplugin.account.AdvertScriptTZFormPlugin;
import kd.taxc.tccit.formplugin.account.AssetAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.AssetDisposeTZFormPlugin;
import kd.taxc.tccit.formplugin.account.AssetExpenseFormPlugin;
import kd.taxc.tccit.formplugin.account.AssetsLossTZFormPlugin;
import kd.taxc.tccit.formplugin.account.AssetsReserveFormPlugin;
import kd.taxc.tccit.formplugin.account.BeforeTaxDeductTZFormPlugin;
import kd.taxc.tccit.formplugin.account.BusinessEntertainmentCostTZFormPlugin;
import kd.taxc.tccit.formplugin.account.CalcSummaryPagePlugin;
import kd.taxc.tccit.formplugin.account.DeductAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.DeductOtherTZFormPlugin;
import kd.taxc.tccit.formplugin.account.DeductPreferentialSummaryPlugin;
import kd.taxc.tccit.formplugin.account.DeductTZFormPlugin;
import kd.taxc.tccit.formplugin.account.DevJjkcTZFormPlugin;
import kd.taxc.tccit.formplugin.account.DksszbjTZFormPlugin;
import kd.taxc.tccit.formplugin.account.DkynssdeTZFormPlugin;
import kd.taxc.tccit.formplugin.account.DomesticAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.EduFullTZFormPlugin;
import kd.taxc.tccit.formplugin.account.EduLimitTZFormPlugin;
import kd.taxc.tccit.formplugin.account.FgyxjzzcFormPlugin;
import kd.taxc.tccit.formplugin.account.FhmstjdtzsyFormPlugin;
import kd.taxc.tccit.formplugin.account.FzjgSeftSummaryPlugin;
import kd.taxc.tccit.formplugin.account.GetReduceFormPlugin;
import kd.taxc.tccit.formplugin.account.GyjzbdsyTZFormPlugin;
import kd.taxc.tccit.formplugin.account.HhqyhhrTZFormPlugin;
import kd.taxc.tccit.formplugin.account.HighTechFormPlugin;
import kd.taxc.tccit.formplugin.account.HznsqySeftSummaryPlugin;
import kd.taxc.tccit.formplugin.account.IncomeAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.IncomeOtherTZFormPlugin;
import kd.taxc.tccit.formplugin.account.InsuranceTZFormPlugin;
import kd.taxc.tccit.formplugin.account.InterestTZFormPlugin;
import kd.taxc.tccit.formplugin.account.InvestProfitTZFormPlugin;
import kd.taxc.tccit.formplugin.account.JmyhhzDgFormPlugin;
import kd.taxc.tccit.formplugin.account.MbyqndksFormPlugin;
import kd.taxc.tccit.formplugin.account.MbyqndksjsdgFormPlugin;
import kd.taxc.tccit.formplugin.account.MsjjHzdgSummaryPlugin;
import kd.taxc.tccit.formplugin.account.NonInsuranceTZFormPlugin;
import kd.taxc.tccit.formplugin.account.OtherFreeTaxFormPlugin;
import kd.taxc.tccit.formplugin.account.OtherHighTechFormPlugin;
import kd.taxc.tccit.formplugin.account.OtherOtherTZFormPlugin;
import kd.taxc.tccit.formplugin.account.OtherSpecTZFormPlugin;
import kd.taxc.tccit.formplugin.account.PeriodTZFormPlugin;
import kd.taxc.tccit.formplugin.account.ProfitCostTZFormPlugin;
import kd.taxc.tccit.formplugin.account.ProfitFeesTZFormPlugin;
import kd.taxc.tccit.formplugin.account.ProfitIncomeTZFormPlugin;
import kd.taxc.tccit.formplugin.account.QekcdgyxjzFormPlugin;
import kd.taxc.tccit.formplugin.account.QshczzyqrdgxsdtzdgFormPlugin;
import kd.taxc.tccit.formplugin.account.QtSalaryTZFormPlugin;
import kd.taxc.tccit.formplugin.account.QttzHzdgSummaryPlugin;
import kd.taxc.tccit.formplugin.account.QyczjdynsTZFormPlugin;
import kd.taxc.tccit.formplugin.account.RightsIncomeTZFormPlugin;
import kd.taxc.tccit.formplugin.account.SalaryTZFormPlugin;
import kd.taxc.tccit.formplugin.account.SaleZkzrthTZFormPlugin;
import kd.taxc.tccit.formplugin.account.SejsSetzSummaryPlugin;
import kd.taxc.tccit.formplugin.account.SmallEnterprisesTZFormPlugin;
import kd.taxc.tccit.formplugin.account.SoftIcTZFormPlugin;
import kd.taxc.tccit.formplugin.account.SonGetReduceFormPlugin;
import kd.taxc.tccit.formplugin.account.SpecOtherTZFormPlugin;
import kd.taxc.tccit.formplugin.account.ThinkOfSellFormPlugin;
import kd.taxc.tccit.formplugin.account.TssxHzdgSummaryPlugin;
import kd.taxc.tccit.formplugin.account.TzzccscbtzTZFormPlugin;
import kd.taxc.tccit.formplugin.account.XekcgyxFormPlugin;
import kd.taxc.tccit.formplugin.account.YhTaxCreditFormPlugin;
import kd.taxc.tccit.formplugin.account.ZcOtherTZFormPlugin;
import kd.taxc.tccit.formplugin.account.ZczjtxFormPlugin;
import kd.taxc.tccit.formplugin.account.ZeroRatingFormPlugin;
import kd.taxc.tccit.formplugin.year.dg.lrqr.A100000_1_DGFormPlugin;
import kd.taxc.tccit.formplugin.year.dg.lrqr.A101020_DGFormPlugin;
import kd.taxc.tccit.formplugin.year.dg.lrqr.A102020_DGFormPlugin;
import kd.taxc.tccit.formplugin.year.dg.lrqr.A103000_DGFormPlugin;
import kd.taxc.tccit.formplugin.year.dg.sdtz.B105093_DGFormPlugin;

public class CalcSummery
implements Subject {
    private static ExecutorService executorService = ThreadPools.newExecutorService((String)"TccitCalcSummaryThread", (int)10);
    private static Log logger = LogFactory.getLog(CalcSummery.class);
    private YearCalcTask task;
    private List<IEngine> profitList = Lists.newArrayList((Object[])new IEngine[]{new ProfitFeesTZFormPlugin(), new ProfitCostTZFormPlugin(), new ProfitIncomeTZFormPlugin(), new A101020_DGFormPlugin(), new A102020_DGFormPlugin(), new A103000_DGFormPlugin(), new A100000_1_DGFormPlugin()});
    private List<IEngine> firstAdjustList = Lists.newArrayList((Object[])new IEngine[]{new DomesticAdjustFormPlugin(), new GetReduceFormPlugin(), new MbyqndksFormPlugin(), new MbyqndksjsdgFormPlugin(), new DkynssdeTZFormPlugin(), new SejsSetzSummaryPlugin()});
    private List<IEngine> secondAdjustList = Lists.newArrayList((Object[])new IEngine[]{new IncomeAdjustFormPlugin(), new DeductAdjustFormPlugin(), new ThinkOfSellFormPlugin(), new AssetAdjustFormPlugin(), new TssxHzdgSummaryPlugin(), new QttzHzdgSummaryPlugin(), new MsjjHzdgSummaryPlugin(), new YhTaxCreditFormPlugin(), new DeductPreferentialSummaryPlugin(), new HznsqySeftSummaryPlugin(), new SonGetReduceFormPlugin("B105050"), new SonGetReduceFormPlugin("B105051")});
    private List<IEngine> thirdAdjustList = Lists.newArrayList((Object[])new IEngine[]{new ZeroRatingFormPlugin(), new QshczzyqrdgxsdtzdgFormPlugin(), new AssetDisposeTZFormPlugin(), new IncomeOtherTZFormPlugin(), new GyjzbdsyTZFormPlugin(), new RightsIncomeTZFormPlugin(), new SaleZkzrthTZFormPlugin(), new InvestProfitTZFormPlugin(), new TzzccscbtzTZFormPlugin(), new QtSalaryTZFormPlugin(), new PeriodTZFormPlugin(), new BeforeTaxDeductTZFormPlugin(), new NonInsuranceTZFormPlugin(), new XekcgyxFormPlugin(), new QekcdgyxjzFormPlugin(), new InterestTZFormPlugin(), new AdvertScriptTZFormPlugin(), new BusinessEntertainmentCostTZFormPlugin(), new InsuranceTZFormPlugin(), new JmyhhzDgFormPlugin(), new EduFullTZFormPlugin(), new EduLimitTZFormPlugin(), new SalaryTZFormPlugin(), new DeductTZFormPlugin(), new AssetsLossTZFormPlugin(), new ZczjtxFormPlugin("B105046"), new AssetExpenseFormPlugin(), new ZcOtherTZFormPlugin(), new AssetsReserveFormPlugin(), new SpecOtherTZFormPlugin(), new HhqyhhrTZFormPlugin(), new DksszbjTZFormPlugin(), new QyczjdynsTZFormPlugin(), new OtherSpecTZFormPlugin(), new OtherOtherTZFormPlugin(), new OtherFreeTaxFormPlugin(), new FhmstjdtzsyFormPlugin(), new DevJjkcTZFormPlugin(), new SmallEnterprisesTZFormPlugin(), new FgyxjzzcFormPlugin(), new B105093_DGFormPlugin(), new DeductOtherTZFormPlugin(), new HighTechFormPlugin(), new SoftIcTZFormPlugin(), new FzjgSeftSummaryPlugin()});
    private List<IEngine> fourthAdjustList = Lists.newArrayList((Object[])new IEngine[]{new ZczjtxFormPlugin("B105046-1"), new OtherHighTechFormPlugin()});
    private List<IEngine> calcSummaryList = Lists.newArrayList((Object[])new IEngine[]{new CalcSummaryPagePlugin()});

    public CalcSummery(YearCalcTask task) {
        this.task = task;
    }

    public CalcSummery() {
    }

    @Override
    public void registerObserver(Observer o) {
    }

    @Override
    public void notifyObservers(Map<String, Object> customParams) {
        Instant start = Instant.now();
        RequestContext requestContext = RequestContext.getOrCreate();
        CompletionStage completableFuture = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> {
            RequestContext.copyAndSet((RequestContext)requestContext);
            SmalltoolsUtils.printTimeAndThread("profit draft start calc");
            this.createTask(customParams, this.profitList);
            Optional.ofNullable(this.task).ifPresent(t -> t.customfeedbackProgress(73, null, null));
        }, executorService).thenApplyAsync(s -> {
            SmalltoolsUtils.printTimeAndThread("last result\uff1a" + s);
            RequestContext.copyAndSet((RequestContext)requestContext);
            SmalltoolsUtils.printTimeAndThread("adjust level 4 start calc");
            this.createTask(customParams, this.fourthAdjustList);
            Optional.ofNullable(this.task).ifPresent(t -> t.customfeedbackProgress(75, null, null));
            return "success1";
        }, (Executor)executorService)).thenApplyAsync(s -> {
            SmalltoolsUtils.printTimeAndThread("last result\uff1a" + s);
            RequestContext.copyAndSet((RequestContext)requestContext);
            SmalltoolsUtils.printTimeAndThread("adjust level 3 start calc");
            this.createTask(customParams, this.thirdAdjustList);
            Optional.ofNullable(this.task).ifPresent(t -> t.customfeedbackProgress(90, null, null));
            return "success2";
        }, (Executor)executorService)).thenApplyAsync(s -> {
            SmalltoolsUtils.printTimeAndThread("last result\uff1a" + s);
            RequestContext.copyAndSet((RequestContext)requestContext);
            SmalltoolsUtils.printTimeAndThread("adjust level 2 start calc");
            this.createTask(customParams, this.secondAdjustList);
            Optional.ofNullable(this.task).ifPresent(t -> t.customfeedbackProgress(93, null, null));
            return "success3";
        }, (Executor)executorService)).thenApplyAsync(s -> {
            SmalltoolsUtils.printTimeAndThread("last result\uff1a" + s);
            RequestContext.copyAndSet((RequestContext)requestContext);
            SmalltoolsUtils.printTimeAndThread("adjust level 1 start calc");
            this.createTask(customParams, this.firstAdjustList);
            Optional.ofNullable(this.task).ifPresent(t -> t.customfeedbackProgress(95, null, null));
            return "success4";
        }, (Executor)executorService)).thenApplyAsync(s -> {
            SmalltoolsUtils.printTimeAndThread("last result\uff1a" + s);
            RequestContext.copyAndSet((RequestContext)requestContext);
            SmalltoolsUtils.printTimeAndThread("summery calc start");
            this.createTask(customParams, this.calcSummaryList);
            Optional.ofNullable(this.task).ifPresent(t -> t.customfeedbackProgress(98, null, null));
            return "success5";
        }, (Executor)executorService)).exceptionally(e -> {
            logger.error("draft calc error:---------" + e.getMessage());
            return null;
        });
        try {
            String string = (String)((CompletableFuture)completableFuture).get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e2) {
            logger.error(e2.getMessage());
        }
        Instant end = Instant.now();
        logger.info("year draft calc\uff1a==========================cost:" + Duration.between(start, end).toMillis());
    }

    private void createTask(Map<String, Object> customParams, List calcList) {
        for (Object o : calcList) {
            ((Observer)o).calcSummery(customParams);
        }
    }

    public List<IEngine> getEngines() {
        ArrayList<IEngine> engines = new ArrayList<IEngine>();
        engines.addAll(this.profitList);
        engines.addAll(this.firstAdjustList);
        engines.addAll(this.secondAdjustList);
        engines.addAll(this.thirdAdjustList);
        engines.addAll(this.fourthAdjustList);
        engines.addAll(this.calcSummaryList);
        return engines;
    }
}

