/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.declare;

import com.google.common.collect.Lists;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class DeclareCompanyTypeService {
    private static final String STATUS_SUMMARIZE = "2";
    private static final String STATUS_UNSUMMARIZE = "3";
    private static final String WP01 = "WP01";
    private static final String WP11 = "WP11";
    private static final String WP02 = "WP02";
    private static final String WP12 = "WP12";
    private static final String WP03 = "WP03";
    private static final String WP13 = "WP13";
    private static final String WP04 = "WP04";
    private static final String WP14 = "WP14";
    private static final Charset UTF_8 = StandardCharsets.UTF_8;

    public static DynamicObject getOrgGroup(String orgid, String endDate) {
        Date date1 = DateUtils.stringToDate((String)endDate);
        QFilter orgFilter = new QFilter("orgrow.orgid", "=", (Object)Long.parseLong(StringUtil.isBlank((CharSequence)orgid) ? "0" : orgid));
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
        QFilter statusFilter = new QFilter("status", "=", (Object)STATUS_SUMMARIZE);
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject object = QueryServiceHelper.queryOne((String)"tctb_org_group_latest", (String)"effectdate,orgrow.orgid as orgid,orgrow.shareid as share,orgrow.declaration as declare,orgrow.parentid as parentid,orgrow.orgname as orgname", (QFilter[])new QFilter[]{taxtypeFilter, orgFilter, statusFilter, billstatusFilter, OrgUtils.getQFilter((Date)date1)});
        return object;
    }

    public static String getDeclareCompanyType(String orgid, String endDate) {
        DynamicObject orgGroup = DeclareCompanyTypeService.getOrgGroup(orgid, endDate);
        String declareType = "100";
        if (orgGroup != null) {
            String declaration = orgGroup.getString("declare");
            String share = orgGroup.getString("share");
            if (MessageDigest.isEqual(STATUS_SUMMARIZE.getBytes(UTF_8), declaration.getBytes(UTF_8)) && MessageDigest.isEqual("true".getBytes(UTF_8), share.getBytes(UTF_8))) {
                declareType = "210";
            } else if (MessageDigest.isEqual(STATUS_SUMMARIZE.getBytes(UTF_8), declaration.getBytes(UTF_8)) && MessageDigest.isEqual("false".getBytes(UTF_8), share.getBytes(UTF_8))) {
                declareType = "220";
            } else if (MessageDigest.isEqual(STATUS_UNSUMMARIZE.getBytes(UTF_8), declaration.getBytes(UTF_8)) && MessageDigest.isEqual("true".getBytes(UTF_8), share.getBytes(UTF_8))) {
                declareType = "311";
            } else if (MessageDigest.isEqual(STATUS_UNSUMMARIZE.getBytes(UTF_8), declaration.getBytes(UTF_8)) && MessageDigest.isEqual("false".getBytes(UTF_8), share.getBytes(UTF_8))) {
                declareType = "312";
            }
        }
        return declareType;
    }

    public static Boolean lessCurrentApply(String orgid, String endDate) {
        Date firstDateOfYear;
        DynamicObject orgGroup = DeclareCompanyTypeService.getOrgGroup(orgid, endDate);
        if (orgGroup == null) {
            return Boolean.FALSE;
        }
        Date effectdate = orgGroup.getDate("effectdate");
        if (effectdate.before(firstDateOfYear = DateUtils.getFirstDateOfYear((Date)DateUtils.stringToDate((String)endDate)))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isSmallType(String orgid, String startDate, String endDate, Boolean isFz) {
        DynamicObject orgGroup = DeclareCompanyTypeService.getOrgGroup(orgid, endDate);
        if (orgGroup == null) {
            return Boolean.FALSE;
        }
        Long id = isFz != false ? orgGroup.getLong("parentid") : orgGroup.getLong("orgid");
        HashMap<String, String> extendParams = new HashMap<String, String>();
        extendParams.put("declarestatus", "declared");
        DynamicObject dynamicObject = YbnsrService.queryYbnsr((String)String.valueOf(id), (String)"qysdsjb", (String)startDate, (String)endDate, (int)-12, extendParams);
        if (dynamicObject == null) {
            return Boolean.FALSE;
        }
        QFilter filter = new QFilter("sbbid", "=", (Object)dynamicObject.getString("id"));
        QFilter rowFilter = new QFilter("ewblxh", "=", (Object)"1");
        QFilter smallFilter = new QFilter("xxwlqy", "=", (Object)ResManager.loadKDString((String)"\u662f", (String)"DeclareCompanyTypeService_0", (String)"taxc-tccit", (Object[])new Object[0]));
        DynamicObject object = QueryServiceHelper.queryOne((String)"tccit_qysds_a000000", (String)"xxwlqy", (QFilter[])new QFilter[]{filter, rowFilter, smallFilter});
        return object != null;
    }

    public static Boolean noNeedApply(String declareCompanyType, String orgid, String startDate, String endDate) {
        if (declareCompanyType.equals("312")) {
            return true;
        }
        Boolean lessCurrentApply = DeclareCompanyTypeService.lessCurrentApply(orgid, endDate);
        Boolean isFz = declareCompanyType.equals("311") || declareCompanyType.equals("312");
        Boolean smallType = DeclareCompanyTypeService.isSmallType(orgid, startDate, endDate, isFz);
        return declareCompanyType.equals("311") && lessCurrentApply != false && smallType != false;
    }

    public static String getBusinesstype(String orgId, String startDate, String endDate) {
        String declareCompanyType = DeclareCompanyTypeService.getDeclareCompanyType(orgId, endDate);
        if ("100".equals(declareCompanyType) || "220".equals(declareCompanyType) || "230".equals(declareCompanyType)) {
            return "1";
        }
        if ("210".equals(declareCompanyType)) {
            Boolean smallType = DeclareCompanyTypeService.isSmallType(orgId, startDate, endDate, Boolean.FALSE);
            return smallType != false ? "1" : STATUS_SUMMARIZE;
        }
        if ("311".equals(declareCompanyType)) {
            return STATUS_UNSUMMARIZE;
        }
        return "";
    }

    public static String getDgType(String orgId, String endDate, String flag) {
        DynamicObject category = TaxBaseDataUtils.queryCategoryByTaxtype((Long)Long.parseLong(orgId), (String)"qysds");
        if (category == null) {
            return flag.equals("year") ? WP01 : WP11;
        }
        String residenttype = category.getString("residenttype");
        String levytype = category.getString("levytype");
        if ("fjmqy".equals(residenttype)) {
            return flag.equals("year") ? WP04 : WP14;
        }
        if (levytype.equals("hdzs")) {
            return flag.equals("year") ? WP03 : WP13;
        }
        if (levytype.equals("czzs")) {
            String declareCompanyType = DeclareCompanyTypeService.getDeclareCompanyType(orgId, endDate);
            if (Lists.newArrayList((Object[])new String[]{"100", "210", "220", "230"}).contains(declareCompanyType)) {
                return flag.equals("year") ? WP01 : WP11;
            }
            return flag.equals("year") ? WP02 : WP12;
        }
        return flag.equals("year") ? WP01 : WP11;
    }
}

