/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.declare.declarereportextentionpointserviceimpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttemplate.service.DeclareReportTemplateService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.refactor.formula.context.CalFormulaContext;
import kd.taxc.bdtaxr.common.refactor.formula.db.QueryFormulaService;
import kd.taxc.bdtaxr.common.refactor.template.domain.Style;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.tccit.business.policy.YearReportPreSelectService;

public class TccitNBReportTemplateServiceImpl
implements DeclareReportTemplateService {
    private static List<String> LOCK_CELLS = Arrays.asList("tccit_qysds_tab#A000000#tabname", "tccit_qysds_tab#A100000#tabname", "tccit_qysds_tab#A105000#tabname");

    public TemplateVo parseTemplateByCalResponse(TemplateVo template, DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, EntityField> typeMap) {
        ArrayList<QFilter> listFilters = new ArrayList<QFilter>();
        listFilters.add(new QFilter("formulakey", "in", YearReportPreSelectService.cellKeyList));
        listFilters.add(new QFilter("templateid", "=", (Object)String.valueOf(requestModel.getTemplateId())));
        listFilters.add(new QFilter("formulatype", "=", (Object)"1").or(new QFilter("formulatype", "=", (Object)"4")));
        Map formulaVoMap = QueryFormulaService.getFormulaVoMap(listFilters);
        CalFormulaContext c = new CalFormulaContext();
        HashMap initTableDataMap = new HashMap(YearReportPreSelectService.cellKeyList.size());
        c.calcUnknownKeys(initTableDataMap, new HashMap(requestModel.getBusinessMap()), formulaVoMap, typeMap);
        template.getTemplate().stream().forEach(e -> e.getRowList().stream().forEach(l -> l.stream().forEach(t -> {
            String cellKey = t.getCellKey();
            if (StringUtil.isBlank((CharSequence)cellKey)) {
                return;
            }
            if (LOCK_CELLS.contains(cellKey) || initTableDataMap.containsKey(cellKey) && ((String)initTableDataMap.get(cellKey)).equals("1")) {
                Style style = t.getStyle();
                if (style == null) {
                    style = new Style();
                }
                style.setLocked(Boolean.valueOf(true));
                t.setStyle(style);
            }
        })));
        return template;
    }
}

