/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.declare.initparam;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.declare.initparam.TccitSInitParams;

public class TccitHdzsInitParams
extends TccitSInitParams {
    private static final String PREPERIODSBBID = "preperiodsbbid";

    @Override
    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        Map<String, String> param = super.buildBizParam(requestModel);
        param.put(PREPERIODSBBID, this.getPrePeriodSbbid(requestModel.getOrgId().toString(), requestModel.getSkssqq(), requestModel.getSkssqz()));
        return param;
    }

    private String getPrePeriodSbbid(String orgId, String startDate, String endDate) {
        if (Objects.equals(startDate, DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)DateUtils.stringToDate((String)startDate))))) {
            return "";
        }
        List dateList = DateUtils.getPreDate((Date)DateUtils.stringToDate((String)startDate), (Date)DateUtils.stringToDate((String)endDate));
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)((Date)dateList.get(0))))).and(new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)((Date)dateList.get(1))))));
        QFilter typeFilter = new QFilter("type", "=", (Object)"qysds_hdzs_jb");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{dateFilter, orgFilter, typeFilter});
        if (CollectionUtils.isEmpty((Collection)objects)) {
            return "";
        }
        return ((DynamicObject)objects.get(0)).getString("id");
    }
}

