/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.declare.initparam;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.initparam.DefaultInitParams;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.declare.DeclareCompanyTypeService;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.common.utils.DateRangeUtils;

public class TccitSInitParams
extends DefaultInitParams {
    private static Log logger = LogFactory.getLog(TccitSInitParams.class);
    public static final String QYSDSYB = "qysdsyb";
    public static final String QYSDSJB = "qysdsjb";
    private static final String REGISTYEAR = "registyear";
    private static final String ADVANCE_PAY_MODE = "advancepaymode";
    private static final String BUSINESS_TYPE = "businesstype";
    private static final String REGISTMONTH = "registmonth";
    private static final String DECLARE_COMPANY_TYPE = "companytype";
    private static final String PREYEARSBBID = "preyearsbbid";
    private static final String PREPERIODSBBID = "preperiodsbbid";
    private static final String LASTYEAR_STARTDATE = "lastYearStartDate";
    private static final String LASTYEAR_ENDDATE = "lastYearEndDate";
    private static final String BEGINYEAR = "beginYear";
    private static final String ENDYEAR = "endYear";
    private static final String YJ_FZJGMC = "yj_fzjgmc";
    private static final String FZJGMC = "fzjgmc";
    private static final String YJ_FZJGNSRSBH = "yj_fzjgnsrsbh";
    private static final String FZJGNSRSBH = "fzjgnsrsbh";
    private static final String IS_FANGDICHAN_COMPANY = "isfangdichan";
    private static final String ZJG_SBBID = "zjgSbbid";
    private static final String REGISTERTIME = "registertime";
    private static final String IS_GX_TAX = "isGXTax";

    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        Map param = super.buildBizParam(requestModel);
        HashMap<String, String> extendParams = new HashMap<String, String>();
        extendParams.put("declarestatus", "declared");
        String preStartData = DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)DateUtils.stringToDate((String)requestModel.getSkssqq()), (int)-1)));
        String preEndData = DateUtils.format((Date)DateUtils.getLastDateOfYear((Date)DateUtils.addYear((Date)DateUtils.stringToDate((String)requestModel.getSkssqz()), (int)-1)));
        String lastSeasonEndDate = DateUtils.format((Date)DateUtils.addMonth((Date)DateUtils.stringToDate((String)requestModel.getSkssqz()), (int)-3));
        DynamicObject preYear = YbnsrService.queryYbnsr((String)requestModel.getOrgId().toString(), (String)"qysdsnb", (String)preStartData, (String)preEndData, (int)0, extendParams);
        String beginYear = DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)DateUtils.stringToDate((String)requestModel.getSkssqq())));
        String endYear = DateUtils.format((Date)DateUtils.getLastDateOfYear((Date)DateUtils.stringToDate((String)requestModel.getSkssqz())));
        Date registertime = null;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)requestModel.getOrgId());
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            registertime = ((DynamicObject)result.getData()).getDate(REGISTERTIME);
        }
        param.put(REGISTYEAR, registertime != null ? String.valueOf(DateUtils.getYearOfDate(registertime)) : "");
        param.put(REGISTMONTH, registertime != null ? String.valueOf(DateUtils.getMonthOfDate((Date)registertime)) : "");
        param.put(ADVANCE_PAY_MODE, this.getAdvancePayMode(requestModel.getTemplateType(), requestModel.getOrgId().toString(), requestModel.getSkssqq(), requestModel.getSkssqz()));
        param.put(BUSINESS_TYPE, DeclareCompanyTypeService.getBusinesstype(requestModel.getOrgId().toString(), requestModel.getSkssqq(), requestModel.getSkssqz()));
        param.put(DECLARE_COMPANY_TYPE, DeclareCompanyTypeService.getDeclareCompanyType(requestModel.getOrgId().toString(), requestModel.getSkssqz()));
        param.put(PREYEARSBBID, preYear != null ? preYear.getString("id") : "");
        param.put(PREPERIODSBBID, this.getPrePeriodSbbid(requestModel.getOrgId().toString(), requestModel.getSkssqq(), requestModel.getSkssqz()));
        param.put(LASTYEAR_STARTDATE, preStartData);
        param.put(LASTYEAR_ENDDATE, preEndData);
        param.put(BEGINYEAR, beginYear);
        param.put(ENDYEAR, endYear);
        param.put("moth", String.valueOf(DateUtils.stringToDate((String)requestModel.getSkssqq()).getMonth() + 1));
        param.put("lastSeasonEndDate", lastSeasonEndDate);
        DynamicObject fzjgInfos = this.getFzjgInfos(requestModel.getOrgId(), DateUtils.stringToDate((String)requestModel.getSkssqq()), DateUtils.stringToDate((String)requestModel.getSkssqz()));
        param.put(YJ_FZJGMC, Optional.ofNullable(fzjgInfos).map(s -> s.getString("taxpayer")).orElseGet(() -> ""));
        param.put(YJ_FZJGNSRSBH, Optional.ofNullable(fzjgInfos).map(s -> s.getString("unifiedsocialcode")).orElseGet(() -> ""));
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)requestModel.getOrgId()).getData();
        param.put(IS_FANGDICHAN_COMPANY, this.getIsFangdichanCompany(taxMain));
        param.put(ZJG_SBBID, this.getZjgSbbid(requestModel.getOrgId(), DateUtils.stringToDate((String)requestModel.getSkssqq()), DateUtils.stringToDate((String)requestModel.getSkssqz())));
        param.put(FZJGMC, Optional.ofNullable(this.getBastaxTaxorgInfo(requestModel.getOrgId())).map(s -> s.getString("taxpayer")).orElseGet(() -> ""));
        param.put(FZJGNSRSBH, Optional.ofNullable(this.getBastaxTaxorgInfo(requestModel.getOrgId())).map(s -> s.getString("unifiedsocialcode")).orElseGet(() -> ""));
        param.put("registeraddress", OrgGroupService.getRegisteraddressId(requestModel.getOrgId().toString(), requestModel.getSkssqq(), requestModel.getSkssqz()));
        Boolean isSzHasGroup = this.isSzHasGroup(requestModel.getOrgId()) != false && OrgGroupService.isFzjg(requestModel.getOrgId(), DateUtils.stringToDate2((String)requestModel.getSkssqz()));
        param.put("isSzHasGroup", isSzHasGroup.toString());
        param.put(REGISTERTIME, this.getBusRegistrationQuarter(requestModel.getOrgId().toString(), requestModel.getSkssqq()));
        DynamicObject taxoffice = taxMain.getDynamicObject("taxoffice");
        param.put(IS_GX_TAX, String.valueOf("14500000000".equals(taxoffice.getString("longnumber")) && "1".equals(param.get(BUSINESS_TYPE))));
        return param;
    }

    private String getBusRegistrationQuarter(String orgId, String startDate) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            String year = startDate.substring(0, 4);
            Date registertime = ((DynamicObject)result.getData()).getDate(REGISTERTIME);
            int yearOfDate = DateUtils.getYearOfDate((Date)registertime);
            if (yearOfDate == Integer.parseInt(year)) {
                String quarter = DateRangeUtils.getQuarter(DateUtils.format((Date)registertime), DateUtils.format((Date)registertime));
                if ("quarter2".equals(quarter)) {
                    return "2";
                }
                if ("quarter3".equals(quarter)) {
                    return "3";
                }
                if ("quarter4".equals(quarter)) {
                    return "4";
                }
                return "1";
            }
        }
        return "1";
    }

    private String getZjgSbbid(Long orgId, Date startDate, Date endDate) {
        DynamicObject orgDeclarePlan = this.getOrgDeclarePlan(orgId, startDate, endDate);
        if (orgDeclarePlan != null && "3".equals(orgDeclarePlan.getString("declaration"))) {
            long groupId = orgDeclarePlan.getLong("id");
            long zjgOrgid = this.getGroupZjgOrg(groupId);
            return this.getZjgDeclareId(zjgOrgid, startDate, endDate);
        }
        return "0";
    }

    private String getZjgDeclareId(long zjgOrgid, Date startDate, Date endDate) {
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)startDate).and(new QFilter("skssqz", "=", (Object)endDate));
        QFilter typeFilter = new QFilter("type", "=", (Object)QYSDSJB);
        QFilter orgFilter = new QFilter("org", "=", (Object)zjgOrgid);
        DynamicObject objects = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{dateFilter, orgFilter, typeFilter});
        return Objects.isNull(objects) ? "0" : objects.getString("id");
    }

    private long getGroupZjgOrg(long groupId) {
        QFilter q1 = new QFilter("id", "=", (Object)groupId);
        QFilter q2 = new QFilter("orgrow.declaration", "=", (Object)"2");
        DynamicObject object = QueryServiceHelper.queryOne((String)"tctb_org_group_latest", (String)"orgrow.orgid as orgid", (QFilter[])new QFilter[]{q1, q2});
        return object.getLong("orgid");
    }

    private DynamicObject getFzjgInfos(Long orgid, Date startDate, Date endDate) {
        DynamicObject orgDeclarePlan = this.getOrgDeclarePlan(orgid, startDate, endDate);
        if (orgDeclarePlan != null) {
            String declaration = orgDeclarePlan.getString("declaration");
            if ("2".equals(declaration)) {
                return this.getBastaxTaxorgInfo(orgid);
            }
            if ("3".equals(declaration)) {
                String collectorg = orgDeclarePlan.getString("collectorg");
                Long id = StringUtil.isNotEmpty((CharSequence)collectorg) && !"null".equals(collectorg) ? Long.parseLong(collectorg) : 0L;
                return this.getBastaxTaxorgInfo(id);
            }
        }
        return null;
    }

    private DynamicObject getBastaxTaxorgInfo(Long orgid) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        return QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"unifiedsocialcode, taxpayer", (QFilter[])new QFilter[]{orgFilter});
    }

    public DynamicObject getOrgDeclarePlan(Long orgid, Date startDate, Date endDate) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter q1 = new QFilter("orgrow.orgid", "=", (Object)orgid);
        QFilter q2 = new QFilter("taxtype", "=", (Object)"qysds");
        QFilter q4 = new QFilter("effectdate", "<=", (Object)startDate);
        QFilter q5 = new QFilter("invaliddate", "is null", null).or(new QFilter("invaliddate", ">=", (Object)endDate));
        return QueryServiceHelper.queryOne((String)"tctb_org_group_latest", (String)"id,orgrow.orgid as orgid,orgrow.collectorg as collectorg,orgrow.declaration as declaration", (QFilter[])new QFilter[]{statusFilter, q1, q2, q4, q5});
    }

    private String getAdvancePayMode(String type, String orgId, String startDate, String endDate) {
        String sbbid = "";
        String taxLimit = DateUtils.getTaxLimit((Date)DateUtils.stringToDate2((String)startDate), (Date)DateUtils.stringToDate2((String)endDate));
        if ("month".equals(taxLimit)) {
            sbbid = YbnsrService.queryYbnsrPre((String)orgId, (String)type, (String)startDate, (String)endDate, (int)-1);
        } else if ("season".equals(taxLimit)) {
            sbbid = YbnsrService.queryYbnsrPre((String)orgId, (String)type, (String)startDate, (String)endDate, (int)-3);
        }
        QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)sbbid);
        QFilter rowFilter = new QFilter("ewblxh", "=", (Object)"1");
        DynamicObject dynamiczb = QueryServiceHelper.queryOne((String)"tccit_qysds_zb", (String)ADVANCE_PAY_MODE, (QFilter[])new QFilter[]{rowFilter, sbbidFilter});
        return dynamiczb != null ? dynamiczb.getString(ADVANCE_PAY_MODE) : "1";
    }

    private String getPrePeriodSbbid(String orgId, String startDate, String endDate) {
        if (Objects.equals(startDate, DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)DateUtils.stringToDate((String)startDate))))) {
            return "";
        }
        List dateList = DateUtils.getPreDate((Date)DateUtils.stringToDate((String)startDate), (Date)DateUtils.stringToDate((String)endDate));
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)((Date)dateList.get(0))))).and(new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)((Date)dateList.get(1))))));
        QFilter typeFilter = new QFilter("type", "=", (Object)QYSDSJB);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{dateFilter, orgFilter, typeFilter});
        if (CollectionUtils.isEmpty((Collection)objects)) {
            return "";
        }
        return ((DynamicObject)objects.get(0)).getString("id");
    }

    private String getIsFangdichanCompany(DynamicObject taxMain) {
        String isfangdichan = String.valueOf(this.getNumberByName(taxMain, "codeandname.id"));
        if (isfangdichan.startsWith("70")) {
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    private int getNumberByName(DynamicObject taxMain, String column) {
        int number = 0;
        if (taxMain == null) {
            return number;
        }
        try {
            number = taxMain.getInt(column);
        }
        catch (Exception e) {
            logger.error("getNumberByName\u5f02\u5e38", (Throwable)e);
        }
        return number;
    }

    private Boolean isSzHasGroup(Long orgId) {
        String longnumber;
        String[] split;
        DynamicObject object;
        long registeraddress;
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        if (taxResult.isSuccess() && (registeraddress = ((DynamicObject)taxResult.getData()).getLong("registeraddress")) != 0L && (object = BusinessDataServiceHelper.loadSingle((Object)registeraddress, (String)"bd_admindivision")) != null && (split = (longnumber = object.getString("longnumber")).split("\\.")).length > 1) {
            String level2Number = split[1];
            DynamicObject level2 = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"id,name,simplespell", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)level2Number)});
            return level2 != null && "SZS".equals(level2.getString("simplespell"));
        }
        return Boolean.FALSE;
    }
}

