/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.draft;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleEnginEntityTypeEnum;
import kd.taxc.bdtaxr.common.dto.RuleEngineDto;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.engine.YearAccEngine;
import kd.taxc.tccit.common.utils.TaxRuleConstantUtils;

public class AccountingCaliberService {
    public List<DynamicObject> execute(EngineModel model, Long taxorgid, DynamicObjectCollection ruleSetAccounting, String taxaccountserialno, String entityType) {
        Date startdate = DateUtils.stringToDate((String)model.getStartDate());
        Date enddate = DateUtils.stringToDate((String)model.getEndDate());
        Map<String, Map<String, List<QFilter>>> ruleFilterMap = TaxRuleConstantUtils.getRuleFilterMap();
        RuleEngineDto ruleEngineDto = new RuleEngineDto(taxorgid, Long.valueOf(Long.parseLong(model.getOrgId())), startdate, enddate, entityType, ruleFilterMap, ruleSetAccounting);
        HashMap ctxMap = new HashMap(16);
        ctxMap.put("orgRelationMap", model.getCustom().get("orgRelationMap"));
        ctxMap.put("fiBdAccounts", model.getCustom().get("fiBdAccounts"));
        ruleEngineDto.setCxtMap(ctxMap);
        ruleEngineDto.setTaxaccountserialno(taxaccountserialno);
        if (YearAccEngine.getEntityItemMapping().containsKey(entityType)) {
            ruleEngineDto.setRuleEnginEntityType(RuleEnginEntityTypeEnum.YEAR_ACC_ENGINE.getEntityType());
        } else if ("tccit_yj_profits_accdet".equals(entityType) || "tccit_yj_profits_acc_sjjt".equals(entityType)) {
            ruleEngineDto.setRuleEnginEntityType(RuleEnginEntityTypeEnum.TCCIT_YJ_PROFITS_ACCDET.getEntityType());
        } else if ("tccit_yj_assets_accdet".equals(entityType) || "tccit_yj_assets_acc_sjjt".equals(entityType)) {
            ruleEngineDto.setRuleEnginEntityType(RuleEnginEntityTypeEnum.TCCIT_YJ_ASSETS_ACCDET.getEntityType());
        } else if ("tccit_fdctdyw_accdetail".equals(entityType) || "tccit_fdc_acc_sjjt".equals(entityType)) {
            ruleEngineDto.setRuleEnginEntityType(RuleEnginEntityTypeEnum.TCCIT_YJ_OTHER_ACCDET.getEntityType());
        } else if ("tccit_techtrans_accdetail".equals(entityType) || "tccit_tech_acc_sjjt".equals(entityType)) {
            ruleEngineDto.setRuleEnginEntityType(RuleEnginEntityTypeEnum.TCCIT_TECHTRANS_ACCDETAIL.getEntityType());
        } else if ("tccit_incred_accdetail".equals(entityType) || "tccit_incred_acc_sjjt".equals(entityType)) {
            ruleEngineDto.setRuleEnginEntityType(RuleEnginEntityTypeEnum.TCCIT_INCRED_ACCDETAIL.getEntityType());
        } else if ("tccit_treduced_accdetail".equals(entityType) || "tccit_treduced_acc_sjjt".equals(entityType)) {
            ruleEngineDto.setRuleEnginEntityType(RuleEnginEntityTypeEnum.TCCIT_TREDUCED_ACCDETAIL.getEntityType());
        } else if ("tccit_nontax_accdetail".equals(entityType) || "tccit_nontax_acc_sjjt".equals(entityType)) {
            ruleEngineDto.setRuleEnginEntityType(RuleEnginEntityTypeEnum.TCCIT_NONTAX_ACCDETAIL.getEntityType());
        }
        ruleEngineDto.setTaxCategoryId(DeclareTaxType.QYSDS.getBaseTaxId());
        return (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleEnginService", (String)"getRuleEnginData", (Object[])new Object[]{ruleEngineDto});
    }
}

