/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.draft;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tccit.common.enums.AddDeductionScene;
import kd.taxc.tccit.common.utils.LocalDateUtils;

public class AddDeductionService {
    public static AddDeductionScene isSuitEndDate(String draftPurpose, Boolean isAjsb, Date date) {
        Optional<LocalDate> optional = Optional.ofNullable(LocalDateUtils.date2LocalDate(date));
        if (!optional.isPresent()) {
            return AddDeductionScene.nodisplay_noclac;
        }
        LocalDate localDate = optional.get();
        int year = localDate.getYear();
        if ("sjjt".equals(draftPurpose) && year >= 2023 && isAjsb.booleanValue()) {
            if (localDate.isBefore(LocalDate.of(year, 3, 31)) || localDate.isEqual(LocalDate.of(year, 3, 31))) {
                return AddDeductionScene.nodisplay_noclac;
            }
            if (!localDate.isBefore(LocalDate.of(year, 4, 30)) && !localDate.isAfter(LocalDate.of(year, 9, 30))) {
                return AddDeductionScene.display_calc;
            }
        }
        if (localDate.isBefore(LocalDate.of(year, 6, 30))) {
            return AddDeductionScene.nodisplay_noclac;
        }
        if (localDate.isEqual(LocalDate.of(year, 6, 30)) || localDate.isEqual(LocalDate.of(year, 9, 30))) {
            return AddDeductionScene.display_calc;
        }
        if (localDate.isEqual(LocalDate.of(year, 7, 31)) || localDate.isEqual(LocalDate.of(year, 8, 31))) {
            return AddDeductionScene.display_last_month;
        }
        if (localDate.isAfter(LocalDate.of(year, 9, 30))) {
            return AddDeductionScene.display_last_rule;
        }
        return AddDeductionScene.nodisplay_noclac;
    }

    public static BigDecimal queryLastPeriodData(String orgId, Long taxorgid, String startDate, String endDate, Long ruleId, String entityName) {
        int monthDiff = DateUtils.getMonthDiff((Date)DateUtils.stringToDate2((String)startDate), (Date)DateUtils.stringToDate2((String)endDate));
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter q2 = new QFilter("skssqq", "=", (Object)DateUtils.addMonth((Date)DateUtils.stringToDate2((String)startDate), (int)(-monthDiff)));
        QFilter q3 = new QFilter("skssqz", "=", (Object)DateUtils.getLastDateOfMonth1((Date)DateUtils.addMonth((Date)DateUtils.stringToDate2((String)endDate), (int)(-monthDiff))));
        QFilter q4 = new QFilter("rule", "=", (Object)ruleId);
        QFilter q5 = new QFilter("taxorg", "=", (Object)taxorgid);
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)MetadataUtil.getAllFieldToQuery((String)entityName), (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        return CollectionUtils.isEmpty((Collection)query) ? BigDecimal.ZERO : query.stream().map(s -> s.getBigDecimal("income")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

