/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.draft;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import org.apache.commons.collections.CollectionUtils;

public class ApportionService {
    public List<DynamicObject> getBranchShareBills(EngineModel model) {
        String orgId = model.getOrgId();
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        String orgFuId = OrgUtils.queryOrgGroupDetailForAggregator((String)"qysds", (String)"1", (String)orgId, (Date)startDate, (Date)endDate);
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)startDate);
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)startDate);
        QFilter periodFilter = new QFilter("period", ">=", (Object)firstDateOfYear).and("period", "<=", (Object)lastDateOfYear);
        QFilter orgEnableFilter = new QFilter("org.enable", "=", (Object)"1");
        QFilter uasbleFilter = new QFilter("usable", "=", (Object)"1");
        DynamicObjectCollection sumSchemes = QueryServiceHelper.query((String)"tccit_branch_share_bill", (String)"sumscheme,id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(orgId)), periodFilter, orgEnableFilter, uasbleFilter});
        if (CollectionUtils.isEmpty((Collection)sumSchemes)) {
            return Lists.newArrayList();
        }
        DynamicObject scheme = null;
        for (DynamicObject sumScheme : sumSchemes) {
            if (this.isExpire(sumScheme, startDate, endDate)) continue;
            scheme = sumScheme;
            break;
        }
        if (scheme == null) {
            return Lists.newArrayList();
        }
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter shareidFilter = new QFilter("shareid", "=", (Object)"true");
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"tccit_branch_share_bill", (String)"org,org.name,orgname,hbfnszt,income,salary,asset,sharerate,participation", (QFilter[])new QFilter[]{new QFilter("sumscheme", "=", scheme.get("sumscheme")), periodFilter, statusFilter, orgEnableFilter, shareidFilter, uasbleFilter});
        ArrayList<DynamicObject> orgBranchShareBills = new ArrayList<DynamicObject>(bills.size());
        if (null != orgFuId) {
            for (DynamicObject row : bills) {
                if (!orgId.equals(row.getString("org"))) continue;
                orgBranchShareBills.add(row);
                break;
            }
        } else {
            orgBranchShareBills.addAll((Collection<DynamicObject>)bills);
        }
        return orgBranchShareBills;
    }

    private boolean isExpire(DynamicObject sumscheme, Date start, Date end) {
        if (sumscheme == null) {
            return true;
        }
        DynamicObject object = QueryServiceHelper.queryOne((String)"tctb_org_group_latest", (String)"status,billstatus,effectdate,invaliddate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sumscheme.getLong("sumscheme"))});
        if (object == null || !"2".equals(object.getString("status")) || !"C".equals(object.getString("billstatus"))) {
            return true;
        }
        Date effectdate = object.getDate("effectdate");
        Date invaliddate = object.getDate("invaliddate");
        return effectdate.compareTo(start) > 0 || invaliddate != null && invaliddate.compareTo(end) < 0;
    }

    public DynamicObject[] querySecondStepTaxSplitDraft(Map<String, Object> customParams, DraftTypeObjectVo draftTypeObjectVo) {
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        QFilter yearFilter = new QFilter("year", "=", (Object)0);
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        String declaretype = (String)customParams.get("declaretype");
        DynamicObject[] dynamicObjects = new DynamicObject[]{};
        if ("210".equals(declaretype)) {
            dynamicObjects = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getApportion().getNumber(), (String)"id,taxorg,taxorgname,taxorgname1,unifiedsocialcode,unifiedsocialcode1,income,emolument,totalassets,rate", (QFilter[])new QFilter[]{orgFilter, yearFilter, startFilter, endFilter});
        } else if ("311".equals(declaretype)) {
            QFilter taxorgFilter = new QFilter("taxorg", "=", (Object)Long.parseLong((String)orgid));
            dynamicObjects = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getApportion().getNumber(), (String)"id,taxorg,taxorgname,taxorgname1,unifiedsocialcode,unifiedsocialcode1,income,emolument,totalassets,rate", (QFilter[])new QFilter[]{taxorgFilter, yearFilter, startFilter, endFilter});
        }
        return dynamicObjects;
    }

    public List<DynamicObject> getBranchOrgList(Long orgid, String startDate, String endDate) {
        EngineModel model = new EngineModel(String.valueOf(orgid), startDate, endDate);
        List<DynamicObject> branchShareBills = this.getBranchShareBills(model);
        if (CollectionUtils.isEmpty(branchShareBills)) {
            return new ArrayList<DynamicObject>();
        }
        List branchOrgIdList = branchShareBills.stream().filter(b -> "1".equals(b.getString("hbfnszt"))).map(b -> b.getLong("org")).collect(Collectors.toList());
        return (List)TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(branchOrgIdList).getData();
    }
}

