/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.draft;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.sbb.SbbQueryService;
import kd.taxc.tccit.common.utils.SeasonalNameTypeUtils;

public class BranchCalcPageService {
    private static final String ITEM_NO = "itemno";
    private static final String ITEM_TYPE = "itemtype";
    private static final String NAME = "name";
    private static final String SUM_AMOUNT = "sumamount";
    private static final String ORGID = "org";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String TYPE = "type";
    private static final String TYPE_BRANCH = "2";
    private static final String TCCIT_SEASONAL_CALC_DET = "tccit_seasonal_calc_det";
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();

    public void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        QFilter typeFilter = new QFilter(TYPE, "=", (Object)TYPE_BRANCH);
        DeleteServiceHelper.delete((String)TCCIT_SEASONAL_CALC_DET, (QFilter[])new QFilter[]{orgFilter, dateFilter, typeFilter});
    }

    private String getName(Map<String, String> map, String itemType) {
        return map.get(itemType);
    }

    public void updateYearDraftData(Long orgid, Date skssqq, Date skssqz, BigDecimal fpssde, BigDecimal ybtsdse) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter templateFilter = new QFilter("templatetype", "=", (Object)"draft_qysdsnb");
        QFilter skssqqFilter = new QFilter("startdate", "=", (Object)skssqq);
        QFilter skssqzFilter = new QFilter("enddate", "=", (Object)skssqz);
        DynamicObject bill = QueryServiceHelper.queryOne((String)"tccit_year_dg_bill", (String)"id,billno", (QFilter[])new QFilter[]{orgFilter, templateFilter, skssqqFilter, skssqzFilter});
        if (bill != null) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)bill.get("id"), (String)"tccit_year_dg_bill");
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            DynamicObject sub = CollectionUtils.isEmpty((Collection)entryentity) ? entryentity.addNew() : (DynamicObject)entryentity.get(0);
            BigDecimal bnybtsdse = ybtsdse.compareTo(BigDecimal.ZERO) == 0 ? fpssde : ybtsdse;
            sub.set("taxamount", (Object)BigDecimal.ZERO);
            sub.set("sumpaytaxamount", (Object)BigDecimal.ZERO);
            sub.set("bnybtsdse", (Object)bnybtsdse);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public void updateData(QFilter orgFilter, QFilter skssqqFilter, QFilter skssqzFilter, String itemNo, BigDecimal amount, String type) {
        DynamicObject object = this.getSeasonalCalcDet(orgFilter, skssqqFilter, skssqzFilter, new QFilter(ITEM_TYPE, "=", (Object)itemNo), type);
        if (object != null) {
            object.set(SUM_AMOUNT, (Object)amount);
            SaveServiceHelper.update((DynamicObject)object);
            this.putDataMap(itemNo, SUM_AMOUNT, amount);
        }
    }

    public BigDecimal putDataMap(String rowType, String columnType, BigDecimal amount) {
        amount = amount.setScale(2, 4);
        this.dataMap.put(this.getKey(rowType, columnType), amount);
        return amount;
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public DynamicObject getSeasonalCalcDet(QFilter orgFilter, QFilter skssqqFilter, QFilter skssqzFilter, QFilter typeFilter, String type) {
        QFilter filter = new QFilter(TYPE, "=", (Object)type);
        DynamicObject dynamicObjects = BusinessDataServiceHelper.loadSingle((String)TCCIT_SEASONAL_CALC_DET, (String)"id,itemno,itemtype,sumamount", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, typeFilter, filter});
        return dynamicObjects;
    }

    private BigDecimal branchCalc(String rowType, String columnType, Long orgid, Date skssqq, Date skssqz) {
        DynamicObject dynamicObject = SbbQueryService.queryQysdsA109010Fz(skssqq, skssqz, String.valueOf(orgid));
        QFilter orgIdFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter skssqqFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        QFilter skssqzFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        if ("1".equals(rowType)) {
            BigDecimal fpbl = dynamicObject != null ? dynamicObject.getBigDecimal("fpbl").multiply(new BigDecimal(100)) : BigDecimal.ZERO;
            return this.putDataMap(rowType, columnType, fpbl);
        }
        if (TYPE_BRANCH.equals(rowType)) {
            BigDecimal fpssde = dynamicObject != null ? dynamicObject.getBigDecimal("fpse") : BigDecimal.ZERO;
            this.dataMap.put("fpse", fpssde);
            return this.putDataMap(rowType, columnType, fpssde);
        }
        if ("3".equals(rowType)) {
            DynamicObject object = this.getSeasonalCalcDet(orgIdFilter, skssqqFilter, skssqzFilter, new QFilter(ITEM_TYPE, "=", (Object)rowType), TYPE_BRANCH);
            BigDecimal amount = object != null ? object.getBigDecimal(SUM_AMOUNT) : BigDecimal.ZERO;
            return this.putDataMap(rowType, columnType, amount);
        }
        if ("4".equals(rowType)) {
            BigDecimal row2 = this.dataMap.getOrDefault(this.getKey(TYPE_BRANCH, columnType), BigDecimal.ZERO);
            BigDecimal row3 = this.dataMap.getOrDefault(this.getKey("3", columnType), BigDecimal.ZERO);
            BigDecimal row4 = row2.multiply(new BigDecimal("0.4")).multiply(row3).divide(new BigDecimal("100"), 2, 4);
            return this.putDataMap(rowType, columnType, row4);
        }
        if ("5".equals(rowType)) {
            BigDecimal row5 = BigDecimal.ZERO;
            BigDecimal row3 = this.dataMap.getOrDefault(this.getKey("3", columnType), BigDecimal.ZERO);
            if (row3.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal row2 = this.dataMap.getOrDefault(this.getKey(TYPE_BRANCH, columnType), BigDecimal.ZERO);
                BigDecimal row4 = this.dataMap.getOrDefault(this.getKey("4", columnType), BigDecimal.ZERO);
                row5 = row2.subtract(row4);
            }
            this.dataMap.put("ybtsdse", row5);
            return this.putDataMap(rowType, columnType, row5);
        }
        return BigDecimal.ZERO;
    }

    public DynamicObject[] buildBranchOfficeSummary(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        ArrayList showItems = Lists.newArrayList((Object[])new String[]{"1", TYPE_BRANCH, "3", "4", "5"});
        DynamicObjectCollection sum = new DynamicObjectCollection();
        Map<String, String> branchNameMap = SeasonalNameTypeUtils.getInstance().getBranchNameMap();
        for (String itemType : showItems) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_SEASONAL_CALC_DET);
            dynamicObject.set(ITEM_NO, (Object)itemType);
            dynamicObject.set(ITEM_TYPE, (Object)itemType);
            dynamicObject.set(NAME, (Object)this.getName(branchNameMap, itemType));
            dynamicObject.set(SUM_AMOUNT, (Object)this.branchCalc(itemType, SUM_AMOUNT, orgid, skssqq, skssqz));
            dynamicObject.set(TYPE, (Object)TYPE_BRANCH);
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        BigDecimal fpssde = this.dataMap.get("fpse");
        BigDecimal ybtsdse = this.dataMap.get("ybtsdse");
        this.updateYearDraftData(orgid, skssqq, skssqz, fpssde, ybtsdse);
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    public DynamicObjectCollection querySeasonalSplitSjjtCollection(Map<String, Object> customParams) {
        QFilter filters = this.buildSeasonalSplitSjjtFilter(customParams);
        return QueryServiceHelper.query((String)"tccit_seasonal_split_sjjt", (String)"id,unifiedsocialcode,branchorgid,branchspiltratio,branchybtse,branchreductionratio,branchreductiontax,sjybtsdse,itemno15sum,qbfzjgftbl", (QFilter[])new QFilter[]{filters});
    }

    public DynamicObject[] loadSeasonalSplitSjjtCollection(Map<String, Object> customParams) {
        QFilter filters = this.buildSeasonalSplitSjjtFilter(customParams);
        return BusinessDataServiceHelper.load((String)"tccit_seasonal_split_sjjt", (String)"id,unifiedsocialcode,branchorgid,branchspiltratio,branchybtse,branchreductionratio,branchreductiontax,sjybtsdse,itemno15sum,qbfzjgftbl", (QFilter[])new QFilter[]{filters});
    }

    private QFilter buildSeasonalSplitSjjtFilter(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate2((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate2((String)((String)customParams.get(SKSSQZ)));
        return new QFilter(ORGID, "=", (Object)orgid).and(new QFilter(SKSSQQ, "=", (Object)skssqq)).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
    }

    public boolean checkBeforeCalcSplit(String draftpurpose, String declaretype, String levytype, String billstatus) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("draftpurpose", draftpurpose);
        customParams.put("declaretype", declaretype);
        customParams.put("levytype", levytype);
        customParams.put("billstatus", billstatus);
        return this.checkBeforeCalcSplit(customParams);
    }

    public boolean checkBeforeCalcSplit(Map<String, Object> customParams) {
        if (this.checkBeforeCalcSplitWithoutBillStatus(customParams)) {
            return false;
        }
        return !this.checkBillstatus(customParams);
    }

    public boolean checkBeforeCalcSplitWithoutBillStatus(Map<String, Object> customParams) {
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        if (!"sjjt".equals(draftpurpose)) {
            return true;
        }
        String declaretype = (String)customParams.get("declaretype");
        if (!("210".equals(declaretype) || "220".equals(declaretype) || "230".equals(declaretype))) {
            return true;
        }
        String levytype = (String)customParams.get("levytype");
        return !"czzs".equals(levytype);
    }

    public boolean checkBillstatus(Map<String, Object> customParams) {
        String billstatus = (String)customParams.getOrDefault("billstatus", "A");
        return !billstatus.equals("A");
    }
}

