/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.draft;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.declare.servicehelper.TaxDeclareServiceHelper;
import kd.taxc.tccit.business.draft.DeadlineService;
import org.apache.commons.collections4.CollectionUtils;

public class CitrtaService {
    public static final String CITRTA_ENTITY = "tccit_citrta_query";
    public static final String JTDRAFT_ENTITY = "tccit_sjjt_list";
    public static final String DECLARE_ENTITY = "tccit_query_report";
    private static final Long ROWMEMBER = 1929212778455774208L;
    private static final Long FZJGMC_COLMEMBER = 1929214111548192768L;

    public List<Long> queryYbnsrOrgIdsWithPerm(long userId, String appid, String entityid) {
        TaxResult result;
        List data;
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)userId, (String)appid, (String)entityid, (String)"47150e89000000ac");
        if (taxResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)taxResult.getData())) && (result = TaxcMainDataServiceHelper.queryTaxcMainQysdsByOrgIds((List)data)).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            return ((List)result.getData()).stream().filter(taxMain -> {
                DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
                boolean defaultFjmqy = taxMain.get("registertype") != null && 350 <= taxMain.getInt("registertype.number") && 359 >= taxMain.getInt("registertype.number");
                return CollectionUtils.isNotEmpty((Collection)categoryentryentity) && ("jmqy".equals(((DynamicObject)categoryentryentity.get(0)).getString("residenttype")) || StringUtil.isBlank((CharSequence)((DynamicObject)categoryentryentity.get(0)).getString("residenttype")) && !defaultFjmqy) && "czzs".equals(((DynamicObject)categoryentryentity.get(0)).getString("levytype")) && "1".equals(((DynamicObject)categoryentryentity.get(0)).getString("enable"));
            }).map(o -> o.getLong("orgid.id")).distinct().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<Long> querySjjtDraftIds(Long orgId, String templatetype, Date startDate, Date endDate) {
        QFilter q1 = new QFilter("skssqq", ">=", (Object)startDate).and(new QFilter("skssqz", "<=", (Object)endDate));
        QFilter q3 = new QFilter("billstatus", "=", (Object)"C");
        QFilter q4 = new QFilter("org", "=", (Object)orgId);
        QFilter q5 = new QFilter("type", "=", (Object)"WP11");
        QFilter q6 = new QFilter("templatetype", "=", (Object)templatetype);
        String declareLimit = TaxDeclareServiceHelper.getOrgLimit(orgId);
        String jtzq = DeadlineService.getCurrentTaxCycle(orgId);
        if ("aysb".equals(declareLimit) && "season".equals(jtzq)) {
            q1 = new QFilter("skssqz", "=", (Object)endDate);
        }
        DynamicObjectCollection draftCollect = QueryServiceHelper.query((String)JTDRAFT_ENTITY, (String)"id", (QFilter[])new QFilter[]{q1, q3, q4, q5, q6});
        return draftCollect.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> querySbbIds(Long orgId, String templatetype, Date startDate, Date endDate) {
        QFilter q1 = new QFilter("skssqq", "=", (Object)startDate).and(new QFilter("skssqz", "=", (Object)endDate));
        QFilter q2 = new QFilter("org", "=", (Object)orgId);
        QFilter q3 = new QFilter("templatetype", "=", (Object)"CITRTA");
        DynamicObject DraftObj = QueryServiceHelper.queryOne((String)CITRTA_ENTITY, (String)"id", (QFilter[])new QFilter[]{q1, q2, q3});
        if (DraftObj == null) {
            return new ArrayList<Long>(0);
        }
        Long draftId = DraftObj.getLong("id");
        QFilter draftFilter = new QFilter("entryid", "=", (Object)draftId);
        QFilter rowFilter = new QFilter("row", "=", (Object)ROWMEMBER);
        QFilter colFilter = new QFilter("column", "=", (Object)FZJGMC_COLMEMBER);
        DynamicObjectCollection branchOrgList = QueryServiceHelper.query((String)"tpo_declare_detail_tsd", (String)"value,entryid,index,row,column", (QFilter[])new QFilter[]{draftFilter, rowFilter, colFilter});
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        orgIds.add(orgId);
        if (CollectionUtils.isNotEmpty((Collection)branchOrgList)) {
            for (DynamicObject obj : branchOrgList) {
                try {
                    Long org = Long.valueOf(obj.getString("value"));
                    orgIds.add(org);
                }
                catch (NumberFormatException org) {}
            }
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter and = new QFilter("org", "in", orgIds).and(new QFilter("type", "=", (Object)templatetype));
        filterList.add(and);
        filterList.add(new QFilter("skssqq", "=", (Object)startDate).and(new QFilter("skssqz", "=", (Object)endDate)));
        filterList.add(new QFilter("declarestatus", "=", (Object)"declared"));
        DynamicObjectCollection sbbCollect = QueryServiceHelper.query((String)DECLARE_ENTITY, (String)"id", (QFilter[])filterList.toArray(new QFilter[0]));
        return sbbCollect.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> querySbbIdsByCache(Long orgId, String templatetype, Date startDate, Date endDate, DeclareResponseModel responseModel) {
        List dynRowList;
        String dynRowNo = "fzjgseftbd_1#1";
        String fzjgmcKey = "fzjgseftbd_1#fzjgmc";
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        orgIds.add(orgId);
        if (responseModel != null && CollectionUtils.isNotEmpty((Collection)responseModel.getDynRowList()) && CollectionUtils.isNotEmpty((Collection)(dynRowList = responseModel.getDynRowList()))) {
            List rowList;
            DynamicRowModel rowModel = dynRowList.stream().filter(e -> dynRowNo.equals(e.getDynRowNo())).findFirst().orElse(null);
            List list = rowList = rowModel == null ? null : rowModel.getRowList();
            if (rowList != null && CollectionUtils.isNotEmpty((Collection)rowList)) {
                for (Map map : rowList) {
                    try {
                        for (Map.Entry entry : map.entrySet()) {
                            String key = (String)entry.getKey();
                            if (!CitrtaService.matchKey(key, fzjgmcKey)) continue;
                            Long org = Long.valueOf((String)entry.getValue());
                            orgIds.add(org);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
            }
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter and = new QFilter("org", "in", orgIds).and(new QFilter("type", "=", (Object)templatetype));
        filterList.add(and);
        filterList.add(new QFilter("skssqq", "=", (Object)startDate).and(new QFilter("skssqz", "=", (Object)endDate)));
        filterList.add(new QFilter("declarestatus", "=", (Object)"declared"));
        DynamicObjectCollection sbbCollect = QueryServiceHelper.query((String)DECLARE_ENTITY, (String)"id", (QFilter[])filterList.toArray(new QFilter[0]));
        return sbbCollect.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    private static boolean matchKey(String key1, String key2) {
        String[] keys2;
        if (StringUtils.isBlank((CharSequence)key1) || StringUtils.isBlank((CharSequence)key2)) {
            return false;
        }
        String splitKey = "#";
        String[] keys1 = key1.split(splitKey);
        return keys1[0].equals((keys2 = key2.split(splitKey))[0]) && keys1[keys1.length - 1].equals(keys2[keys2.length - 1]);
    }

    public List<Long> queryPayRecordIds(Long orgId, String templatetype, Date startDate, Date endDate, List<Long> sbbIds) {
        QFilter filter = new QFilter("sbbid", "in", (Object)sbbIds.stream().map(Object::toString).toArray());
        DynamicObjectCollection draftCollect = QueryServiceHelper.query((String)"bdtaxr_pay_record", (String)"id", (QFilter[])new QFilter[]{filter});
        return draftCollect.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    public DynamicObject loadSingleVatRta(Long id) {
        if (id == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)CITRTA_ENTITY);
    }

    public DynamicObject queryOneVatRtaByBillno(String billNo) {
        if (StringUtils.isBlank((CharSequence)billNo)) {
            return null;
        }
        return QueryServiceHelper.queryOne((String)CITRTA_ENTITY, (String)"id,generatebusinessdoc", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
    }

    public ListShowParameter getJointSearchParameter(String entityName, List<Long> linkQueryPkIds, Map<String, Object> customParams) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.setBillFormId(entityName);
        for (Long pkId : linkQueryPkIds) {
            showParameter.addLinkQueryPkId((Object)pkId);
        }
        if (customParams != null && !customParams.isEmpty()) {
            showParameter.setCustomParams(customParams);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return showParameter;
    }

    public void getLogResultMessage(OperationResult operationResult, StringBuilder successMessage, StringBuilder failMessage) {
        List successPkIds = operationResult.getSuccessPkIds();
        Map billNos = operationResult.getBillNos();
        Set entries = billNos.entrySet();
        for (Map.Entry entry : entries) {
            if (successPkIds.contains(Long.valueOf(entry.getKey().toString()))) {
                if (successMessage.length() > 0) {
                    successMessage.append(" ");
                }
                successMessage.append((String)entry.getValue());
                continue;
            }
            if (failMessage.length() > 0) {
                failMessage.append(" ");
            }
            failMessage.append((String)entry.getValue());
        }
    }

    public ListShowParameter getProvistonBillPageParameter(String appid, String orgId, String taxsystem, String draftBillNo, String taxtype) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("itp_proviston_taxes");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isFromDraft", "true");
        hashMap.put("entitynumber", draftBillNo);
        hashMap.put("orgId", orgId);
        hashMap.put("taxsystem", taxsystem);
        hashMap.put("appid", appid);
        hashMap.put("taxtype.number", taxtype);
        listShowParameter.setCustomParams(hashMap);
        return listShowParameter;
    }

    public String processJtdMsg(OperationResult operationResult, String entityId, String operateName) {
        StringBuilder successMessage = new StringBuilder();
        StringBuilder failMessage = new StringBuilder();
        this.getLogResultMessage(operationResult, successMessage, failMessage);
        StringBuilder resultMessage = new StringBuilder();
        if (failMessage.length() > 0) {
            resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%s\u5931\u8d25\u3002", (String)"CitrtaService_0", (String)"taxc-tccit", (Object[])new Object[0]), failMessage + operateName));
        }
        if (successMessage.length() > 0) {
            resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801: %s\u6210\u529f\u3002", (String)"CitrtaService_1", (String)"taxc-tccit", (Object[])new Object[0]), successMessage + operateName));
        }
        OperatorDialogUtils.operateDialog((String)"CITRTA", (String)entityId, (String)operateName, (String)resultMessage.toString());
        return String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"CitrtaService_2", (String)"taxc-tccit", (Object[])new Object[0]), operateName);
    }

    public static boolean orgCheck(IFormView view, String orgId, String appid, String categoryType) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)view);
        return CitrtaService.orgCheck(view, orgId, appid, categoryType, hasPermOrgResult);
    }

    public static boolean orgCheck(IFormView view, String orgId, String appid, String categoryType, HasPermOrgResult hasPermOrgResult) {
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"id", (Object)orgId));
        if (EmptyCheckUtils.isEmpty((Object)orgId) || Objects.equals("0", orgId)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgCheckUtil_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return true;
        }
        String entityId = view.getEntityId();
        boolean isNoPermView = "rdesd_hzb_gx_declare".equalsIgnoreCase(entityId);
        if (!(isNoPermView || hasPermOrgResult.hasAllOrgPerm() || hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId)))) {
            String orgname = "";
            DynamicObject bosorg = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(orgId))});
            if (bosorg != null) {
                orgname = bosorg.getString("name");
            }
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"OrgCheckUtil_0", (String)"taxc-tccit", (Object[])new Object[0]), orgname));
            return true;
        }
        if (OrgCheckUtil.orgEnable((IFormView)view, (DynamicObjectCollection)org, (boolean)true)) {
            return true;
        }
        if (OrgCheckUtil.isTaxPayerAuth((IFormView)view, (String)orgId, (boolean)true)) {
            return true;
        }
        if (null != categoryType) {
            String categoryent = OrgCheckUtil.getCategoryentName((String)categoryType);
            QFilter qFilter = null;
            if (TaxAppEnum.TCRET.getCategoryCode().equals(categoryType)) {
                return false;
            }
            qFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)categoryType);
            QFilter taxationsys = new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId());
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQysdsByOrgIds(Collections.singletonList(Long.parseLong(orgId)));
            List list = new ArrayList();
            if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
                list = (List)result.getData();
            }
            if (list.size() > 0) {
                DynamicObject dy = (DynamicObject)list.get(0);
                DynamicObjectCollection col = dy.getDynamicObjectCollection("categoryentryentity");
                if (CollectionUtils.isEmpty((Collection)col)) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"OrgCheckUtil_3", (String)"taxc-tccit", (Object[])new Object[0]));
                    return true;
                }
                DynamicObject taxMain = (DynamicObject)col.get(0);
                if (Objects.equals("0", taxMain.getString("enable"))) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7%2$s\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckUtil_4", (String)"taxc-tccit", (Object[])new Object[0]), dy.getString("orgid.name"), categoryent));
                    return true;
                }
                if ("fjmqy".equals(taxMain.getString("residenttype"))) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u975e\u5c45\u6c11\u4f01\u4e1a\u6682\u4e0d\u652f\u6301\u6b64\u529f\u80fd\u3002", (String)"OrgCheckUtil_5", (String)"taxc-tccit", (Object[])new Object[0]));
                    return true;
                }
                if ("hdzs".equals(taxMain.getString("levytype"))) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u6838\u5b9a\u5f81\u6536\u7ec4\u7ec7\u6682\u4e0d\u652f\u6301\u6b64\u529f\u80fd\u3002", (String)"OrgCheckUtil_6", (String)"taxc-tccit", (Object[])new Object[0]));
                    return true;
                }
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"OrgCheckUtil_3", (String)"taxc-tccit", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }
}

