/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.draft;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.business.pojo.DataResultVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DraftMainService {
    public static final String ENTITY = "tctb_draft_main";
    public static final String TPO_DECLARE_MAIN_TSD = "tpo_declare_main_tsd";

    public static DynamicObjectCollection query(String templatetype, String orgid, String startdate, String enddate, String draftpurpose) {
        if ("sjjt".equals(draftpurpose)) {
            List<QFilter> list = DraftMainService.buildRangeQFilters(templatetype, orgid, startdate, enddate, draftpurpose);
            return QueryServiceHelper.query((String)TPO_DECLARE_MAIN_TSD, (String)"id,billno,status,type,skssqq as startdate,skssqz as enddate,billstatus,businessdocno as jtnumber", (QFilter[])list.toArray(new QFilter[0]));
        }
        List<QFilter> list = DraftMainService.buildRangeQFilters(templatetype, orgid, startdate, enddate, draftpurpose);
        return QueryServiceHelper.query((String)ENTITY, (String)"id,billno,status,type,startdate,enddate,billstatus,jtnumber", (QFilter[])list.toArray(new QFilter[0]));
    }

    private static List<QFilter> buildRangeQFilters(String templatetype, String orgid, String startdate, String enddate, String draftpurpose) {
        String draftpurposePros = StringUtils.isEmpty((CharSequence)draftpurpose) ? "nssb" : draftpurpose;
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("templatetype", "=", (Object)templatetype));
        if ("sjjt".equals(draftpurpose)) {
            list.add(new QFilter("skssqq", "<=", (Object)DateUtils.stringToDate((String)enddate)));
            list.add(new QFilter("skssqz", ">=", (Object)DateUtils.stringToDate((String)startdate)));
        } else {
            list.add(new QFilter("startdate", "<=", (Object)DateUtils.stringToDate((String)enddate)));
            list.add(new QFilter("enddate", ">=", (Object)DateUtils.stringToDate((String)startdate)));
        }
        list.add(new QFilter("org", "=", (Object)Long.parseLong(StringUtil.isNotBlank((CharSequence)orgid) ? orgid : "0")));
        list.add(new QFilter("draftpurpose", "=", (Object)draftpurposePros));
        return list;
    }

    public static boolean isSameLevyType(DynamicObjectCollection query, String levyType) {
        List collect = query.stream().map(s -> {
            if ("WP11".equals(s.getString("type"))) {
                return "czzs";
            }
            if ("WP13".equals(s.getString("type"))) {
                return "hdzs";
            }
            return "";
        }).collect(Collectors.toList());
        return collect.contains(levyType);
    }

    public static boolean isSamePeriod(DynamicObjectCollection query, Date startDate, Date endDate) {
        String target = DateUtils.format((Date)startDate) + DateUtils.format((Date)endDate);
        List collect = query.stream().map(s -> DateUtils.format((Date)s.getDate("startdate")) + DateUtils.format((Date)s.getDate("enddate"))).collect(Collectors.toList());
        return collect.contains(target);
    }

    public static DataResultVo hasIntersection(String orgId, String startDate, String endDate, String draftpurpose) {
        DataResultVo dataResultVo = DataResultVo.ok();
        DynamicObjectCollection query = DraftMainService.query("draft_qysdsjb", orgId, startDate, endDate, draftpurpose);
        String levyType = OrgGroupService.getLevyType(Long.parseLong(orgId));
        Boolean hasIntersection = CollectionUtils.isNotEmpty((Collection)query) && (!DraftMainService.isSamePeriod(query, DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate)) || !DraftMainService.isSameLevyType(query, levyType));
        if (hasIntersection.booleanValue()) {
            String billnos = query.stream().map(s -> s.getString("billno")).collect(Collectors.joining(","));
            String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5c5e\u671f\u5df2\u7ecf\u5b58\u5728\u5e95\u7a3f\u3010%s\u3011\uff0c\u8bf7\u5148\u5220\u9664\u5df2\u6709\u7684\u5e95\u7a3f\u518d\u65b0\u589e", (String)"DraftMainService_0", (String)"taxc-tccit", (Object[])new Object[0]), billnos);
            return DataResultVo.fail(msg);
        }
        return dataResultVo;
    }

    public static DynamicObject queryJtd(String entitynumber) {
        QFilter billNoQ = new QFilter("entitynumber", "=", (Object)entitynumber);
        DynamicObject jtdCollection = QueryServiceHelper.queryOne((String)"itp_proviston_taxes", (String)"billno,billstatus,entitynumber", (QFilter[])new QFilter[]{billNoQ});
        return jtdCollection;
    }

    public static void deleteJtd(DynamicObject dynamicObject) {
        DynamicObject jtdObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)"tccit_sjjt_list");
        jtdObject.set("generatebusinessdoc", (Object)Boolean.FALSE);
        jtdObject.set("businessdocno", (Object)"");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{jtdObject});
        QFilter billNoQ = new QFilter("entitynumber", "=", (Object)dynamicObject.getString("billno"));
        DeleteServiceHelper.delete((String)"itp_proviston_taxes", (QFilter[])new QFilter[]{billNoQ});
    }
}

