/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.draft;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DraftService {
    private static final String ORGID = "orgid";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    public static final String SUMMARY_ENTRY_NAME = "tccit_zctz_expense_sum";

    public static BigDecimal getSum(ArrayList<String> strings, String columnType, Map<String, BigDecimal> dataMap) {
        BigDecimal amount = BigDecimal.ZERO;
        for (String string : strings) {
            String key = DraftService.getKey(string, columnType);
            amount = amount.add(dataMap.get(key) == null ? BigDecimal.ZERO : dataMap.get(key));
        }
        return amount;
    }

    public static String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public static void clearCurrentPeriod(String entityNumber, Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)entityNumber, (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    public static ArrayList<QFilter> getQfilters(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        return Lists.newArrayList((Object[])new QFilter[]{orgFilter, dateFilter});
    }

    public static DynamicObject getYearDgBill(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter skssqqFilter = new QFilter("startdate", "=", (Object)skssqq);
        QFilter skssqzFilter = new QFilter("enddate", "=", (Object)skssqz);
        QFilter templateFilter = new QFilter("templatetype", "=", (Object)"draft_qysdsnb");
        DynamicObject bill = QueryServiceHelper.queryOne((String)"tccit_year_dg_bill", (String)"id,billno", (QFilter[])new QFilter[]{orgFilter, templateFilter, skssqqFilter, skssqzFilter});
        return Optional.ofNullable(bill).map(s -> BusinessDataServiceHelper.loadSingle((Object)s.get("id"), (String)"tccit_year_dg_bill")).orElseGet(() -> null);
    }

    public static DynamicObject getSeasonalDgBill(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter skssqqFilter = new QFilter("startdate", "=", (Object)skssqq);
        QFilter skssqzFilter = new QFilter("enddate", "=", (Object)skssqz);
        QFilter templateFilter = new QFilter("templatetype", "=", (Object)"draft_qysdsnb");
        DynamicObject bill = QueryServiceHelper.queryOne((String)"tccit_year_dg_bill", (String)"id,billno", (QFilter[])new QFilter[]{orgFilter, templateFilter, skssqqFilter, skssqzFilter});
        return Optional.ofNullable(bill).map(s -> BusinessDataServiceHelper.loadSingle((Object)s.get("id"), (String)"tccit_year_dg_bill")).orElseGet(() -> null);
    }

    public static DynamicObjectCollection getZctzExpenseSum(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DynamicObjectCollection result = QueryServiceHelper.query((String)SUMMARY_ENTRY_NAME, (String)"id,zzje,taxamount,nstzje", (QFilter[])new QFilter[]{orgFilter, dateFilter});
        return result;
    }
}

